/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.reconfigure.cronexpressionrest.fromscheduler.caesium.cron.parser;

import de.resolution.reconfigure.cronexpressionrest.fromscheduler.MapUtil;
import de.resolution.reconfigure.cronexpressionrest.fromscheduler.caesium.cron.parser.CronLexer;
import de.resolution.reconfigure.cronexpressionrest.fromscheduler.caesium.cron.parser.TokenType;
import de.resolution.reconfigure.cronexpressionrest.fromscheduler.cron.CronSyntaxException;
import de.resolution.reconfigure.cronexpressionrest.fromscheduler.cron.ErrorCode;
import java.util.Map;

class NameResolver {
    private static final Map<String, Integer> MONTH_NAMES = MapUtil.builder().put("JAN", 1).put("FEB", 2).put("MAR", 3).put("APR", 4).put("MAY", 5).put("JUN", 6).put("JUL", 7).put("AUG", 8).put("SEP", 9).put("OCT", 10).put("NOV", 11).put("DEC", 12).build();
    private static final Map<String, Integer> DAY_OF_WEEK_NAMES = MapUtil.builder().put("SUN", 1).put("MON", 2).put("TUE", 3).put("WED", 4).put("THU", 5).put("FRI", 6).put("SAT", 7).build();
    static final NameResolver MONTH = new NameResolver(MONTH_NAMES, ErrorCode.INVALID_NAME_MONTH);
    static final NameResolver DAY_OF_WEEK = new NameResolver(DAY_OF_WEEK_NAMES, ErrorCode.INVALID_NAME_DAY_OF_WEEK);
    private final Map<String, Integer> names;
    private final ErrorCode errorCode;

    private NameResolver(Map<String, Integer> names, ErrorCode errorCode) {
        this.names = names;
        this.errorCode = errorCode;
    }

    final int resolveName(CronLexer.Token token) throws CronSyntaxException {
        if (token.getType() != TokenType.NAME) {
            throw new IllegalArgumentException("Called name resolver with something that wasn't a NAME: " + String.valueOf(token));
        }
        String name = token.getText();
        Integer value = this.names.get(name);
        if (value == null) {
            throw CronSyntaxException.builder().cronExpression(token.getCronExpression()).errorCode(this.errorCode).errorOffset(token.getStart()).value(name).build();
        }
        return value;
    }
}

