/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.reconfigure.cronexpressionrest;

import de.resolution.reconfigure.cronexpressionrest.CronExpressionValidator;
import de.resolution.reconfigure.cronexpressionrest.fromscheduler.caesium.cron.parser.CronExpressionParser;
import de.resolution.reconfigure.cronexpressionrest.fromscheduler.caesium.cron.rule.CronExpression;
import de.resolution.reconfigure.cronexpressionrest.fromscheduler.caesium.cron.rule.DateTimeTemplate;
import de.resolution.reconfigure.cronexpressionrest.fromscheduler.cron.CronSyntaxException;
import jakarta.annotation.Nonnull;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.TimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class StandaloneCronExpressionValidator
implements CronExpressionValidator {
    private static final Logger logger = LoggerFactory.getLogger(StandaloneCronExpressionValidator.class);

    @Override
    public boolean isValid(String cronExpression) {
        return CronExpressionParser.isValid(cronExpression);
    }

    @Override
    public long getNextScheduledSyncAsLong(@Nonnull String cronString) {
        return this.getNextScheduledSyncAsLong(cronString, new Date());
    }

    public long getNextScheduledSyncAsLong(@Nonnull String cronString, @Nonnull Date date) {
        try {
            CronExpression cron = CronExpressionParser.parse(cronString);
            TimeZone timeZone = TimeZone.getDefault();
            DateTimeTemplate when = new DateTimeTemplate(date, timeZone.toZoneId());
            if (cron.next(when)) {
                ZonedDateTime zonedDateTime = when.toZonedDateTime();
                if (zonedDateTime == null) {
                    logger.warn("DateTimeTemplate {} could not be converted to ZonedDateTime, returning -1 as next scheduled time", (Object)when);
                    return -1L;
                }
                return zonedDateTime.toInstant().toEpochMilli();
            }
            return -1L;
        }
        catch (CronSyntaxException e) {
            return -1L;
        }
    }
}

