/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.reconfigure.cronexpressionrest;

import com.atlassian.confluence.api.service.accessmode.ReadOnlyAccessAllowed;
import com.atlassian.sal.api.user.UserProfile;
import de.resolution.reconfigure.InsufficientUserPrivilegeException;
import de.resolution.reconfigure.PrivilegeChecker;
import de.resolution.reconfigure.WebSudoRequiredException;
import de.resolution.reconfigure.api.Configuration;
import de.resolution.reconfigure.api.ConfigurationService;
import de.resolution.reconfigure.cronexpressionrest.CronExpressionRestType;
import de.resolution.reconfigure.cronexpressionrest.CronExpressionValidator;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.CacheControl;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@Path(value="/cronexpression")
public class CronExpressionRestResource<C extends Configuration> {
    private static final Logger logger = LoggerFactory.getLogger(CronExpressionRestResource.class);
    private final PrivilegeChecker privilegeChecker;
    private final ConfigurationService<C> configurationService;
    private static final String CC_NO_CACHE_VALUE = "no-cache, no-store, must-revalidate";
    private static final CacheControl CC_NO_CACHE = CacheControl.valueOf((String)"no-cache, no-store, must-revalidate");
    private final CronExpressionValidator cronExpressionValidator;

    @Autowired
    public CronExpressionRestResource(ConfigurationService<C> configurationService, PrivilegeChecker privilegeChecker, CronExpressionValidator cronExpressionValidator) {
        this.privilegeChecker = privilegeChecker;
        this.configurationService = configurationService;
        this.cronExpressionValidator = cronExpressionValidator;
    }

    @PUT
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @Path(value="/nextrun/{uiPath}")
    @ReadOnlyAccessAllowed
    public Response getNextSync(CronExpressionRestType cronExpression, @Context HttpServletRequest request, @PathParam(value="uiPath") String uiPath) throws InsufficientUserPrivilegeException, WebSudoRequiredException {
        UserProfile userProfile = this.privilegeChecker.checkPrivileges(request, this.configurationService.getRequiredPrivilege(this.privilegeChecker.getPrivilegeFactory(), PrivilegeChecker.AccessMode.READ, uiPath));
        this.privilegeChecker.requireWebSudo(this.configurationService.isWebSudoRequired(PrivilegeChecker.AccessMode.READ, request, userProfile, uiPath), request, null);
        long next = this.cronExpressionValidator.getNextScheduledSyncAsLong(cronExpression.cronExpression);
        return Response.ok((Object)new CronExpressionRestType("ok", next)).cacheControl(CC_NO_CACHE).build();
    }
}

