/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.reconfigure.bitbucketuserrest;

import com.atlassian.sal.api.user.UserProfile;
import de.resolution.reconfigure.InsufficientUserPrivilegeException;
import de.resolution.reconfigure.PrivilegeChecker;
import de.resolution.reconfigure.WebSudoRequiredException;
import de.resolution.reconfigure.api.Configuration;
import de.resolution.reconfigure.api.ConfigurationService;
import de.resolution.reconfigure.bitbucketuserrest.BitbucketRestResult;
import de.resolution.reconfigure.bitbucketuserrest.UserRest;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.CacheControl;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@Path(value="/applicationadapter")
public class BitbucketRestResource<C extends Configuration> {
    private static final Logger logger = LoggerFactory.getLogger(BitbucketRestResource.class);
    private static final String CC_NO_CACHE_VALUE = "no-cache, no-store, must-revalidate";
    private static final CacheControl CC_NO_CACHE = CacheControl.valueOf((String)"no-cache, no-store, must-revalidate");
    private final PrivilegeChecker privilegeChecker;
    private final ConfigurationService<C> configurationService;
    private final UserRest userRest;

    @Autowired
    public BitbucketRestResource(ConfigurationService<C> configurationService, PrivilegeChecker privilegeChecker, UserRest userRest) {
        this.privilegeChecker = privilegeChecker;
        this.configurationService = configurationService;
        this.userRest = userRest;
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/userattributes/{uiPath}")
    public Response getUserAttribute(@QueryParam(value="key") String key, @Context HttpServletRequest request, @PathParam(value="uiPath") String uiPath) throws WebSudoRequiredException, InsufficientUserPrivilegeException {
        UserProfile userProfile = this.privilegeChecker.checkPrivileges(request, this.configurationService.getRequiredPrivilege(this.privilegeChecker.getPrivilegeFactory(), PrivilegeChecker.AccessMode.READ, uiPath));
        this.privilegeChecker.requireWebSudo(this.configurationService.isWebSudoRequired(PrivilegeChecker.AccessMode.READ, request, userProfile, uiPath), request, null);
        int id = Integer.parseInt(key);
        BitbucketRestResult restResult = this.userRest.getUserById(id, true);
        if (restResult != null) {
            logger.debug("User found: {}, {}, {}", new Object[]{restResult.displayName, restResult.name, restResult.emailAddress});
            return Response.ok((Object)restResult).cacheControl(CC_NO_CACHE).build();
        }
        logger.info("User not found: {}", (Object)id);
        return Response.ok((Object)new BitbucketRestResult(id, key, "Unknown User", null)).cacheControl(CC_NO_CACHE).build();
    }
}

