/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.reconfigure.api;

import com.atlassian.sal.api.user.UserProfile;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.resolution.commons.validate.api.Validatable;
import de.resolution.commons.validate.api.ValidationResult;
import de.resolution.reconfigure.PrivilegeChecker;
import de.resolution.reconfigure.Utils;
import de.resolution.reconfigure.api.Configuration;
import de.resolution.reconfigure.api.ConfigurationLoadFailedException;
import de.resolution.reconfigure.api.ConfigurationSaveFailedException;
import de.resolution.reconfigure.api.FrontendDTO;
import de.resolution.reconfigure.frontenddefinition.DynamicFragmentProvider;
import de.resolution.reconfigure.frontenddefinition.FrontendDefinitionLoader;
import de.resolution.reconfigure.frontenddefinition.StringLoader;
import jakarta.annotation.Nullable;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.slf4j.LoggerFactory;

public interface ConfigurationService<C extends Configuration> {
    public static final int ANALYTICS_CONSENT_LEVEL_OPT_OUT = -1;
    public static final int ANALYTICS_CONSENT_LEVEL_USE_SYSTEM = 0;
    public static final int ANALYTICS_CONSENT_LEVEL_OPT_IN = 1;

    public String getPluginFamily();

    public Predicate<UserProfile> getRequiredPrivilege(PrivilegeChecker.PrivilegeFactory var1, PrivilegeChecker.AccessMode var2, String var3);

    default public boolean isWebSudoRequired(PrivilegeChecker.AccessMode accessMode, HttpServletRequest request, UserProfile userProfile, String uiPath) {
        return false;
    }

    public FrontendDTO<C> getFrontendDTO(HttpServletRequest var1, UserProfile var2, String var3) throws ConfigurationLoadFailedException;

    public ValidationResult validate(C var1, String var2);

    @Nullable
    default public ValidationResult validateFrontendStateFragment(String jsonString, String uiPath, String frontendStatePath) throws IOException {
        Class<Validatable> clazz = this.getFrontendStateValidatableClass(uiPath, frontendStatePath);
        Validatable validatable = DefaultValidatableDeserializer.deserialize(jsonString, clazz);
        return validatable.validate();
    }

    public C update(C var1, ValidationResult var2, String var3, UserProfile var4) throws ConfigurationSaveFailedException;

    public C getConfiguration(HttpServletRequest var1, UserProfile var2, String var3) throws ConfigurationLoadFailedException;

    default public int getAnalyticsConsentLevel() throws ConfigurationLoadFailedException {
        return -1;
    }

    default public Map<String, Object> getAnalyticsData(int effectiveConsentLevel) throws ConfigurationLoadFailedException {
        return null;
    }

    default public Map<String, Object> getSupportInformation(HttpServletRequest request, UserProfile userProfile, String uiPath, Map<String, Object> supportInformation, List<String> trackerIds) throws ConfigurationLoadFailedException {
        return null;
    }

    default public Class<? extends C> getConfigurationClass(String uiPath) {
        Type type = Stream.of(this.getClass().getGenericInterfaces()).map(ParameterizedType.class::cast).filter(parameterizedType -> ConfigurationService.class == parameterizedType.getRawType()).map(parameterizedInterfaceType -> parameterizedInterfaceType.getActualTypeArguments()[0]).findFirst().orElseThrow(IllegalStateException::new);
        Class clazz = (Class)type;
        return clazz;
    }

    default public Class<? extends Validatable> getFrontendStateValidatableClass(String uiPath, String frontendStatePath) {
        throw new UnsupportedOperationException("getFrontendStateValidatableClass not implemented");
    }

    default public Optional<String> getFrontendDefinition(String uiPath) {
        String identifier = "frontend-definition-" + uiPath + ".json";
        StringLoader stringLoader = StringLoader.create();
        try {
            String definition = FrontendDefinitionLoader.loadFrontendDefinition(identifier, stringLoader, this.getDynamicFragmentProvider());
            return Optional.of(definition);
        }
        catch (Exception e) {
            LoggerFactory.getLogger(ConfigurationService.class).error("Failed to load frontend-definition from {}", (Object)identifier, (Object)e);
            return Optional.empty();
        }
    }

    default public Optional<String> getFrontendDefinitionFragment(String uiPath, String identifier) {
        return Optional.empty();
    }

    default public DynamicFragmentProvider getDynamicFragmentProvider() {
        return new DynamicFragmentProvider.NullDynamicFragmentProvider();
    }

    default public void modifyMetaTags(UserProfile userProfile, String uiPath, Map<String, String> metaTags) {
    }

    public static class DefaultValidatableDeserializer {
        private static final ObjectMapper objectMapper = Utils.getObjectMapper();

        private DefaultValidatableDeserializer() {
        }

        private static Validatable deserialize(String json, Class<? extends Validatable> clazz) throws IOException {
            return (Validatable)objectMapper.readValue(json, clazz);
        }
    }
}

