/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.reconfigure.analytics;

import com.segment.analytics.Analytics;
import com.segment.analytics.Log;
import com.segment.analytics.messages.GroupMessage;
import com.segment.analytics.messages.IdentifyMessage;
import com.segment.analytics.messages.MessageBuilder;
import com.segment.analytics.messages.TrackMessage;
import de.resolution.reconfigure.Utils;
import de.resolution.reconfigure.analytics.ConfigAnalyticsPayload;
import de.resolution.reconfigure.api.AnalyticsSender;
import de.resolution.reconfigure.api.ApplicationInformation;
import de.resolution.reconfigure.api.ApplicationInformationProvider;
import de.resolution.reconfigure.api.PluginInformationProvider;
import jakarta.annotation.PreDestroy;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public class SegmentAnalyticsSender
implements AnalyticsSender {
    private static final Logger logger = LoggerFactory.getLogger(SegmentAnalyticsSender.class);
    public static final String SEGMENT_DEV_WRITE_KEY = "mFlOMZ8KJ1BEQjJMI1C5OCSXfjEHqnvs";
    public static final String SEGMENT_PROD_WRITE_KEY = "rx05E0pdYAosB9U97m3LDDkmEDyDuVIq";
    private final Analytics analytics;

    @Inject
    public SegmentAnalyticsSender(ApplicationInformationProvider applicationInformationProvider, PluginInformationProvider pluginInformationProvider) {
        String segmentWriteKey;
        Log appLogger = new Log(){

            public void print(Log.Level level, String format, Object ... args) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Segment Analytics: [{}] {}", (Object)level, (Object)String.format(format, args));
                }
            }

            public void print(Log.Level level, Throwable error, String format, Object ... args) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Segment Analytics: [{}] {}", new Object[]{level, String.format(format, args), error});
                }
            }
        };
        ApplicationInformation applicationInformation = applicationInformationProvider.getApplicationInformation(null);
        String baseUrl = applicationInformation.getApplicationBaseUrl();
        try {
            URL baseUrlParsed = new URL(baseUrl);
            String host = baseUrlParsed.getHost();
            String pluginVersion = pluginInformationProvider.getPluginInformation(null).getPluginVersion();
            segmentWriteKey = host.endsWith("lab.resolution.de") || host.endsWith("reslab.de") || pluginVersion.contains("SNAPSHOT") ? SEGMENT_DEV_WRITE_KEY : SEGMENT_PROD_WRITE_KEY;
        }
        catch (MalformedURLException e) {
            logger.debug("Error parsing baseUrl");
            segmentWriteKey = SEGMENT_PROD_WRITE_KEY;
        }
        this.analytics = Analytics.builder((String)segmentWriteKey).endpoint("https://support-improvements-api.resolution.de").log(appLogger).build();
    }

    @Override
    public void sendHeartbeat(ConfigAnalyticsPayload configAnalyticsPayload) {
        logger.debug("Preparing analytics payload for {}", (Object)configAnalyticsPayload.pluginKey);
        Map<String, Object> traits = new HashMap<String, Object>();
        traits.put("appInstanceFingerprint", configAnalyticsPayload.appInstanceFingerprint);
        traits.put("instanceFingerprint", configAnalyticsPayload.instanceFingerprint);
        Utils.flattenAndIntegrateWithPrefix(traits, configAnalyticsPayload.pluginFamily + "-config", configAnalyticsPayload.config);
        Utils.flattenAndIntegrateWithPrefix(traits, "plugin", configAnalyticsPayload.plugin);
        Utils.flattenAndIntegrateWithPrefix(traits, "host", configAnalyticsPayload.host);
        Utils.flattenAndIntegrateWithPrefix(traits, "license", configAnalyticsPayload.license);
        logger.debug("Cleaning up traits in analytics payload for {}", (Object)configAnalyticsPayload.pluginKey);
        try {
            traits = Utils.fixNullsInMap(traits);
        }
        catch (IOException e) {
            logger.debug("fixNullsInMap failed for traits for {}", (Object)configAnalyticsPayload.pluginKey, (Object)e);
        }
        Map<String, Object> groupTraits = new HashMap<String, Object>();
        groupTraits.put("instanceFingerprint", configAnalyticsPayload.instanceFingerprint);
        Utils.flattenAndIntegrateWithPrefix(groupTraits, "host", configAnalyticsPayload.host);
        Utils.flattenAndIntegrateWithPrefix(groupTraits, "license", configAnalyticsPayload.license);
        logger.debug("Cleaning up groupTraits in analytics payload for {}", (Object)configAnalyticsPayload.pluginKey);
        try {
            groupTraits = Utils.fixNullsInMap(groupTraits);
        }
        catch (IOException e) {
            logger.debug("fixNullsInMap failed for groupTraits for {}", (Object)configAnalyticsPayload.pluginKey, (Object)e);
        }
        logger.debug("Enqueueing analytics events for {}", (Object)configAnalyticsPayload.pluginKey);
        this.analytics.enqueue((MessageBuilder)((IdentifyMessage.Builder)IdentifyMessage.builder().userId(configAnalyticsPayload.appInstanceFingerprint)).traits(traits));
        this.analytics.enqueue((MessageBuilder)((GroupMessage.Builder)GroupMessage.builder((String)configAnalyticsPayload.instanceFingerprint).userId(configAnalyticsPayload.appInstanceFingerprint)).traits(groupTraits));
        this.analytics.enqueue((MessageBuilder)((TrackMessage.Builder)TrackMessage.builder((String)(configAnalyticsPayload.pluginFamily + " Heartbeat")).userId(configAnalyticsPayload.appInstanceFingerprint)).properties(traits));
        this.analytics.flush();
        logger.debug("Flushing analytics data for {}", (Object)configAnalyticsPayload.pluginKey);
    }

    @PreDestroy
    public void onStop() {
        this.analytics.shutdown();
    }
}

