/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.reconfigure.analytics;

import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.SchedulerServiceException;
import com.atlassian.scheduler.config.JobConfig;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.scheduler.config.RunMode;
import com.atlassian.scheduler.config.Schedule;
import de.resolution.reconfigure.api.AnalyticsProvider;
import jakarta.annotation.PreDestroy;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.security.SecureRandom;
import java.util.Date;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public class AnalyticsHeartbeatJobScheduler {
    private static final Logger logger = LoggerFactory.getLogger(AnalyticsHeartbeatJobScheduler.class);
    private static final Random RANDOM = new SecureRandom();
    private final SchedulerService schedulerService;
    private final JobId jobId;
    private final String pluginKey;
    private static final int MIN_DELAY = 1800000;
    private static final int MAX_JITTER = 10000;

    @Inject
    public AnalyticsHeartbeatJobScheduler(@ComponentImport SchedulerService schedulerService, AnalyticsProvider analyticsProvider) {
        this.schedulerService = schedulerService;
        this.jobId = JobId.of((String)analyticsProvider.getSchedulerKey());
        this.pluginKey = analyticsProvider.getPluginKey();
        int jitter = RANDOM.nextInt(10000);
        Date firstRun = new Date(System.currentTimeMillis() + 1800000L + (long)jitter);
        int intervalInMillis = 604800000;
        JobConfig jobConfig = JobConfig.forJobRunnerKey((JobRunnerKey)JobRunnerKey.of((String)analyticsProvider.getSchedulerKey())).withSchedule(Schedule.forInterval((long)intervalInMillis, (Date)firstRun)).withRunMode(RunMode.RUN_ONCE_PER_CLUSTER);
        try {
            logger.debug("Scheduling analytics heartbeat job {} with the interval {}, first run is {} (plugin key {})", new Object[]{this.jobId, intervalInMillis, firstRun, this.pluginKey});
            schedulerService.scheduleJob(this.jobId, jobConfig);
        }
        catch (SchedulerServiceException e) {
            logger.debug("Scheduling analytics heartbeat job failed!", (Throwable)e);
        }
    }

    @PreDestroy
    public void onStop() {
        logger.debug("Unscheduling analytics for {}", (Object)this.pluginKey);
        this.schedulerService.unscheduleJob(this.jobId);
    }
}

