/*
 * Decompiled with CFR 0.152.
 */
package de.resolution.reconfigure;

import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.atlassian.sal.api.xsrf.XsrfTokenAccessor;
import com.atlassian.templaterenderer.RenderingException;
import com.atlassian.templaterenderer.TemplateRenderer;
import de.resolution.commons.license.PluginProperties;
import de.resolution.reconfigure.PrivilegeChecker;
import de.resolution.reconfigure.ReconfigureProperties;
import de.resolution.reconfigure.Utils;
import de.resolution.reconfigure.WebSudoRequiredException;
import de.resolution.reconfigure.api.AnalyticsProvider;
import de.resolution.reconfigure.api.ApplicationInformationProvider;
import de.resolution.reconfigure.api.ConfigurationService;
import de.resolution.reconfigure.api.PluginInformation;
import de.resolution.reconfigure.api.PluginInformationProvider;
import de.resolution.reconfigure.api.UserInformationProvider;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.Writer;
import java.net.URI;
import java.util.HashMap;
import java.util.Optional;
import java.util.function.Predicate;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public class AdminServlet
extends HttpServlet {
    private static final Logger logger = LoggerFactory.getLogger(AdminServlet.class);
    private final UserManager userManager;
    private final LoginUriProvider loginUriProvider;
    private final TemplateRenderer renderer;
    private final XsrfTokenAccessor xsrfTokenAccessor;
    private final ConfigurationService<?> configurationService;
    private final ApplicationInformationProvider applicationInformationProvider;
    private final UserInformationProvider userInformationProvider;
    private final PrivilegeChecker privilegeChecker;
    private final PluginInformationProvider pluginInformationProvider;
    private final AnalyticsProvider analyticsProvider;

    @Inject
    public AdminServlet(@ComponentImport UserManager userManager, @ComponentImport LoginUriProvider loginUriProvider, @ComponentImport TemplateRenderer renderer, @ComponentImport XsrfTokenAccessor xsrfTokenAccessor, ConfigurationService<?> configurationService, ApplicationInformationProvider applicationInformationProvider, UserInformationProvider userInformationProvider, PrivilegeChecker privilegeChecker, PluginInformationProvider pluginInformationProvider, AnalyticsProvider analyticsProvider) {
        this.userManager = userManager;
        this.loginUriProvider = loginUriProvider;
        this.renderer = renderer;
        this.xsrfTokenAccessor = xsrfTokenAccessor;
        this.configurationService = configurationService;
        this.applicationInformationProvider = applicationInformationProvider;
        this.userInformationProvider = userInformationProvider;
        this.privilegeChecker = privilegeChecker;
        this.pluginInformationProvider = pluginInformationProvider;
        this.analyticsProvider = analyticsProvider;
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) {
        UserKey userKey;
        String servletPath;
        logger.debug("Starting to serve reconfigure front-end");
        response.addHeader("cache-control", Utils.CC_NO_CACHE_STRING);
        UserProfile userProfile = this.userManager.getRemoteUser(request);
        String uiPath = servletPath = request.getServletPath();
        logger.debug("getServletPath is {}", (Object)uiPath);
        if (uiPath.endsWith("/")) {
            uiPath = uiPath.substring(0, uiPath.length() - 2);
        }
        uiPath = uiPath.substring(uiPath.lastIndexOf(47) + 1);
        logger.debug("uiPath is {}", (Object)uiPath);
        Predicate<UserProfile> requiredPrivilege = this.configurationService.getRequiredPrivilege(this.privilegeChecker.getPrivilegeFactory(), PrivilegeChecker.AccessMode.READ, uiPath);
        logger.debug("requiredPrivilege for this page access is {}", requiredPrivilege);
        if (!requiredPrivilege.test(userProfile)) {
            logger.debug("requiredPrivilege not given");
            if (userProfile == null) {
                logger.debug("redirecting to login page because userProfile is null");
                try {
                    this.redirectToLogin(request, response);
                }
                catch (IOException e) {
                    logger.error("Error sending login page redirect for logged out user", (Throwable)e);
                    this.sendGeneralError(response, 500, "Error sending login page redirect for logged out user", e);
                }
                return;
            }
            String userName = userProfile.getUsername();
            if (userName == null || userName.isEmpty()) {
                logger.debug("redirecting to login page because userName is null");
                try {
                    this.redirectToLogin(request, response);
                }
                catch (IOException e) {
                    logger.error("Error sending login page redirect for user with username null", (Throwable)e);
                    this.sendGeneralError(response, 500, "Error sending login page redirect for user with username null", e);
                }
                return;
            }
            logger.debug("Sending privilege error page");
            this.sendGeneralError(response, 403, "You do not have the required privileges to see this page");
            return;
        }
        logger.debug("Checking if Websudo is required");
        try {
            this.privilegeChecker.requireWebSudo(this.configurationService.isWebSudoRequired(PrivilegeChecker.AccessMode.READ, request, userProfile, uiPath), request, response);
        }
        catch (WebSudoRequiredException e) {
            return;
        }
        logger.debug("Creating context");
        boolean isAdminOrSysadmin = userProfile != null ? this.userManager.isAdmin(userKey = userProfile.getUserKey()) || this.userManager.isSystemAdmin(userKey) : false;
        response.setContentType("text/html;charset=utf-8");
        String runMode = request.getParameter("mode");
        if (runMode == null || !runMode.equals("prod") && !runMode.equals("dev") && !runMode.equals("watch")) {
            runMode = "prod";
        }
        logger.debug("runMode is {}", (Object)runMode);
        Optional<String> frontendDefinition = this.configurationService.getFrontendDefinition(uiPath);
        if (!frontendDefinition.isPresent()) {
            this.sendGeneralError(response, 404, "Not Found");
            return;
        }
        HashMap<String, String> gitInfo = new HashMap<String, String>();
        gitInfo.put("branch", ReconfigureProperties.get("gitBranch"));
        gitInfo.put("buildUserName", ReconfigureProperties.get("gitBuildUserName"));
        gitInfo.put("commitId", ReconfigureProperties.get("gitCommitId"));
        gitInfo.put("dirty", ReconfigureProperties.get("gitDirty"));
        HashMap<String, Object> ctx = new HashMap<String, Object>();
        HashMap<String, String> metaTags = new HashMap<String, String>();
        PluginInformation pluginInformation = this.pluginInformationProvider.getPluginInformation(request);
        String reconfigureBuildTimestamp = ReconfigureProperties.get("reconfigureBuildTimestamp");
        metaTags.put("decorator", isAdminOrSysadmin ? "atl.admin" : "atl.general");
        metaTags.put("reconfigureFrontendDefinition", frontendDefinition.get());
        metaTags.put("reconfigureVersion", ReconfigureProperties.get("reconfigureVersion"));
        metaTags.put("reconfigureBuildTimestamp", reconfigureBuildTimestamp);
        metaTags.put("frontendDefinitionHashCode", Integer.toString(frontendDefinition.hashCode()));
        metaTags.put("reconfigureGitInfo", Utils.toJson(gitInfo));
        metaTags.put("appBuildTimestamp", PluginProperties.get((String)"buildTimestamp"));
        metaTags.put("pluginInformation", Utils.toJson(pluginInformation));
        metaTags.put("applicationInformation", Utils.toJson(this.applicationInformationProvider.getApplicationInformation(servletPath)));
        metaTags.put("mutableApplicationInformation", Utils.toJson(this.applicationInformationProvider.getMutableApplicationInformation()));
        metaTags.put("userInformation", Utils.toJson(this.userInformationProvider.getUserInformation(userProfile)));
        metaTags.put("pluginFamily", this.configurationService.getPluginFamily());
        metaTags.put("instanceFingerprint", this.analyticsProvider.getInstanceFingerprint());
        metaTags.put("appInstanceFingerprint", this.analyticsProvider.getAppInstanceFingerprint());
        metaTags.put("xsrfToken", this.xsrfTokenAccessor.getXsrfToken(request, response, true));
        this.configurationService.modifyMetaTags(userProfile, uiPath, metaTags);
        ctx.put("metaTags", metaTags);
        ctx.put("reconfigureBuildTimestamp", reconfigureBuildTimestamp);
        ctx.put("pluginKey", pluginInformation.getPluginKey());
        ctx.put("runMode", runMode);
        logger.trace("Admin page context is {}", ctx);
        logger.debug("rendering reconfigure front-end");
        try {
            this.renderer.render("reconfigure-admin.vm", ctx, (Writer)response.getWriter());
        }
        catch (RenderingException | IOException e) {
            logger.error("Error rendering admin page", e);
            this.sendGeneralError(response, 500, "Error rendering admin page", e);
        }
    }

    private void redirectToLogin(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String loginPageUrl = this.loginUriProvider.getLoginUri(this.getUri(request)).toASCIIString();
        logger.trace("sending login page redirect to {}", (Object)loginPageUrl);
        response.sendRedirect(loginPageUrl);
    }

    private void sendGeneralError(HttpServletResponse response, int statusCode, String message) {
        this.sendGeneralError(response, statusCode, message, null);
    }

    private void sendGeneralError(HttpServletResponse response, int statusCode, String message, Throwable throwable) {
        response.setContentType("text/html;charset=utf-8");
        response.setStatus(statusCode);
        HashMap<String, String> ctx = new HashMap<String, String>();
        ctx.put("message", message);
        if (throwable != null) {
            ctx.put("stacktrace", ExceptionUtils.getStackTrace((Throwable)throwable));
            logger.debug("sending error page with status code {}, message {} and throwable {}", new Object[]{statusCode, message, throwable.getMessage()});
        } else {
            logger.debug("sending error page with status code {}, message {}", (Object)statusCode, (Object)message);
        }
        logger.trace("error page context is {}", ctx);
        try {
            this.renderer.render("reconfigure-generalError.vm", ctx, (Writer)response.getWriter());
        }
        catch (IOException e) {
            logger.error("Could not render error page", (Throwable)e);
        }
    }

    private URI getUri(HttpServletRequest request) {
        StringBuffer builder = request.getRequestURL();
        if (request.getQueryString() != null) {
            builder.append("?");
            builder.append(request.getQueryString());
        }
        return URI.create(builder.toString());
    }
}

