/*
 * Decompiled with CFR 0.152.
 */
package com.resolution.atlasplugins.samlsso.userauth;

import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.resolution.atlasplugins.samlsso.ReadOnlyModeDetector;
import com.resolution.atlasplugins.samlsso.UnexpectedAtlasUserResultException;
import com.resolution.atlasplugins.samlsso.Utils;
import com.resolution.atlasplugins.samlsso.configuration.CommonIdpConfigurationData;
import com.resolution.atlasplugins.samlsso.configuration.CommonRunningIdpConfiguration;
import com.resolution.atlasplugins.samlsso.configuration.RunningConfiguration;
import com.resolution.atlasplugins.samlsso.configuration.SamlRunningIdPConfiguration;
import com.resolution.atlasplugins.samlsso.tracker.AuthenticationTracker;
import com.resolution.atlasplugins.samlsso.userauth.DirectoryAdapter;
import com.resolution.atlasplugins.samlsso.userauth.PrincipalAndModified;
import com.resolution.atlasplugins.samlsso.userauth.PrincipalProvider;
import com.resolution.atlasplugins.samlsso.userauth.SamlUserMigrator;
import com.resolution.atlasplugins.samlsso.userauth.UserPreparationException;
import com.resolution.atlasplugins.samlsso.userauth.XsrfCheckAvoider;
import com.resolution.samlwrapper.api.LoginInformation;
import com.resolution.samlwrapper.api.PluginProperties;
import com.resolution.samlwrapper.api.ProgressLogger;
import com.resolution.samlwrapper.api.exception.SamlAuthenticationException;
import com.resolution.samlwrapper.api.tracker.SAMLAuthenticationTracker;
import de.resolution.atlasuser.api.user.AtlasUser;
import de.resolution.atlasuser.api.user.AtlasUserAdapter;
import de.resolution.atlasuser.api.user.AtlasUserReference;
import de.resolution.atlasuser.api.user.AtlasUserResult;
import de.resolution.atlasuser.impl.user.AtlasUserBuilder;
import de.resolution.commons.data.MapStructuredData;
import de.resolution.commons.data.StructuredData;
import de.resolution.retransform.api.AttributeTransformationResult;
import de.resolution.retransform.api.AttributeTransformer;
import de.resolution.retransform.api.TransformationFailedException;
import de.resolution.usersync.api.SyncSingleUserResult;
import de.resolution.usersync.api.TransformationResults;
import de.resolution.usersync.api.UserSyncService;
import de.resolution.usersync.external.api.exception.ConfigurationFailedException;
import de.resolution.usersync.external.api.exception.ConnectorFactoryNotAvailableException;
import de.resolution.usersync.external.api.exception.ConnectorNotAvailableException;
import de.resolution.usersync.external.api.exception.ConnectorNotFoundException;
import jakarta.annotation.Nonnull;
import jakarta.inject.Inject;
import java.security.Principal;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@ExportAsService(value={PrincipalProvider.class})
public class PrincipalProviderImpl
implements PrincipalProvider {
    private static final Logger logger = LoggerFactory.getLogger(PrincipalProviderImpl.class);
    public static final String ATTRIBUTE_SD_CUSTOMER = "ATTR_SD_CUSTOMER";
    private final RunningConfiguration pluginConfiguration;
    private final ReadOnlyModeDetector readOnlyModeDetector;
    private final AtlasUserAdapter atlasUserAdapter;
    private final UserSyncService userSyncService;
    private final DirectoryAdapter directoryAdapter;
    private final XsrfCheckAvoider xsrfCheckAvoider;
    private final SamlUserMigrator samlUserMigrator;
    private final boolean enableUsersync;
    private static final Logger customLoginLogger = LoggerFactory.getLogger((String)"com.resolution.atlasplugins.samlsso.userauth.CustomLoginLogger");

    @Inject
    public PrincipalProviderImpl(@Nonnull RunningConfiguration pluginConfiguration, @Nonnull ReadOnlyModeDetector readOnlyModeDetector, @Nonnull AtlasUserAdapter atlasUserAdapter, @Nonnull UserSyncService userSyncService, @Nonnull DirectoryAdapter directoryAdapter, @Nonnull XsrfCheckAvoider xsrfCheckAvoider, @Nonnull SamlUserMigrator samlUserMigrator) {
        this.pluginConfiguration = pluginConfiguration;
        this.readOnlyModeDetector = readOnlyModeDetector;
        this.atlasUserAdapter = atlasUserAdapter;
        this.enableUsersync = Boolean.parseBoolean(PluginProperties.get((String)"enableUserSync"));
        this.userSyncService = userSyncService;
        this.directoryAdapter = directoryAdapter;
        this.xsrfCheckAvoider = xsrfCheckAvoider;
        this.samlUserMigrator = samlUserMigrator;
    }

    @Override
    @Nonnull
    public PrincipalAndModified providePrincipal(@Nonnull LoginInformation loginInformation, boolean sdCustomer, @Nonnull AuthenticationTracker tracker) throws SamlAuthenticationException {
        ProgressLogger.log((String)"Trying to load user", (SAMLAuthenticationTracker)tracker);
        CommonRunningIdpConfiguration idpConfig = this.pluginConfiguration.getRunningIdpConfiguration(loginInformation.getIdp());
        if (idpConfig == null) {
            throw new UserPreparationException("no config found for IdP " + loginInformation.getIdp(), (SAMLAuthenticationTracker)tracker);
        }
        boolean updateFromConnector = this.enableUsersync && (idpConfig.getUserUpdateMethod() == CommonIdpConfigurationData.UserUpdateMethod.CONNECTOR || idpConfig.getUserUpdateMethod() == CommonIdpConfigurationData.UserUpdateMethod.CONNECTORANDSAML) && !idpConfig.getUserSyncConnector().equals("None");
        PrincipalAndModified principalAndModifiedFromConnector = this.updateWithUserSync(loginInformation, tracker, idpConfig, updateFromConnector);
        boolean modified = principalAndModifiedFromConnector != null && principalAndModifiedFromConnector.isModifiedAndActive();
        String userIdFromIdP = null;
        Principal principalForLogin = null;
        try {
            userIdFromIdP = this.extractUserIdFromIdp(loginInformation, tracker, idpConfig);
        }
        catch (SamlAuthenticationException e) {
            tracker.add(logger, SAMLAuthenticationTracker.Level.ERROR, "Could not find user from logininformation. This can indicate a faulty configuration. See the following exception: {}", new Object[]{e.getMessage()});
        }
        if (userIdFromIdP != null) {
            ProgressLogger.log((String)"Trying to find user in Directory", (SAMLAuthenticationTracker)tracker);
            principalForLogin = this.directoryAdapter.findUser(idpConfig.getFindByAttributeName(), userIdFromIdP, tracker, this.pluginConfiguration.isFetchFromRemoteDirectory(), this.pluginConfiguration.isTriggerUpdateOnCrowdDirectories());
            ProgressLogger.log((String)"Done finding user", (SAMLAuthenticationTracker)tracker);
        }
        if (principalForLogin == null && principalAndModifiedFromConnector != null) {
            principalForLogin = principalAndModifiedFromConnector.getPrincipal();
            tracker.add(logger, SAMLAuthenticationTracker.Level.ERROR, "Could not find user, but had a successful User Sync update. Please note, with a future version of SAML SSO login will fail. Please see https://wiki.resolution.de/go/userNotFoundButUserSyncSuccess for more information.", new Object[0]);
        }
        PrincipalAndModified principalAndModifiedFromSAMLUpdate = null;
        if (idpConfig instanceof SamlRunningIdPConfiguration) {
            SamlRunningIdPConfiguration samlRunning = (SamlRunningIdPConfiguration)idpConfig;
            if (principalForLogin == null && !samlRunning.isEnableUserCreation()) {
                if (customLoginLogger.isDebugEnabled()) {
                    customLoginLogger.debug("Failed SSO login for user: {} tracker={}", (Object)userIdFromIdP, (Object)tracker.getTrackerId());
                }
                throw new SamlAuthenticationException(Utils.createAuthenticationErrorMessage(tracker, userIdFromIdP, samlRunning), (SAMLAuthenticationTracker)tracker);
            }
            if (this.readOnlyModeDetector.isReadOnlyMode()) {
                tracker.add(logger, SAMLAuthenticationTracker.Level.WARNING, "User-update from SAML-attributes is disabled in read-only-mode", new Object[0]);
            } else if (idpConfig.getUserUpdateMethod() == CommonIdpConfigurationData.UserUpdateMethod.SAML || idpConfig.getUserUpdateMethod() == CommonIdpConfigurationData.UserUpdateMethod.CONNECTORANDSAML) {
                principalAndModifiedFromSAMLUpdate = this.updateFromSaml(samlRunning, loginInformation, userIdFromIdP, sdCustomer, principalForLogin, modified, tracker);
            }
        }
        if (principalAndModifiedFromSAMLUpdate != null && principalAndModifiedFromSAMLUpdate.getPrincipal() != null) {
            principalForLogin = principalAndModifiedFromSAMLUpdate.getPrincipal();
            boolean bl = modified = modified || principalAndModifiedFromSAMLUpdate.isModifiedAndActive();
        }
        if (principalForLogin != null && idpConfig.isEnableUserReactivation()) {
            boolean modifiedAndActive = this.enableUser(principalForLogin.getName(), tracker);
            boolean bl = modified = modified || modifiedAndActive;
            if (modifiedAndActive && customLoginLogger.isDebugEnabled()) {
                customLoginLogger.debug("Re-activating Account during SSO login for user: {} tracker={}", (Object)principalForLogin.getName(), (Object)tracker.getTrackerId());
            }
        }
        return new PrincipalAndModified(principalForLogin, modified);
    }

    @Nullable
    private PrincipalAndModified updateWithUserSync(@Nonnull LoginInformation loginInformation, @Nonnull AuthenticationTracker tracker, CommonRunningIdpConfiguration commonRunningIdpConfiguration, boolean updateFromConnector) throws SamlAuthenticationException {
        PrincipalAndModified principalAndModifiedFromConnector = null;
        this.xsrfCheckAvoider.avoidXsrfCheck();
        if (this.readOnlyModeDetector.isReadOnlyMode()) {
            tracker.add(logger, SAMLAuthenticationTracker.Level.WARNING, "Usersync-Lookup is disabled in read-only mode", new Object[0]);
        } else if (updateFromConnector) {
            ProgressLogger.log((String)"Updating user from connector", (SAMLAuthenticationTracker)tracker);
            principalAndModifiedFromConnector = this.updateFromConnector(commonRunningIdpConfiguration, loginInformation, tracker);
        } else {
            tracker.add(logger, SAMLAuthenticationTracker.Level.DEBUG, "Updating from Usersync is disabled", new Object[0]);
        }
        return principalAndModifiedFromConnector;
    }

    @Nonnull
    private String extractUserIdFromIdp(@Nonnull LoginInformation loginInformation, @Nonnull AuthenticationTracker tracker, CommonRunningIdpConfiguration samlRunningIdPConfiguration) throws SamlAuthenticationException {
        AttributeTransformationResult userLookupTransformationResult;
        try {
            userLookupTransformationResult = samlRunningIdPConfiguration.getUserLookUpTransformer().transform(StructuredData.create((StructuredData)loginInformation.getAttributes()));
        }
        catch (TransformationFailedException e) {
            throw new SamlAuthenticationException("Transformation for user-lookup-attribute failed", (Throwable)e, (SAMLAuthenticationTracker)tracker);
        }
        tracker.setUserLookupTransformerResult(userLookupTransformationResult);
        if (userLookupTransformationResult.isDrop()) {
            String message = userLookupTransformationResult.getMessage();
            if (message == null) {
                message = "User was dropped during transformation";
            }
            throw new SamlAuthenticationException(message, (SAMLAuthenticationTracker)tracker);
        }
        String userIdFromIdP = userLookupTransformationResult.getFirstValue();
        if (userIdFromIdP == null) {
            throw new SamlAuthenticationException("Could not resolve userid from loginInformation", (SAMLAuthenticationTracker)tracker);
        }
        tracker.setUserId(userIdFromIdP);
        return userIdFromIdP;
    }

    public boolean enableUser(@Nonnull String userid, @Nonnull AuthenticationTracker tracker) {
        AtlasUser foundUser;
        AtlasUserReference atlasUserReference = AtlasUserReference.create((String)"ATTR_NAME", (Object)userid, (long)-1L);
        AtlasUserResult searchResult = this.atlasUserAdapter.readFirstUniqueUser(atlasUserReference);
        Optional resultingUser = searchResult.getResultingUser();
        if (resultingUser.isPresent() && !(foundUser = (AtlasUser)resultingUser.get()).isActive()) {
            AtlasUser userToEnable = AtlasUser.builder().findBy(foundUser.getReference()).active(true).build();
            AtlasUserResult enableResult = this.atlasUserAdapter.update(userToEnable);
            if (enableResult.getOperation() != AtlasUserResult.Operation.FAILED) {
                if (enableResult.isModified()) {
                    tracker.add(logger, SAMLAuthenticationTracker.Level.DEBUG, "Enabled user {}", new Object[]{foundUser.getName()});
                    tracker.setActivatedUser(true);
                    return true;
                }
                return false;
            }
            String messages = String.join((CharSequence)" / ", (Iterable<? extends CharSequence>)enableResult.getMessages().orElse(Collections.singletonList("no message available")));
            tracker.add(logger, SAMLAuthenticationTracker.Level.ERROR, "Enabling user {} failed: ", new Object[]{foundUser.getName(), messages});
            return false;
        }
        return false;
    }

    public boolean isSAMLUser(@Nonnull String userid) {
        boolean isCrowdSamlUser = this.samlUserMigrator.isCrowdSamlUser(userid);
        if (isCrowdSamlUser) {
            return true;
        }
        boolean isLegacySamlUser = this.samlUserMigrator.isLegacySamlUser(userid);
        if (isLegacySamlUser) {
            this.samlUserMigrator.migrateToCrowdAttribute(userid);
            return true;
        }
        return false;
    }

    @Nullable
    public PrincipalAndModified updateFromConnector(CommonRunningIdpConfiguration idpConfiguration, LoginInformation loginInformation, AuthenticationTracker tracker) throws SamlAuthenticationException {
        TransformationResults transformationResults;
        SyncSingleUserResult syncSingleUserResult;
        AttributeTransformationResult userSyncLookupTransformerResult;
        try {
            userSyncLookupTransformerResult = idpConfiguration.getUserSyncLookupTransformer().transform(StructuredData.create((StructuredData)loginInformation.getAttributes()));
        }
        catch (TransformationFailedException e) {
            tracker.add(logger, SAMLAuthenticationTracker.Level.ERROR, "Transformation for User Sync lookup-attribute failed: " + e.getMessage(), new Object[0]);
            tracker.add(e);
            return null;
        }
        tracker.setConnectorLookupTransformerResult(userSyncLookupTransformerResult);
        String connectorLookupAttributeValue = userSyncLookupTransformerResult.getFirstValue();
        if (userSyncLookupTransformerResult.isDropAll()) {
            String message = userSyncLookupTransformerResult.getMessage();
            if (message == null) {
                message = "User was dropped in User Sync lookup transformation";
            }
            throw new SamlAuthenticationException(message, (SAMLAuthenticationTracker)tracker);
        }
        if (connectorLookupAttributeValue == null) {
            tracker.add(logger, SAMLAuthenticationTracker.Level.ERROR, "Could not resolve value for connector-lookup", new Object[0]);
            return null;
        }
        tracker.add(logger, SAMLAuthenticationTracker.Level.DEBUG, "Searching user in connector with attribute {}", new Object[]{connectorLookupAttributeValue});
        HashMap<String, Set<String>> attributesToOverride = new HashMap<String, Set<String>>();
        if (!idpConfiguration.isAllowChangingActiveStateOnConnectorUpdate()) {
            attributesToOverride.put("ATTR_IS_IGNORE_ACTIVE_ON_UPDATE", Collections.singleton(String.valueOf(!idpConfiguration.isEnableUserReactivation())));
        }
        MapStructuredData attributeMap = StructuredData.create((StructuredData)loginInformation.getAttributes()).asMap();
        try {
            syncSingleUserResult = this.userSyncService.syncSingleUser(connectorLookupAttributeValue, attributeMap, attributesToOverride, idpConfiguration.getUserSyncConnector(), false);
        }
        catch (ConfigurationFailedException | ConnectorFactoryNotAvailableException | ConnectorNotAvailableException | ConnectorNotFoundException e) {
            tracker.add(logger, SAMLAuthenticationTracker.Level.ERROR, "Updating user from connector failed: " + e.getMessage(), new Object[0]);
            tracker.add(e);
            return null;
        }
        tracker.setUpdateFromConnectorResult(syncSingleUserResult);
        if (PrincipalProviderImpl.hasActivatedUser(syncSingleUserResult)) {
            tracker.setActivatedUser(true);
        }
        if (syncSingleUserResult != null) {
            tracker.add(logger, SAMLAuthenticationTracker.Level.DEBUG, "SyncSingleUserResult has status {}", new Object[]{syncSingleUserResult.getStatus()});
        }
        if ((transformationResults = syncSingleUserResult.getTransformationResults()) != null && transformationResults.isDropAll()) {
            for (AttributeTransformationResult currentResult : transformationResults.getAttributeTransformationResults().values()) {
                if (!currentResult.isDropAll() || currentResult.getMessage() == null) continue;
                throw new SamlAuthenticationException(currentResult.getMessage(), (SAMLAuthenticationTracker)tracker);
            }
            throw new SamlAuthenticationException("User was dropped during Attribute-Transformation", (SAMLAuthenticationTracker)tracker);
        }
        AtlasUserResult result = syncSingleUserResult.getAtlasUserResult();
        if (result == null) {
            tracker.add(logger, SAMLAuthenticationTracker.Level.INFO, "SyncSingleUserResult contained no AtlasUserResult", new Object[0]);
            if (logger.isDebugEnabled()) {
                logger.debug("SyncSingleUserResult: {} ", (Object)Utils.asJsonString(syncSingleUserResult));
            }
            return null;
        }
        Optional optionalResultingUser = result.getResultingUser();
        if (result.getOperation() != AtlasUserResult.Operation.FAILED && optionalResultingUser.isPresent()) {
            AtlasUser resultingUser = (AtlasUser)optionalResultingUser.get();
            tracker.add(logger, SAMLAuthenticationTracker.Level.DEBUG, "syncSingleUser was successful: {}", new Object[]{result.getOperation()});
            tracker.setUpdateFromConnectorResult(syncSingleUserResult);
            if (PrincipalProviderImpl.hasActivatedUser(syncSingleUserResult)) {
                tracker.setActivatedUser(true);
            }
            boolean isModifiedAndActive = result.isModified() && resultingUser.isActive();
            return new PrincipalAndModified((Principal)resultingUser, isModifiedAndActive);
        }
        String messages = String.join((CharSequence)" / ", (Iterable<? extends CharSequence>)result.getMessages().orElse(Collections.singletonList("undefined error")));
        tracker.add(logger, SAMLAuthenticationTracker.Level.ERROR, "Updating user from connector failed, result was not SUCCESS or resulting user was not present: {}", new Object[]{messages});
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public PrincipalAndModified updateFromSaml(SamlRunningIdPConfiguration idpConfiguration, LoginInformation loginInformation, String useridFromIdp, boolean sdCustomer, Principal principalForLogin, boolean alreadyModified, AuthenticationTracker tracker) throws SamlAuthenticationException {
        boolean modified;
        AtlasUserResult result;
        block23: {
            AtlasUserBuilder atlasUserBuilder;
            block22: {
                ProgressLogger.log((String)"Starting user update from SAML-attributes", (SAMLAuthenticationTracker)tracker);
                StructuredData attributes = StructuredData.create((StructuredData)loginInformation.getAttributes());
                attributes.put((Object)ATTRIBUTE_SD_CUSTOMER, Collections.singletonList(String.valueOf(sdCustomer)));
                atlasUserBuilder = AtlasUser.builder();
                HashMap<String, AttributeTransformationResult> transformerResultMap = new HashMap<String, AttributeTransformationResult>();
                for (Map.Entry<String, AttributeTransformer> transformationEntry : idpConfiguration.getAttributeTransformerMap().entrySet()) {
                    try {
                        AttributeTransformationResult transformerResult = transformationEntry.getValue().transform(StructuredData.create((StructuredData)attributes));
                        transformerResultMap.put(transformationEntry.getKey(), transformerResult);
                        if (logger.isDebugEnabled()) {
                            logger.debug("Transformed {} to {}", (Object)transformationEntry.getKey(), (Object)Utils.asJsonString(transformerResult));
                        }
                        if (transformerResult.isDropAll()) {
                            String message = "User was dropped during transformation";
                            if (transformerResult.getMessage() != null) {
                                message = transformerResult.getMessage();
                            }
                            throw new SamlAuthenticationException(message, (SAMLAuthenticationTracker)tracker);
                        }
                        if (transformerResult.isDrop()) continue;
                        atlasUserBuilder.with(transformationEntry.getKey(), (Collection)transformerResult.getValues());
                    }
                    catch (TransformationFailedException e) {
                        throw new SamlAuthenticationException("Transforming attribute " + transformationEntry.getKey() + "failed", (Throwable)e, (SAMLAuthenticationTracker)tracker);
                    }
                }
                tracker.setAttributeTransformerResults(transformerResultMap);
                if (sdCustomer) {
                    if (!idpConfiguration.getDefaultSDCustomerGroups().isEmpty()) {
                        combinedGroups = new HashSet<String>();
                        atlasUserBuilder.get("ATTR_GROUPS").ifPresent(combinedGroups::addAll);
                        combinedGroups.addAll(idpConfiguration.getDefaultSDCustomerGroups());
                        atlasUserBuilder.with("ATTR_GROUPS", combinedGroups);
                    }
                } else {
                    if (!idpConfiguration.getDefaultUserGroups().isEmpty()) {
                        combinedGroups = new HashSet();
                        atlasUserBuilder.get("ATTR_GROUPS").ifPresent(combinedGroups::addAll);
                        combinedGroups.addAll(idpConfiguration.getDefaultUserGroups());
                        atlasUserBuilder.with("ATTR_GROUPS", combinedGroups);
                    }
                    atlasUserBuilder.without("JIRA.ATTR_ORGANIZATIONS");
                }
                atlasUserBuilder.with("ATTR_IS_CREATE_GROUPS", idpConfiguration.isAddNonExistingGroups());
                if (idpConfiguration.isAddNonExistingOrganizations()) {
                    atlasUserBuilder.with("JIRA.ATTR_ORGANIZATIONS_CREATE", true);
                }
                if (principalForLogin != null) break block22;
                ProgressLogger.log((String)"Creating new user", (SAMLAuthenticationTracker)tracker);
                AtlasUser atlasUser = atlasUserBuilder.findBy(idpConfiguration.getFindByAttributeName(), (Object)useridFromIdp).in(idpConfiguration.getDirectoryIdForNewUsers()).with("CREATED_BY_SAML", true).with("ATTR_IS_KEEP_GROUPS", true).build();
                result = this.atlasUserAdapter.create(atlasUser);
                if (result.getOperation() != AtlasUserResult.Operation.FAILED && result.getResultingUser().isPresent()) {
                    principalForLogin = (Principal)result.getResultingUser().get();
                    if (customLoginLogger.isDebugEnabled()) {
                        customLoginLogger.debug("Creating Account during SSO login for user: {} tracker={}", (Object)principalForLogin.getName(), (Object)tracker.getTrackerId());
                    }
                    break block23;
                } else {
                    if (logger.isWarnEnabled()) {
                        logger.warn(Utils.asJsonString(result));
                    }
                    throw new UnexpectedAtlasUserResultException(result, tracker);
                }
            }
            String userid = principalForLogin.getName();
            if (!this.isSAMLUser(userid) && !idpConfiguration.isUpdateExisting()) {
                tracker.add(logger, SAMLAuthenticationTracker.Level.DEBUG, "Not updating existing user {}", new Object[]{userid});
                return new PrincipalAndModified(principalForLogin, alreadyModified);
            }
            AtlasUserResult readResult = this.atlasUserAdapter.readFirstUniqueUser(AtlasUserReference.create((String)"ATTR_NAME", (Object)principalForLogin.getName(), (long)-1L));
            if (readResult.getOperation() != AtlasUserResult.Operation.FAILED && readResult.getResultingUser().isPresent()) {
                AtlasUser existingUser = (AtlasUser)readResult.getResultingUser().get();
                if (!this.isSAMLUser(userid) || existingUser.isAdminOrSysAdmin() || !idpConfiguration.isRemoveFromGroups()) {
                    atlasUserBuilder.with("ATTR_IS_KEEP_GROUPS", true);
                }
                atlasUserBuilder.without("ATTR_ACTIVE");
                if (idpConfiguration.isEnableUserRenaming()) {
                    atlasUserBuilder.get("ATTR_NAME").ifPresent(strings -> atlasUserBuilder.with("ATTR_NEW_NAME", (Collection)strings));
                }
                atlasUserBuilder.without("ATTR_NAME");
                AtlasUser userToUpdate = atlasUserBuilder.findBy(existingUser.getReference()).build();
                ProgressLogger.log((String)"Updating user", (SAMLAuthenticationTracker)tracker);
                result = this.atlasUserAdapter.update(userToUpdate);
            } else {
                throw new UnexpectedAtlasUserResultException("Loading user " + principalForLogin.getName() + " failed", readResult, tracker);
            }
        }
        tracker.setUpdateFromSAMLResult(result);
        if (PrincipalProviderImpl.hasActivatedUser(result)) {
            tracker.setActivatedUser(true);
        }
        boolean bl = modified = alreadyModified || result.isModified();
        if (result.getOperation() != AtlasUserResult.Operation.FAILED && result.getResultingUser().isPresent()) {
            return new PrincipalAndModified((Principal)result.getResultingUser().get(), modified);
        }
        throw new UnexpectedAtlasUserResultException(result, tracker);
    }

    public static boolean hasActivatedUser(@Nullable AtlasUserResult result) {
        if (result == null) {
            return false;
        }
        boolean resultingUserActive = result.getResultingUser().map(AtlasUser::isActive).orElse(false);
        boolean initialUserActive = result.getInitialUser().map(AtlasUser::isActive).orElse(false);
        return resultingUserActive && !initialUserActive;
    }

    public static boolean hasActivatedUser(@Nullable SyncSingleUserResult result) {
        if (result == null) {
            return false;
        }
        return PrincipalProviderImpl.hasActivatedUser(result.getAtlasUserResult());
    }
}

