/*
 * Decompiled with CFR 0.152.
 */
package com.resolution.atlasplugins.samlsso.userauth;

import com.atlassian.templaterenderer.TemplateRenderer;
import com.resolution.atlasplugins.samlsso.SamlSsoService;
import com.resolution.atlasplugins.samlsso.configuration.RunningConfiguration;
import com.resolution.atlasplugins.samlsso.tracker.AuthenticationTracker;
import com.resolution.atlasplugins.samlsso.userauth.AbstractLoginHandler;
import com.resolution.atlasplugins.samlsso.userauth.AuthenticatorHook;
import com.resolution.atlasplugins.samlsso.userauth.AuthenticatorHookException;
import com.resolution.atlasplugins.samlsso.userauth.PrincipalAndModified;
import com.resolution.atlasplugins.samlsso.userauth.PrincipalProvider;
import com.resolution.samlwrapper.api.ProgressLogger;
import com.resolution.samlwrapper.api.exception.LoginHandlerException;
import com.resolution.samlwrapper.api.tracker.SAMLAuthenticationTracker;
import de.resolution.samlauth.api.AdditionalAuthenticationService;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.security.Principal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AuthenticatorHookBasedLoginHandler
extends AbstractLoginHandler {
    private static final Logger logger = LoggerFactory.getLogger(AuthenticatorHookBasedLoginHandler.class);
    private static final Logger customLoginLogger = LoggerFactory.getLogger((String)"com.resolution.atlasplugins.samlsso.userauth.CustomLoginLogger");
    private final AuthenticatorHook authenticatorHook;
    private final SamlSsoService samlSsoService;
    protected final RunningConfiguration pluginConfiguration;

    public AuthenticatorHookBasedLoginHandler(SamlSsoService samlSsoService, AdditionalAuthenticationService additionalAuthenticationService, AuthenticatorHook authenticatorHook, PrincipalProvider principalProvider, RunningConfiguration pluginConfiguration, TemplateRenderer templateRenderer) {
        super(samlSsoService, additionalAuthenticationService, principalProvider, templateRenderer);
        this.authenticatorHook = authenticatorHook;
        this.samlSsoService = samlSsoService;
        this.pluginConfiguration = pluginConfiguration;
    }

    @Override
    public void doLogin(HttpServletRequest req, HttpServletResponse resp, PrincipalAndModified principalAndModified, String redirectUrl, AuthenticationTracker tracker, String sessionIndex, String nameId, String idpId) throws LoginHandlerException, IOException {
        boolean authenticationSuccessful;
        Principal principal = principalAndModified.getPrincipal();
        logger.debug("Trying to authorize user {}", (Object)principal.getName());
        try {
            authenticationSuccessful = this.authenticatorHook.authoriseUserAndEstablishSession(req, resp, principal, this.pluginConfiguration.isSetRememberMeCookie(), false, tracker);
        }
        catch (AuthenticatorHookException e) {
            tracker.setStatus(SAMLAuthenticationTracker.Status.FAILED);
            Object message = e.getMessage();
            if (message == null) {
                message = e.getCause().getClass().getName() + ": " + e.getCause().getMessage();
            }
            if (customLoginLogger.isDebugEnabled()) {
                customLoginLogger.debug("Failed SSO login for user: {} tracker={}", (Object)principal.getName(), (Object)tracker.getTrackerId());
            }
            throw new LoginHandlerException("Authenticating user " + principal.getName() + " failed: " + (String)message, (Throwable)e, (SAMLAuthenticationTracker)tracker);
        }
        if (!authenticationSuccessful) {
            if (customLoginLogger.isDebugEnabled()) {
                customLoginLogger.debug("Failed SSO login for user: {} tracker={}", (Object)principal.getName(), (Object)tracker.getTrackerId());
            }
            tracker.setStatus(SAMLAuthenticationTracker.Status.FAILED);
            throw new LoginHandlerException("Authenticating user " + principal.getName() + " failed, check if the user exists and has permission to access this application", (SAMLAuthenticationTracker)tracker);
        }
        if (customLoginLogger.isDebugEnabled()) {
            customLoginLogger.debug("Successful SSO login for user: {} tracker={}", (Object)principal.getName(), (Object)tracker.getTrackerId());
        }
        logger.debug("Redirecting to {}", (Object)redirectUrl);
        resp.setHeader("cache-control", "no-cache, no-store, must-revalidate");
        resp.sendRedirect(redirectUrl);
        tracker.setStatus(SAMLAuthenticationTracker.Status.LOGGED_IN);
    }

    @Override
    public void authenticateByToken(HttpServletRequest req, HttpServletResponse resp, String token, boolean setRememberMe, SAMLAuthenticationTracker samlAuthTracker) throws LoginHandlerException, IOException {
        String redirectUrl;
        boolean authenticationSuccessful;
        ProgressLogger.log((String)"Starting authentication by token", (SAMLAuthenticationTracker)samlAuthTracker);
        AuthenticationTracker tracker = (AuthenticationTracker)samlAuthTracker;
        String relayState = tracker.getOriginalUrl() != null ? tracker.getOriginalUrl() : tracker.getIncomingRelayState();
        String fullRedirectURL = this.samlSsoService.getRedirectURL(req, relayState, tracker);
        boolean sdCustomerLogin = fullRedirectURL.contains("servicedesk/customer");
        String userid = this.tokenStore.getUseridFromSsoToken(token);
        if (userid == null) {
            throw new LoginHandlerException("Could not find a userid for token " + token, (SAMLAuthenticationTracker)tracker);
        }
        logger.debug("Trying to authorize user {}", (Object)userid);
        Principal principal = () -> userid;
        try {
            authenticationSuccessful = this.authenticatorHook.authoriseUserAndEstablishSession(req, resp, principal, setRememberMe, sdCustomerLogin, tracker);
        }
        catch (AuthenticatorHookException e) {
            tracker.setStatus(SAMLAuthenticationTracker.Status.FAILED);
            Object message = e.getMessage();
            if (message == null) {
                message = e.getCause().getClass().getName() + ": " + e.getCause().getMessage();
            }
            throw new LoginHandlerException("Authenticating user " + principal.getName() + " failed: " + (String)message, (Throwable)e, (SAMLAuthenticationTracker)tracker);
        }
        if (!authenticationSuccessful) {
            throw new LoginHandlerException("Authenticating user by token failed", (SAMLAuthenticationTracker)tracker);
        }
        tracker.add(logger, SAMLAuthenticationTracker.Level.INFO, "Authentication was successful", new Object[0]);
        ProgressLogger.log((String)"Authentication was successful", (SAMLAuthenticationTracker)tracker);
        if (this.pluginConfiguration.isSetRememberMeCookie()) {
            this.authenticatorHook.addRememberMeCookie(req, resp, userid, tracker);
        }
        if (fullRedirectURL.contains("/secure/Dashboard.jspa")) {
            redirectUrl = fullRedirectURL.replace("/secure/Dashboard.jspa", "/default.jsp");
            tracker.add(logger, SAMLAuthenticationTracker.Level.DEBUG, "replaced /secure/Dashboard.jspa with /default.jsp to workaround https://jira.atlassian.com/browse/JRASERVER-63278 (Error 404 when accessing Dashboard)", new Object[0]);
        } else {
            redirectUrl = fullRedirectURL;
        }
        logger.debug("Redirecting to {} after authenticating by token", (Object)redirectUrl);
        tracker.setStatus(SAMLAuthenticationTracker.Status.LOGGED_IN);
        resp.setHeader("cache-control", "no-cache, no-store, must-revalidate");
        ProgressLogger.log((String)"Sending redirect after authenticating by token", (SAMLAuthenticationTracker)tracker);
        resp.sendRedirect(redirectUrl);
    }
}

