/*
 * Decompiled with CFR 0.152.
 */
package com.resolution.atlasplugins.samlsso.userauth;

import com.atlassian.templaterenderer.TemplateRenderer;
import com.resolution.atlasplugins.samlsso.SSOTokenStore;
import com.resolution.atlasplugins.samlsso.SamlSsoService;
import com.resolution.atlasplugins.samlsso.tracker.AuthenticationTracker;
import com.resolution.atlasplugins.samlsso.userauth.PrincipalAndModified;
import com.resolution.atlasplugins.samlsso.userauth.PrincipalProvider;
import com.resolution.samlwrapper.api.LoginHandler;
import com.resolution.samlwrapper.api.LoginInformation;
import com.resolution.samlwrapper.api.exception.LoginHandlerException;
import com.resolution.samlwrapper.api.exception.SamlAuthenticationException;
import com.resolution.samlwrapper.api.tracker.SAMLAuthenticationTracker;
import de.resolution.samlauth.api.AdditionalAuthenticationService;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import okhttp3.HttpUrl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractLoginHandler
implements LoginHandler {
    private static final Logger logger = LoggerFactory.getLogger(AbstractLoginHandler.class);
    private final SamlSsoService samlSsoService;
    private final PrincipalProvider principalProvider;
    private final TemplateRenderer templateRenderer;
    private final AdditionalAuthenticationService additionalAuthenticationService;
    protected SSOTokenStore tokenStore = SSOTokenStore.getInstance();

    protected AbstractLoginHandler(SamlSsoService samlSsoService, AdditionalAuthenticationService additionalAuthenticationService, PrincipalProvider principalProvider, TemplateRenderer templateRenderer) {
        this.samlSsoService = samlSsoService;
        this.additionalAuthenticationService = additionalAuthenticationService;
        this.principalProvider = principalProvider;
        this.templateRenderer = templateRenderer;
    }

    public abstract void doLogin(HttpServletRequest var1, HttpServletResponse var2, PrincipalAndModified var3, String var4, AuthenticationTracker var5, String var6, String var7, String var8) throws LoginHandlerException, IOException;

    public void login(HttpServletRequest req, HttpServletResponse resp, LoginInformation loginInformation, SAMLAuthenticationTracker samlAuthTracker, String sessionIndex, String nameId, String idpId) throws SamlAuthenticationException, IOException {
        AuthenticationTracker tracker = (AuthenticationTracker)samlAuthTracker;
        String relayState = loginInformation.getRelayState();
        String redirectUrl = this.samlSsoService.getRedirectURL(req, relayState, tracker);
        boolean isServiceDeskLogin = this.isServiceDeskLogin(redirectUrl);
        PrincipalAndModified principalAndModified = this.principalProvider.providePrincipal(loginInformation, isServiceDeskLogin, tracker);
        if (principalAndModified.getPrincipal() == null) {
            throw new SamlAuthenticationException("The user was not found", (SAMLAuthenticationTracker)tracker);
        }
        this.doLogin(req, resp, principalAndModified, redirectUrl, tracker, sessionIndex, nameId, idpId);
        this.updateBotKillerInterval(req, tracker);
    }

    private void updateBotKillerInterval(HttpServletRequest req, AuthenticationTracker tracker) throws LoginHandlerException {
        HttpSession session = req.getSession(false);
        if (session != null) {
            session.setAttribute("tracker", (Object)tracker.getTrackerId());
            Object botKillerAttribute = session.getAttribute("com.atlassian.labs.botkiller.BotKiller");
            if (botKillerAttribute != null) {
                int currentMaxActiveInterval;
                int valueFromBotKiller = (Integer)botKillerAttribute;
                if (valueFromBotKiller > (currentMaxActiveInterval = session.getMaxInactiveInterval())) {
                    tracker.add(logger, SAMLAuthenticationTracker.Level.DEBUG, "Updating session interval from {} to {} from BotKiller-attribute", new Object[]{currentMaxActiveInterval, valueFromBotKiller});
                    session.setMaxInactiveInterval(valueFromBotKiller);
                } else {
                    logger.debug("Session interval from BotKiller-attribute {} is not higher than the session interval {}, no need to change", (Object)valueFromBotKiller, (Object)currentMaxActiveInterval);
                }
            } else {
                logger.debug("no BotKiller-attribute in session");
            }
        } else {
            throw new LoginHandlerException("There was no session after calling doLogin", (SAMLAuthenticationTracker)tracker);
        }
    }

    public void authenticateByToken(HttpServletRequest req, HttpServletResponse resp, String token, boolean setRememberMe, SAMLAuthenticationTracker tracker) throws SamlAuthenticationException, IOException {
        throw new SamlAuthenticationException("authenticateByToken in AbstractLoginHandler is not implemented and should never be called", tracker);
    }

    public void showAdditionalAuthenticationResult(SAMLAuthenticationTracker tracker, HttpServletRequest req, HttpServletResponse resp) throws IOException {
        HttpSession session = req.getSession(false);
        if (session != null) {
            session.setAttribute("ADDITIONALAUTH_" + tracker.getTrackerId(), (Object)String.valueOf(System.currentTimeMillis()));
        }
        HashMap<String, Object> ctx = new HashMap<String, Object>();
        ctx.put("trackerid", tracker.getTrackerId());
        ctx.put("ackToken", this.additionalAuthenticationService.createConfirmToken(tracker.getTrackerId()));
        ctx.put("ackMessage", ((AuthenticationTracker)tracker).getConfirmationMessage());
        ctx.put("baseurl", this.samlSsoService.getRelativeBaseUrl());
        ctx.put("ajs-base-url", this.samlSsoService.getAbsoluteBaseUrl());
        HttpUrl baseUrl = HttpUrl.parse((String)this.samlSsoService.getAbsoluteBaseUrl());
        if (baseUrl != null) {
            ctx.put("ajs-server-port", baseUrl.port());
            ctx.put("ajs-server-name", baseUrl.host());
            ctx.put("ajs-server-scheme", baseUrl.scheme());
        } else {
            logger.warn("Failed to parse {}", (Object)this.samlSsoService.getAbsoluteBaseUrl());
        }
        resp.setContentType("text/html;charset=utf-8");
        this.templateRenderer.render("web/additionalAuthentication.vm", ctx, (Writer)resp.getWriter());
    }
}

