/*
 * Decompiled with CFR 0.152.
 */
package com.resolution.atlasplugins.samlsso.userauth;

import com.atlassian.crowd.embedded.api.CrowdDirectoryService;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.crowd.search.query.entity.UserQuery;
import com.atlassian.crowd.search.query.entity.restriction.MatchMode;
import com.atlassian.crowd.search.query.entity.restriction.Property;
import com.atlassian.crowd.search.query.entity.restriction.TermRestriction;
import com.atlassian.crowd.search.query.entity.restriction.constants.UserTermKeys;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.resolution.atlasplugins.samlsso.tracker.AuthenticationTracker;
import com.resolution.atlasplugins.samlsso.userauth.DirectoryAdapter;
import com.resolution.atlasplugins.samlsso.userauth.RemoteDirectoryAdapter;
import com.resolution.atlasplugins.samlsso.userauth.SyncRequiredException;
import com.resolution.samlwrapper.api.exception.SamlAuthenticationException;
import com.resolution.samlwrapper.api.tracker.SAMLAuthenticationTracker;
import de.resolution.commons.util.StringUtil;
import jakarta.annotation.Nonnull;
import java.security.Principal;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDirectoryAdapter
implements DirectoryAdapter {
    private static final Logger logger = LoggerFactory.getLogger(AbstractDirectoryAdapter.class);
    private final TransactionTemplate transactionTemplate;
    private final DirectoryManager directoryManager;
    private final RemoteDirectoryAdapter remoteDirectoryAdapter;
    private final CrowdDirectoryService crowdDirectoryService;

    protected AbstractDirectoryAdapter(RemoteDirectoryAdapter remoteDirectoryAdapter, TransactionTemplate transactionTemplate, DirectoryManager directoryManager, CrowdDirectoryService crowdDirectoryService) {
        this.transactionTemplate = transactionTemplate;
        this.directoryManager = directoryManager;
        this.remoteDirectoryAdapter = remoteDirectoryAdapter;
        this.crowdDirectoryService = crowdDirectoryService;
    }

    @Override
    public Principal findUser(final @Nonnull String findByAttributeName, @Nonnull String findByAttributeValue, @Nonnull AuthenticationTracker tracker, boolean fetchFromRemoteDirectory, boolean triggerUpdateOnCrowdDirectories) throws SamlAuthenticationException {
        if (logger.isDebugEnabled()) {
            logger.debug("Searching for user {}:{}", (Object)StringUtil.sanitize((String)findByAttributeName), (Object)StringUtil.sanitize((String)findByAttributeValue));
        }
        PrincipalAndExceptionHolder resultFromTransaction = (PrincipalAndExceptionHolder)this.transactionTemplate.execute(() -> {
            List<Directory> directories = this.getAllDirectories();
            Object user = null;
            SamlAuthenticationException exceptionInTransaction = null;
            if ("ATTR_NAME".equals(findByAttributeName)) {
                this.publishJiraBeforeUserAuthenticateEvent(findByAttributeValue);
            }
            for (Directory dir : directories) {
                if (dir.isActive()) {
                    long id = dir.getId();
                    try {
                        try {
                            if ("ATTR_NAME".equals(findByAttributeName)) {
                                user = this.directoryManager.findUserByName(id, findByAttributeValue);
                            } else if ("ATTR_EMAIL".equals(findByAttributeName)) {
                                UserQuery eq = new UserQuery(com.atlassian.crowd.model.user.User.class, (SearchRestriction)new TermRestriction(UserTermKeys.EMAIL, MatchMode.EXACTLY_MATCHES, (Object)findByAttributeValue), 0, 2);
                                List users = this.directoryManager.searchUsers(id, (EntityQuery)eq);
                                if (users == null || users.isEmpty()) {
                                    throw new UserNotFoundException("User was not found locally in directory " + dir.getName() + ".");
                                }
                                user = users.size() > 1 ? AbstractDirectoryAdapter.getSingleActiveUser(users, findByAttributeName, findByAttributeValue, dir.getName(), tracker) : (Principal)users.get(0);
                            } else {
                                Property<String> property = new Property<String>(){

                                    public String getPropertyName() {
                                        return findByAttributeName;
                                    }

                                    public Class<String> getPropertyType() {
                                        return String.class;
                                    }
                                };
                                TermRestriction termRestriction = new TermRestriction((Property)property, MatchMode.EXACTLY_MATCHES, (Object)findByAttributeValue);
                                UserQuery eq = new UserQuery(com.atlassian.crowd.model.user.User.class, (SearchRestriction)termRestriction, 0, 2);
                                List users = this.directoryManager.searchUsers(id, (EntityQuery)eq);
                                if (users == null || users.isEmpty()) {
                                    throw new UserNotFoundException("User was not found locally in directory " + dir.getName() + ".");
                                }
                                user = users.size() > 1 ? AbstractDirectoryAdapter.getSingleActiveUser(users, findByAttributeName, findByAttributeValue, dir.getName(), tracker) : (Principal)users.get(0);
                            }
                            logger.debug("Found user {} in directory {}", (Object)user.getName(), (Object)dir.getName());
                            this.remoteDirectoryAdapter.assignDirectoryDefaultGroups((Principal)user, dir, tracker);
                        }
                        catch (UserNotFoundException e) {
                            logger.debug("User was not found locally in {}.", (Object)dir.getName());
                            user = this.remoteDirectoryAdapter.findRemoteUser(findByAttributeName, findByAttributeValue, dir, tracker, fetchFromRemoteDirectory, triggerUpdateOnCrowdDirectories);
                        }
                    }
                    catch (SamlAuthenticationException e) {
                        tracker.add(logger, SAMLAuthenticationTracker.Level.WARNING, "Finding the user in directory {} failed", new Object[]{dir.getName(), e});
                        exceptionInTransaction = e;
                    }
                    catch (Exception e) {
                        tracker.add(logger, SAMLAuthenticationTracker.Level.WARNING, "Finding the user in directory {} failed", new Object[]{dir.getName(), e});
                        exceptionInTransaction = new SamlAuthenticationException((Throwable)e, (SAMLAuthenticationTracker)tracker);
                    }
                    if (user == null) continue;
                    try {
                        this.remoteDirectoryAdapter.updateRemoteUser(user.getName(), dir, tracker, fetchFromRemoteDirectory, triggerUpdateOnCrowdDirectories);
                    }
                    catch (SyncRequiredException se) {
                        exceptionInTransaction = se;
                    }
                    if ("ATTR_NAME".equals(findByAttributeName)) break;
                    this.publishJiraBeforeUserAuthenticateEvent(user.getName());
                    break;
                }
                logger.debug("Skipping inactive directory {}", (Object)dir.getName());
            }
            PrincipalAndExceptionHolder result = new PrincipalAndExceptionHolder();
            result.ex = exceptionInTransaction;
            result.principal = user;
            return result;
        });
        if (resultFromTransaction.ex == null) {
            return resultFromTransaction.principal;
        }
        throw resultFromTransaction.ex;
    }

    @Nonnull
    static com.atlassian.crowd.model.user.User getSingleActiveUser(List<com.atlassian.crowd.model.user.User> users, String findByAttributeName, String findByAttributeValue, String directoryName, AuthenticationTracker tracker) throws SamlAuthenticationException {
        List activeUsers = users.stream().filter(User::isActive).collect(Collectors.toList());
        if (activeUsers.isEmpty()) {
            tracker.add(logger, SAMLAuthenticationTracker.Level.ERROR, "Multiple users with " + findByAttributeName + "=" + findByAttributeValue + " found in directory " + directoryName + ", but none of them are active.", new Object[0]);
            throw new SamlAuthenticationException("Multiple users were found for the configured primary attribute.", (SAMLAuthenticationTracker)tracker);
        }
        if (activeUsers.size() > 1) {
            tracker.add(logger, SAMLAuthenticationTracker.Level.ERROR, "Multiple active users with " + findByAttributeName + "=" + findByAttributeValue + " found in directory " + directoryName + ".", new Object[0]);
            throw new SamlAuthenticationException("Multiple users were found for the configured primary attribute.", (SAMLAuthenticationTracker)tracker);
        }
        tracker.add(logger, SAMLAuthenticationTracker.Level.INFO, "Found multiple users with " + findByAttributeName + ", but only one is active.", new Object[0]);
        return (com.atlassian.crowd.model.user.User)activeUsers.get(0);
    }

    @Override
    public boolean directoryExists(long directoryId) {
        try {
            this.directoryManager.findDirectoryById(directoryId);
            return true;
        }
        catch (DirectoryNotFoundException e) {
            return false;
        }
    }

    @Override
    public List<Directory> getAllDirectories() {
        return this.crowdDirectoryService.findAllDirectories();
    }

    @Override
    public void publishJiraBeforeUserAuthenticateEvent(@Nonnull String username) {
    }

    private static class PrincipalAndExceptionHolder {
        public Principal principal;
        public SamlAuthenticationException ex;

        private PrincipalAndExceptionHolder() {
        }
    }
}

