/*
 * Decompiled with CFR 0.152.
 */
package com.resolution.atlasplugins.samlsso.userauth;

import com.atlassian.seraph.auth.AuthenticatorException;
import com.atlassian.seraph.auth.DefaultAuthenticator;
import com.atlassian.seraph.service.rememberme.RememberMeService;
import com.resolution.atlasplugins.samlsso.auditlog.AuditLogService;
import com.resolution.atlasplugins.samlsso.tracker.AuthenticationTracker;
import com.resolution.atlasplugins.samlsso.tracker.AuthenticationTrackerImpl;
import com.resolution.atlasplugins.samlsso.userauth.AuthenticatorDetector;
import com.resolution.atlasplugins.samlsso.userauth.AuthenticatorHook;
import com.resolution.atlasplugins.samlsso.userauth.AuthenticatorHookException;
import com.resolution.samlwrapper.api.ProgressLogger;
import com.resolution.samlwrapper.api.tracker.SAMLAuthenticationTracker;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.Principal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAuthenticatorHook
implements AuthenticatorHook,
AuthenticatorDetector {
    private static final Logger logger = LoggerFactory.getLogger(AbstractAuthenticatorHook.class);
    private final AuditLogService auditLogService;

    protected abstract DefaultAuthenticator getAuthenticator();

    protected AbstractAuthenticatorHook(AuditLogService auditLogService) {
        this.auditLogService = auditLogService;
    }

    @Override
    public boolean isAuthenticatorBased() {
        return true;
    }

    @Override
    public boolean isCrowdAuthenticator() {
        return false;
    }

    @Override
    public boolean isLoggedInUser(@Nonnull HttpServletRequest httpServletRequest) {
        return false;
    }

    @Override
    public boolean logout(@Nonnull HttpServletRequest req, @Nonnull HttpServletResponse resp, @Nonnull AuthenticationTracker tracker) {
        logger.debug("Calling Authenticator.logout()");
        HttpSession currentSession = req.getSession(false);
        if (currentSession != null) {
            currentSession.invalidate();
        }
        try {
            boolean logoutSuccessful = this.getAuthenticator().logout(req, resp);
            if (logoutSuccessful) {
                tracker.setStatus(SAMLAuthenticationTracker.Status.LOGGED_OUT);
                this.auditLogService.logLogout(tracker.getUserId());
            }
            return logoutSuccessful;
        }
        catch (AuthenticatorException e) {
            throw new AuthenticatorHookException(e, tracker);
        }
    }

    @Override
    public boolean authoriseUserAndEstablishSession(@Nonnull HttpServletRequest httpServletRequest, @Nonnull HttpServletResponse httpServletResponse, @Nonnull Principal principal, boolean setRememberMe, boolean sdCustomerLogin, @Nonnull AuthenticationTracker tracker) {
        ProgressLogger.log((String)"Authorizing user and establishing session", (SAMLAuthenticationTracker)tracker);
        this.checkForCrowdAuthenticator();
        boolean authenticated = this.doAuthoriseUserAndEstablishSession(httpServletRequest, httpServletResponse, principal, sdCustomerLogin, tracker);
        if (authenticated && setRememberMe) {
            this.addRememberMeCookie(httpServletRequest, httpServletResponse, principal.getName(), tracker);
        }
        return authenticated;
    }

    public abstract boolean doAuthoriseUserAndEstablishSession(@Nonnull HttpServletRequest var1, @Nonnull HttpServletResponse var2, @Nullable Principal var3, boolean var4, @Nonnull AuthenticationTracker var5);

    @Override
    public void addRememberMeCookie(@Nonnull HttpServletRequest request, @Nonnull HttpServletResponse response, @Nonnull String userid, @Nonnull AuthenticationTracker tracker) {
        logger.debug("Setting rememberMeCookie for {}", (Object)userid);
        RememberMeService rememberMeService = null;
        Class<DefaultAuthenticator> authenticatorClass = DefaultAuthenticator.class;
        String methodName = "getRememberMeService";
        try {
            Method methodToInvoke = authenticatorClass.getDeclaredMethod(methodName, new Class[0]);
            methodToInvoke.setAccessible(true);
            Object returnValue = methodToInvoke.invoke((Object)this.getAuthenticator(), new Object[0]);
            if (returnValue instanceof RememberMeService) {
                rememberMeService = (RememberMeService)returnValue;
            } else {
                tracker.add(logger, SAMLAuthenticationTracker.Level.ERROR, "Authenticator method {} did not return a RememberMeService, but a {}", new Object[]{methodName, returnValue.getClass().getCanonicalName()});
            }
        }
        catch (IllegalAccessException | NoSuchMethodException | SecurityException e) {
            tracker.add(logger, SAMLAuthenticationTracker.Level.ERROR, "Calling {} via reflection failed", new Object[]{methodName, e});
        }
        catch (InvocationTargetException e) {
            tracker.add(logger, SAMLAuthenticationTracker.Level.ERROR, "Calling {} via reflection failed", new Object[]{methodName, methodName, e.getCause()});
        }
        String addCookieMethodName = "addRememberMeCookie";
        Class[] parameterTypes = new Class[]{HttpServletRequest.class, HttpServletResponse.class, String.class};
        Object[] parameters = new Object[]{request, response, userid};
        if (rememberMeService != null) {
            try {
                Class rememberMeServiceClass = rememberMeService.getClass();
                logger.debug("Scanning methods for {}", (Object)rememberMeServiceClass.getCanonicalName());
                Method methodToInvoke = rememberMeServiceClass.getMethod(addCookieMethodName, parameterTypes);
                methodToInvoke.setAccessible(true);
                methodToInvoke.invoke((Object)rememberMeService, parameters);
                logger.debug("Calling {} succeeded.", (Object)addCookieMethodName);
            }
            catch (IllegalAccessException | NoSuchMethodException | SecurityException e) {
                tracker.add(logger, SAMLAuthenticationTracker.Level.ERROR, "Calling {} via reflection failed", new Object[]{methodName, addCookieMethodName, e});
            }
            catch (InvocationTargetException e) {
                tracker.add(logger, SAMLAuthenticationTracker.Level.ERROR, "Calling {} via reflection failed", new Object[]{methodName, addCookieMethodName, e.getCause()});
            }
        } else {
            tracker.add(logger, SAMLAuthenticationTracker.Level.ERROR, "rememberMeService is null, seems like something bad has happened", new Object[0]);
        }
    }

    private void checkForCrowdAuthenticator() {
        if (this.isCrowdAuthenticator()) {
            throw new AuthenticatorHookException("The configured Authenticator is a " + this.getAuthenticatorClass() + " wich does not work together with SAML SingleSignOn. Edit seraph.xml to the defaults, restart the application and try again", (AuthenticationTracker)new AuthenticationTrackerImpl("INITIAL"));
        }
    }
}

