/*
 * Decompiled with CFR 0.152.
 */
package com.resolution.atlasplugins.samlsso.servlet;

import com.resolution.atlasplugins.samlsso.Utils;
import com.resolution.atlasplugins.samlsso.configuration.ConfigurationData;
import com.resolution.atlasplugins.samlsso.configuration.RunningConfiguration;
import de.resolution.reconfigure.InsufficientUserPrivilegeException;
import de.resolution.reconfigure.PrivilegeChecker;
import jakarta.inject.Inject;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import java.util.Objects;
import org.springframework.stereotype.Component;

@Path(value="/reset/entityid")
@Component
public class ResetEntityIdRestResource {
    private final RunningConfiguration pluginConfiguration;
    private final PrivilegeChecker privilegeChecker;

    @Inject
    public ResetEntityIdRestResource(RunningConfiguration pluginConfiguration, PrivilegeChecker privilegeChecker) {
        this.pluginConfiguration = pluginConfiguration;
        this.privilegeChecker = privilegeChecker;
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response resetEntityId(@Context HttpServletRequest request) throws InsufficientUserPrivilegeException {
        this.privilegeChecker.checkSysAdmin(request);
        String currentEntityId = this.pluginConfiguration.getEntityId();
        String defaultEntityId = this.pluginConfiguration.getDefaultEntityId();
        if (Objects.equals(currentEntityId, defaultEntityId)) {
            return Response.notModified().cacheControl(Utils.ccNoCache).build();
        }
        ConfigurationData configurationData = this.pluginConfiguration.getConfigurationData();
        configurationData.entityId = defaultEntityId;
        if (this.pluginConfiguration.update(configurationData)) {
            return Response.noContent().cacheControl(Utils.ccNoCache).build();
        }
        return Response.serverError().entity(Utils.createMessageForJson("Updating configuration failed, check log for details")).cacheControl(Utils.ccNoCache).build();
    }
}

