/*
 * Decompiled with CFR 0.152.
 */
package com.resolution.atlasplugins.samlsso.servlet;

import com.atlassian.templaterenderer.TemplateRenderer;
import com.resolution.atlasplugins.samlsso.SamlSsoService;
import com.resolution.atlasplugins.samlsso.servlet.BasicServlet;
import com.resolution.samlwrapper.api.PluginProperties;
import jakarta.annotation.Nonnull;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;

public class RedirectToReleaseNotesServlet
extends BasicServlet {
    public RedirectToReleaseNotesServlet(SamlSsoService samlSsoService, TemplateRenderer renderer) {
        super(samlSsoService, renderer);
    }

    @Override
    public void processRequest(@Nonnull HttpServletRequest req, @Nonnull HttpServletResponse resp) throws ServletException, IOException {
        String hostProduct = "jira";
        if (this.samlSsoService.isBamboo()) {
            hostProduct = "bamboo";
        } else if (this.samlSsoService.isBitbucket()) {
            hostProduct = "bitbucket";
        } else if (this.samlSsoService.isConfluence()) {
            hostProduct = "confluence";
        } else if (this.samlSsoService.isFecru()) {
            hostProduct = "fecru";
        }
        String appVersion = PluginProperties.get((String)"pluginVersion");
        if (appVersion.contains("-")) {
            appVersion = appVersion.substring(0, appVersion.indexOf(45));
        }
        resp.setHeader("cache-control", "no-cache, no-store, must-revalidate");
        resp.sendRedirect("https://resolution.de/go/ssso/" + appVersion + "/" + hostProduct + "/releasenotes");
    }
}

