/*
 * Decompiled with CFR 0.152.
 */
package com.resolution.atlasplugins.samlsso.servlet;

import com.atlassian.plugin.spring.scanner.annotation.component.BambooComponent;
import com.resolution.atlasplugins.samlsso.SamlSsoService;
import com.resolution.atlasplugins.samlsso.bamboo.userauth.BambooAuthenticatorHook;
import jakarta.inject.Inject;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@BambooComponent
public class RedirectToLogoutBambooFilter
implements Filter {
    private final BambooAuthenticatorHook bambooAuthenticatorHook;
    private final SamlSsoService samlssoService;
    private static final Logger logger = LoggerFactory.getLogger(RedirectToLogoutBambooFilter.class);

    @Inject
    public RedirectToLogoutBambooFilter(BambooAuthenticatorHook bambooAuthenticatorHook, SamlSsoService samlSsoService) {
        this.bambooAuthenticatorHook = bambooAuthenticatorHook;
        this.samlssoService = samlSsoService;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        String redirectUrl;
        if (logger.isDebugEnabled()) {
            logger.debug("Call to Bamboo logout intercepted. User isLoggedIn? {}", (Object)this.bambooAuthenticatorHook.isLoggedInUser((HttpServletRequest)servletRequest));
        }
        if ((redirectUrl = this.samlssoService.executeLogout((HttpServletRequest)servletRequest)) != null) {
            ((HttpServletResponse)servletResponse).sendRedirect(redirectUrl);
            return;
        }
        filterChain.doFilter(servletRequest, servletResponse);
    }

    public void destroy() {
    }
}

