/*
 * Decompiled with CFR 0.152.
 */
package com.resolution.atlasplugins.samlsso.servlet;

import com.atlassian.confluence.compat.api.service.accessmode.ReadOnlyAccessAllowed;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.resolution.atlasplugins.samlsso.Utils;
import com.resolution.atlasplugins.samlsso.servlet.ErrorResponse;
import com.resolution.atlasplugins.samlsso.servlet.MetadataFetchingInformation;
import com.resolution.samlwrapper.api.IdPMetadata;
import com.resolution.samlwrapper.api.SAMLWrapper;
import com.resolution.samlwrapper.api.exception.SAMLWrapperException;
import de.resolution.reconfigure.InsufficientUserPrivilegeException;
import de.resolution.reconfigure.PrivilegeChecker;
import jakarta.inject.Inject;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Path(value="/readMetadata")
@Component
public class ReadSamlMetadataRestResource {
    private final SAMLWrapper samlWrapper;
    private final PrivilegeChecker privilegeChecker;
    private static final Logger logger = LoggerFactory.getLogger(ReadSamlMetadataRestResource.class);
    private final ObjectMapper objectMapper = new ObjectMapper();

    @Inject
    public ReadSamlMetadataRestResource(SAMLWrapper samlWrapper, PrivilegeChecker privilegeChecker) {
        this.samlWrapper = samlWrapper;
        this.privilegeChecker = privilegeChecker;
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ReadOnlyAccessAllowed
    public Response readMetadataFromURL(String fetchingInfoString, @Context HttpServletRequest request) throws InsufficientUserPrivilegeException, IOException {
        this.privilegeChecker.checkSysAdmin(request);
        MetadataFetchingInformation fetchingInfo = (MetadataFetchingInformation)this.objectMapper.readValue(fetchingInfoString, MetadataFetchingInformation.class);
        try {
            IdPMetadata idpMetadata;
            if (fetchingInfo.useMetadataxml) {
                if (fetchingInfo.metadataXML == null || fetchingInfo.metadataXML.trim().isEmpty()) {
                    return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)Utils.asJson(new ErrorResponse("no XML provided"))).cacheControl(Utils.ccNoCache).build();
                }
                idpMetadata = this.samlWrapper.readIdPMetadata(fetchingInfo.metadataXML, false, fetchingInfo.metadataSignatureCertificate);
            } else {
                if (fetchingInfo.metadataURL == null || fetchingInfo.metadataURL.trim().isEmpty()) {
                    return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)Utils.asJson(new ErrorResponse("no URL provided"))).cacheControl(Utils.ccNoCache).build();
                }
                idpMetadata = this.samlWrapper.readIdPMetadata(fetchingInfo.metadataURL, fetchingInfo.ignoreCertificate, fetchingInfo.metadataSignatureCertificate);
            }
            return Response.ok().entity((Object)Utils.asJson(idpMetadata)).cacheControl(Utils.ccNoCache).build();
        }
        catch (SAMLWrapperException e) {
            logger.warn("Reading metadata failed, returning 400", (Throwable)e);
            Object message = e.getMessage();
            if (e.getCause() != null) {
                message = (String)message + ": " + e.getCause().getMessage();
            }
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)Utils.asJson(new ErrorResponse("Fetching Metadata failed: " + (String)message))).cacheControl(Utils.ccNoCache).build();
        }
    }
}

