/*
 * Decompiled with CFR 0.152.
 */
package com.resolution.atlasplugins.samlsso.servlet;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.resolution.atlasplugins.samlsso.InternalAdditionalAuthenticationService;
import com.resolution.atlasplugins.samlsso.Utils;
import de.resolution.commons.util.StringUtil;
import de.resolution.samlauth.api.AdditionalAuthenticationData;
import de.resolution.samlauth.api.AdditionalAuthenticationStatus;
import jakarta.inject.Inject;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@Path(value="/additionalauth")
public class AdditionalAuthenticationRestResource {
    private final InternalAdditionalAuthenticationService additionalAuthenticationService;
    private final ObjectMapper objectMapper = new ObjectMapper();
    private static final Logger logger = LoggerFactory.getLogger(AdditionalAuthenticationRestResource.class);

    @Inject
    public AdditionalAuthenticationRestResource(InternalAdditionalAuthenticationService additionalAuthenticationService) {
        this.additionalAuthenticationService = additionalAuthenticationService;
    }

    @POST
    @Path(value="/new")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response createNewAdditionalAuthentication(String createNewStatusDTOString, @Context HttpServletRequest request) {
        CreateNewStatusDTO createNewStatusDTO;
        try {
            createNewStatusDTO = (CreateNewStatusDTO)this.objectMapper.readValue(createNewStatusDTOString, CreateNewStatusDTO.class);
        }
        catch (IOException e) {
            logger.warn("Could not parse CreateNewStatusDTO from {}", (Object)StringUtil.sanitize((String)createNewStatusDTOString), (Object)e);
            return Response.status((int)400).build();
        }
        AdditionalAuthenticationData authenticationData = this.additionalAuthenticationService.requestAuthentication(request, createNewStatusDTO.getConfirmationMessage());
        return Response.ok().entity((Object)Utils.asJsonString(authenticationData)).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/enabled")
    public Response isAdditionalAuthenticationEnabled(@Context HttpServletRequest request) {
        return Response.ok().entity((Object)Utils.asJsonString(this.additionalAuthenticationService.getEnablementStatus(request))).build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/status/{id}")
    public Response getStatus(@PathParam(value="id") String id, @Context HttpServletRequest request) {
        AdditionalAuthenticationStatus status = this.additionalAuthenticationService.getStatus(id);
        if (status == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        return Response.ok().entity((Object)Utils.asJsonString(status)).build();
    }

    @PUT
    @Produces(value={"application/json"})
    @Path(value="/ack/{token}")
    public Response acknowledge(@PathParam(value="token") String token, @Context HttpServletRequest request) {
        if (this.additionalAuthenticationService.confirm(token)) {
            return Response.ok().build();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }

    @JsonAutoDetect
    public static class CreateNewStatusDTO {
        private final String confirmationMessage;

        @JsonCreator
        public CreateNewStatusDTO(@JsonProperty(value="confirmationMessage") String confirmationMessage) {
            this.confirmationMessage = confirmationMessage;
        }

        public String getConfirmationMessage() {
            return this.confirmationMessage;
        }
    }
}

