/*
 * Decompiled with CFR 0.152.
 */
package com.resolution.atlasplugins.samlsso.oidcandoauth.oidc;

import com.atlassian.confluence.compat.api.service.accessmode.ReadOnlyAccessAllowed;
import com.resolution.atlasplugins.samlsso.Utils;
import com.resolution.atlasplugins.samlsso.servlet.ErrorResponse;
import com.resolution.samlwrapper.api.SAMLWrapper;
import de.resolution.commons.data.MapStructuredData;
import de.resolution.commons.data.StructuredData;
import de.resolution.commons.net.HTTPWrapper;
import de.resolution.commons.net.ResponseWrapper;
import de.resolution.commons.util.Elvis;
import de.resolution.commons.util.JSONUtil;
import de.resolution.reconfigure.InsufficientUserPrivilegeException;
import de.resolution.reconfigure.PrivilegeChecker;
import jakarta.inject.Inject;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import org.springframework.stereotype.Component;

@Path(value="/readOidcMetadata")
@Component
public class ReadOidcMetadataRestResource {
    private final PrivilegeChecker privilegeChecker;
    private final HTTPWrapper httpWrapper = new HTTPWrapper();

    @Inject
    public ReadOidcMetadataRestResource(SAMLWrapper samlWrapper, PrivilegeChecker privilegeChecker) {
        this.privilegeChecker = privilegeChecker;
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ReadOnlyAccessAllowed
    public Response readMetadataFromURL(String fetchingInfoString, @Context HttpServletRequest request) throws InsufficientUserPrivilegeException, IOException {
        this.privilegeChecker.checkSysAdmin(request);
        Map postBody = JSONUtil.deserializeMap((String)fetchingInfoString, String.class, String.class);
        if (postBody.isEmpty()) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)Utils.asJson(new ErrorResponse("No body in request to backend"))).cacheControl(Utils.ccNoCache).build();
        }
        if (!postBody.containsKey("wellKnownUrl")) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)Utils.asJson(new ErrorResponse("No wellknownUrl in request to backend"))).cacheControl(Utils.ccNoCache).build();
        }
        String wellKnownUrl = (String)postBody.get("wellKnownUrl");
        ResponseWrapper result = this.httpWrapper.get(wellKnownUrl);
        if (!result.isSuccess()) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)Utils.asJson(new ErrorResponse("Could not fetch metadata from url"))).cacheControl(Utils.ccNoCache).build();
        }
        MapStructuredData res = result.getBodyAsStructuredData().asMap();
        StructuredData userInfo = res.get((Object)"userinfo_endpoint");
        res.put((Object)"userinfo_endpoint", Collections.singletonList(userInfo));
        return Response.ok().entity((Object)Utils.asJson(Elvis.ifNull((Object)res, (Object)StructuredData.create()))).cacheControl(Utils.ccNoCache).build();
    }
}

