/*
 * Decompiled with CFR 0.152.
 */
package com.resolution.atlasplugins.samlsso.oidcandoauth.oidc;

import com.auth0.jwt.interfaces.DecodedJWT;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.resolution.atlasplugins.samlsso.Utils;
import com.resolution.atlasplugins.samlsso.configuration.RunningConfiguration;
import com.resolution.atlasplugins.samlsso.configuration.oidc.OidcRunningIdpConfiguration;
import com.resolution.atlasplugins.samlsso.oidcandoauth.OidcAndOAuthCommonHelpers;
import com.resolution.atlasplugins.samlsso.oidcandoauth.oidc.IdTokenHelper;
import com.resolution.atlasplugins.samlsso.oidcandoauth.oidc.Nonce;
import com.resolution.atlasplugins.samlsso.oidcandoauth.oidc.OAuthFlowResult;
import com.resolution.atlasplugins.samlsso.tracker.AuthenticationTracker;
import com.resolution.samlwrapper.api.tracker.SAMLAuthenticationTracker;
import de.resolution.commons.data.StructuredData;
import de.resolution.commons.util.StringUtil;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import okhttp3.HttpUrl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OidcSpecificHelpers {
    private static final Logger logger = LoggerFactory.getLogger(OidcSpecificHelpers.class);
    private static final String PATH_TO_OIDC_SERVLET = "/plugins/servlet/samlsso/oidc";
    public static final String REAUTH_SEPARATOR = ":";

    private OidcSpecificHelpers() {
    }

    public static void initiateLogin(@Nonnull OidcRunningIdpConfiguration oidcConfig, @Nonnull HttpServletResponse resp, @Nonnull String baseUrl, @Nonnull AuthenticationTracker tracker) throws IOException {
        OidcSpecificHelpers.initiateLogin(oidcConfig, resp, baseUrl, tracker, false, null, null);
    }

    public static void initiateLogin(@Nonnull OidcRunningIdpConfiguration oidcConfig, @Nonnull HttpServletResponse resp, @Nonnull String baseUrl, @Nonnull AuthenticationTracker tracker, @Nullable String loginHintValue, @Nullable String domainHintValue) throws IOException {
        OidcSpecificHelpers.initiateLogin(oidcConfig, resp, baseUrl, tracker, false, loginHintValue, domainHintValue);
    }

    public static void initiateLogin(@Nonnull OidcRunningIdpConfiguration oidcConfig, @Nonnull HttpServletResponse resp, @Nonnull String baseUrl, @Nonnull AuthenticationTracker tracker, boolean reauthenticate, @Nullable String loginHintValue, @Nullable String domainHintValue) throws IOException {
        HttpUrl url = HttpUrl.parse((String)oidcConfig.getAuthEndpoint());
        if (url == null) {
            throw new IllegalArgumentException("url is not an url");
        }
        String nonce = Nonce.create();
        HttpUrl.Builder urlBuilder = url.newBuilder().addQueryParameter("response_type", oidcConfig.getOauthFlow().getFlowName()).addQueryParameter("scope", oidcConfig.getScopesAsString()).addQueryParameter("client_id", oidcConfig.getClientId()).addQueryParameter("redirect_uri", OidcSpecificHelpers.getFullPathToOidcServlet(baseUrl)).addQueryParameter("response_mode", oidcConfig.getResponseMode());
        if (oidcConfig.sendAndVerifyNonce()) {
            urlBuilder.addQueryParameter("nonce", nonce);
        }
        if (!StringUtil.isNullOrEmpty((String)domainHintValue)) {
            urlBuilder.addQueryParameter("domain_hint", domainHintValue);
        }
        if (oidcConfig.shouldSendLoginHint()) {
            if (!StringUtil.isNullOrEmpty((String)loginHintValue)) {
                urlBuilder.addQueryParameter(oidcConfig.getLoginHintParameterName(), loginHintValue);
            } else {
                tracker.add(logger, SAMLAuthenticationTracker.Level.ERROR, "Should sent email as login_hint parameter, but login hint is null or empty", new Object[0]);
            }
        }
        oidcConfig.getAdditionalAuthRequestParameters().forEach(kv -> urlBuilder.addQueryParameter(kv.getKey(), kv.getValue()));
        if (oidcConfig.usePkce()) {
            OidcAndOAuthCommonHelpers.addPkceToRequest(urlBuilder, oidcConfig, tracker);
        }
        if (reauthenticate) {
            urlBuilder.addQueryParameter("max_age", "0");
            urlBuilder.addQueryParameter("prompt", "login");
            urlBuilder.addQueryParameter("state", tracker.getTrackerId() + ":REAUTHENTICATE");
        } else {
            urlBuilder.addQueryParameter("state", tracker.getTrackerId());
        }
        url = urlBuilder.build();
        if (oidcConfig.sendAndVerifyNonce()) {
            tracker.setNonce(nonce);
        }
        tracker.setClientId(oidcConfig.getClientId());
        if (reauthenticate) {
            tracker.add(logger, SAMLAuthenticationTracker.Level.DEBUG, "Redirecting user to for reauthentication {}", new Object[]{url});
        } else {
            tracker.add(logger, SAMLAuthenticationTracker.Level.DEBUG, "Redirecting user to for authentication {}", new Object[]{url});
        }
        tracker.setStatus(SAMLAuthenticationTracker.Status.IN_PROGRESS);
        oidcConfig.getAuthEndpointRequestHeaders().forEach(kV -> resp.addHeader(kV.getKey(), kV.getValue()));
        resp.sendRedirect(url.toString());
    }

    @Nonnull
    public static String getFullPathToOidcServlet(@Nonnull String baseUrl) {
        return baseUrl + PATH_TO_OIDC_SERVLET;
    }

    @Nonnull
    public static OAuthFlowResult handleCodeFlow(@Nonnull OidcRunningIdpConfiguration config, @Nonnull String code, @Nonnull AuthenticationTracker tracker, @Nonnull RunningConfiguration runningConfiguration, @Nonnull String baseUrl) throws JsonProcessingException {
        DecodedJWT decodedToken;
        StructuredData idAndAccessToken = OidcAndOAuthCommonHelpers.exchangeCodeWithIdp(config, code, tracker, baseUrl, OidcSpecificHelpers.getFullPathToOidcServlet(baseUrl));
        if (idAndAccessToken.isEmpty()) {
            return new OAuthFlowResult("No id and access token present");
        }
        tracker.setSamlStatus(SAMLAuthenticationTracker.SamlStatus.RECEIVED_RESPONSE);
        String idToken = (String)idAndAccessToken.asStringMap().get("id_token");
        if (idToken == null || idToken.trim().isEmpty()) {
            return new OAuthFlowResult("No id token present");
        }
        idToken = idToken.trim();
        tracker.add(logger, SAMLAuthenticationTracker.Level.DEBUG, "Extracted id token successfully", new Object[0]);
        tracker.add(logger, SAMLAuthenticationTracker.Level.DEBUG, "Extracted access token successfully", new Object[0]);
        if (logger.isDebugEnabled()) {
            logger.debug("Got an id_token: {}", (Object)idToken);
        }
        if ((decodedToken = IdTokenHelper.decodeAndVerifyIdToken(idToken, config, tracker, runningConfiguration)) == null) {
            return new OAuthFlowResult("Could not decode and verify the ID token. Please refer to the logs.");
        }
        tracker.setIdToken(idToken);
        StructuredData claims = IdTokenHelper.extractClaimsFromIdToken(decodedToken);
        if (logger.isDebugEnabled()) {
            logger.debug("Got the following id token claims: \n{}", (Object)Utils.asJson(claims));
        }
        tracker.add(logger, SAMLAuthenticationTracker.Level.DEBUG, "Got id token claims", new Object[0]);
        if (config.isFetchUserInfo()) {
            StructuredData additionalUserInfos;
            String accessToken = (String)idAndAccessToken.asStringMap().get("access_token");
            if (accessToken == null || accessToken.trim().isEmpty()) {
                return new OAuthFlowResult("No access token present, but UserInfo endpoints should be used");
            }
            accessToken = accessToken.trim();
            if (logger.isDebugEnabled()) {
                logger.debug("Got an access_token: {}", (Object)accessToken);
            }
            if (!(additionalUserInfos = OidcAndOAuthCommonHelpers.getInformationFromUserInfoEndpoints(accessToken, config, tracker)).isEmpty()) {
                tracker.add(logger, SAMLAuthenticationTracker.Level.DEBUG, "Got the following from user endpoint token claims: \n{}", new Object[]{Utils.asJson(additionalUserInfos.asStringMap())});
                claims = additionalUserInfos.mergeInto(claims);
            }
        }
        return new OAuthFlowResult(claims);
    }
}

