/*
 * Decompiled with CFR 0.152.
 */
package com.resolution.atlasplugins.samlsso.oidcandoauth.oidc;

import com.auth0.jwk.Jwk;
import com.auth0.jwk.JwkException;
import com.auth0.jwk.JwkProvider;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JwksUriProvider
implements JwkProvider {
    private final Logger logger = LoggerFactory.getLogger(JwksUriProvider.class);
    private final String urlToKeys;

    public JwksUriProvider(String urlToKeys) {
        this.urlToKeys = urlToKeys;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nonnull
    private List<Jwk> readAllJwks() {
        Request request = new Request.Builder().url(this.urlToKeys).get().build();
        OkHttpClient okHttpClient = new OkHttpClient();
        try (Response r = okHttpClient.newCall(request).execute();){
            ResponseBody rb = r.body();
            if (rb == null) return Collections.emptyList();
            TypeReference<Map<String, List<Map<String, Object>>>> typeRef = new TypeReference<Map<String, List<Map<String, Object>>>>(){};
            Map map = (Map)new ObjectMapper().readValue(rb.string(), (TypeReference)typeRef);
            if (!map.containsKey("keys")) return Collections.emptyList();
            List keys = (List)map.get("keys");
            List<Jwk> list = keys.stream().map(Jwk::fromValues).collect(Collectors.toList());
            return list;
        }
        catch (IOException e) {
            this.logger.error("Could not retrieve pkeys, because of the following exception", (Throwable)e);
            return Collections.emptyList();
        }
    }

    @Nonnull
    public Jwk get(String kid) throws JwkException {
        List<Jwk> keys = this.readAllJwks();
        List filtered = keys.stream().filter(key -> key.getId().equals(kid)).collect(Collectors.toList());
        if (filtered.isEmpty()) {
            throw new JwkException("There is no key for kid: " + kid);
        }
        if (filtered.size() > 1) {
            throw new JwkException("There is more than one key for kid=" + kid + " ; See:\n" + String.valueOf(filtered));
        }
        Jwk key2 = (Jwk)filtered.get(0);
        if (key2 == null) {
            throw new JwkException("The retrieved key is null");
        }
        return key2;
    }

    public List<Jwk> getAll() {
        return new ArrayList<Jwk>(this.readAllJwks());
    }
}

