/*
 * Decompiled with CFR 0.152.
 */
package com.resolution.atlasplugins.samlsso.oidcandoauth.oauth2;

import com.resolution.atlasplugins.samlsso.configuration.oauth.OAuth2RunningIdpConfiguration;
import com.resolution.atlasplugins.samlsso.oidcandoauth.OidcAndOAuthCommonHelpers;
import com.resolution.atlasplugins.samlsso.oidcandoauth.oidc.OAuthFlowResult;
import com.resolution.atlasplugins.samlsso.tracker.AuthenticationTracker;
import com.resolution.samlwrapper.api.tracker.SAMLAuthenticationTracker;
import de.resolution.commons.data.StructuredData;
import jakarta.annotation.Nonnull;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import okhttp3.HttpUrl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAuth2SpecificHelpers {
    private static final Logger logger = LoggerFactory.getLogger(OAuth2SpecificHelpers.class);
    private static final String PATH_TO_OAUTH2_SERVLET = "/plugins/servlet/samlsso/oauth2";

    protected OAuth2SpecificHelpers() {
    }

    public static void initiateLogin(@Nonnull OAuth2RunningIdpConfiguration oauthConfig, @Nonnull HttpServletResponse resp, @Nonnull String baseUrl, @Nonnull AuthenticationTracker tracker) throws IOException {
        HttpUrl url = HttpUrl.parse((String)oauthConfig.getAuthEndpoint());
        if (url == null) {
            throw new IllegalArgumentException("url is not an url");
        }
        HttpUrl.Builder urlBuilder = url.newBuilder().addQueryParameter("response_type", oauthConfig.getOauthFlow().getFlowName()).addQueryParameter("scope", oauthConfig.getScopesAsString()).addQueryParameter("client_id", oauthConfig.getClientId()).addQueryParameter("state", tracker.getTrackerId()).addQueryParameter("redirect_uri", OAuth2SpecificHelpers.getFullPathToOAuth2Servlet(baseUrl));
        oauthConfig.getAdditionalAuthRequestParameters().forEach(keyValue -> urlBuilder.addQueryParameter(keyValue.getKey(), keyValue.getValue()));
        if (oauthConfig.usePkce()) {
            OidcAndOAuthCommonHelpers.addPkceToRequest(urlBuilder, oauthConfig, tracker);
        }
        url = urlBuilder.build();
        tracker.setClientId(oauthConfig.getClientId());
        tracker.add(logger, SAMLAuthenticationTracker.Level.DEBUG, "Redirecting user to {}", new Object[]{url});
        tracker.setStatus(SAMLAuthenticationTracker.Status.IN_PROGRESS);
        oauthConfig.getAuthEndpointRequestHeaders().forEach(kV -> resp.addHeader(kV.getKey(), kV.getValue()));
        resp.sendRedirect(url.toString());
    }

    @Nonnull
    public static String getFullPathToOAuth2Servlet(@Nonnull String baseUrl) {
        return baseUrl + PATH_TO_OAUTH2_SERVLET;
    }

    public static OAuthFlowResult handleCodeFlow(OAuth2RunningIdpConfiguration config, String code, AuthenticationTracker tracker, String baseUrl) {
        StructuredData claimsFromUserEndpoint;
        StructuredData accessTokenData = OidcAndOAuthCommonHelpers.exchangeCodeWithIdp(config, code, tracker, baseUrl, OAuth2SpecificHelpers.getFullPathToOAuth2Servlet(baseUrl));
        if (accessTokenData.isEmpty()) {
            return new OAuthFlowResult("No access token present");
        }
        tracker.setSamlStatus(SAMLAuthenticationTracker.SamlStatus.RECEIVED_RESPONSE);
        String accessToken = (String)accessTokenData.asStringMap().get("access_token");
        if (accessToken == null || accessToken.trim().isEmpty()) {
            return new OAuthFlowResult("No access token present");
        }
        accessToken = accessToken.trim();
        tracker.add(logger, SAMLAuthenticationTracker.Level.DEBUG, "Extracted access token successfully", new Object[0]);
        if (logger.isDebugEnabled()) {
            logger.debug("Got an access token: {}", (Object)accessToken);
        }
        if ((claimsFromUserEndpoint = OidcAndOAuthCommonHelpers.getInformationFromUserInfoEndpoints(accessToken, config, tracker)).isEmpty()) {
            return new OAuthFlowResult("Could not get claims form user info endpoint");
        }
        return new OAuthFlowResult(claimsFromUserEndpoint);
    }
}

