/*
 * Decompiled with CFR 0.152.
 */
package com.resolution.atlasplugins.samlsso.oidcandoauth;

import com.resolution.atlasplugins.samlsso.configuration.ConfigurationData;
import com.resolution.atlasplugins.samlsso.configuration.oauth.OAuth2IdpConfigurationData;
import com.resolution.atlasplugins.samlsso.configuration.oauth.OAuth2RunningIdpConfiguration;
import com.resolution.atlasplugins.samlsso.oidcandoauth.oauth2.CodeVerifier;
import com.resolution.atlasplugins.samlsso.oidcandoauth.oauth2.PkceType;
import com.resolution.atlasplugins.samlsso.oidcandoauth.oidc.OAuthFlow;
import com.resolution.atlasplugins.samlsso.tracker.AuthenticationTracker;
import com.resolution.samlwrapper.api.tracker.SAMLAuthenticationTracker;
import de.resolution.commons.data.MapStructuredData;
import de.resolution.commons.data.StructuredData;
import de.resolution.commons.net.HTTPWrapper;
import de.resolution.commons.net.ResponseWrapper;
import de.resolution.commons.util.Elvis;
import de.resolution.commons.util.StringUtil;
import de.resolution.commons.util.UrlUtil;
import de.resolution.commons.validate.api.ValidationResult;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import java.util.HashMap;
import okhttp3.HttpUrl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OidcAndOAuthCommonHelpers {
    private static final HTTPWrapper httpWrapper = new HTTPWrapper();
    private static final Logger logger = LoggerFactory.getLogger(OidcAndOAuthCommonHelpers.class);
    public static final String GENERAL_ERROR_WITHOUT_TRACKER = "Cannot process with login, please ask your administrator to check the logs";
    public static final String GENERAL_ERROR_WITH_TRACKER = "Cannot process with login, please ask your administrator to check with the given authentication tracker id (from above) and/or see the logs";
    private static MessageDigest messageDigest;

    private OidcAndOAuthCommonHelpers() {
    }

    @Nonnull
    public static StructuredData getInformationFromUserInfoEndpoints(@Nullable String accessToken, @Nonnull OAuth2RunningIdpConfiguration config, @Nonnull AuthenticationTracker tracker) {
        if (accessToken == null) {
            logger.error("Access Token is null");
            return StructuredData.create();
        }
        MapStructuredData result = StructuredData.create();
        HashMap<String, Object> headers = new HashMap<String, Object>();
        config.getUserInfoEndpointRequestHeaders().forEach(kv -> headers.put(kv.getKey(), kv.getValue()));
        headers.put("Authorization", config.getAuthScheme() + " " + accessToken);
        headers.put("Accept", "application/json");
        for (String endpoint : config.getUserInfoEndpoints()) {
            tracker.add(logger, SAMLAuthenticationTracker.Level.INFO, "Request to {}", new Object[]{endpoint});
            HttpUrl tmpUrl = HttpUrl.parse((String)endpoint);
            if (tmpUrl == null) {
                tracker.add(logger, SAMLAuthenticationTracker.Level.ERROR, "Could not parse endpoint url.", new Object[0]);
                continue;
            }
            HttpUrl.Builder urlBuilder = tmpUrl.newBuilder();
            config.getAdditionalUserInfoEndpointRequestParameters().forEach(keyValue -> urlBuilder.addQueryParameter(keyValue.getKey(), keyValue.getValue()));
            ResponseWrapper resp = httpWrapper.get(urlBuilder.build(), headers);
            if (resp.isSuccess()) {
                StructuredData tmpRes = resp.getBodyAsStructuredData();
                if (tmpRes.isEmpty()) {
                    tracker.add(logger, SAMLAuthenticationTracker.Level.ERROR, "Did not get response despite a success", new Object[0]);
                    continue;
                }
                if (tmpRes.isList()) {
                    result.put((Object)endpoint, (Object)tmpRes);
                    continue;
                }
                result = tmpRes.mergeInto((StructuredData)result);
                continue;
            }
            tracker.add(logger, SAMLAuthenticationTracker.Level.ERROR, "Got an error during fetching. Error Code={}", new Object[]{resp.getCode()});
            tracker.add(logger, SAMLAuthenticationTracker.Level.ERROR, "Exception is {}", new Object[]{resp.getException()});
        }
        return result;
    }

    @Nonnull
    public static StructuredData exchangeCodeWithIdp(@Nonnull OAuth2RunningIdpConfiguration config, @Nonnull String code, @Nonnull AuthenticationTracker tracker, @Nonnull String baseUrl, @Nonnull String redirectUri) {
        HttpUrl url = HttpUrl.parse((String)config.getTokenEndpoint());
        if (url == null) {
            tracker.add(logger, SAMLAuthenticationTracker.Level.ERROR, "Could not parse url to get access/id token", new Object[0]);
            return StructuredData.create();
        }
        HashMap<String, String> formFields = new HashMap<String, String>();
        formFields.put("client_id", config.getClientId());
        formFields.put("client_secret", config.getClientSecret());
        formFields.put("grant_type", "authorization_code");
        formFields.put("redirect_uri", redirectUri);
        formFields.put("code", code);
        config.getAdditionalTokenEndpointRequestParameters().forEach(kv -> formFields.put(kv.getKey(), kv.getValue()));
        if (config.usePkce()) {
            formFields.put("code_verifier", tracker.getCodeVerifier());
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        config.getTokenEndpointRequestHeaders().forEach(keyValue -> headers.put(keyValue.getKey(), keyValue.getValue()));
        headers.put("Accept", "application/json");
        ResponseWrapper response = httpWrapper.postAsForm(url.toString(), formFields, headers);
        if (!response.isSuccess()) {
            tracker.add(logger, SAMLAuthenticationTracker.Level.ERROR, "Could not trade code for id/access token because: {}\n{}\n{}", new Object[]{response.getCode(), response.getBody(), response.getMessage()});
            return StructuredData.create();
        }
        return (StructuredData)Elvis.ifNull((Object)response.getBodyAsStructuredData(), (Object)StructuredData.create());
    }

    @Nullable
    private static String generateSHA256PkceCodeChallenge(@Nonnull String codeVerifier) {
        if (messageDigest == null) {
            logger.error("Do not have access to SHA-256");
            return null;
        }
        byte[] bytes = codeVerifier.getBytes(StandardCharsets.US_ASCII);
        messageDigest.update(bytes, 0, bytes.length);
        byte[] digest = messageDigest.digest();
        return Base64.getUrlEncoder().withoutPadding().encodeToString(digest);
    }

    public static void addPkceToRequest(@Nonnull HttpUrl.Builder urlBuilder, @Nonnull OAuth2RunningIdpConfiguration oauthConfig, @Nonnull AuthenticationTracker tracker) {
        String codeVerifier = CodeVerifier.create();
        tracker.setCodeVerifier(codeVerifier);
        if (oauthConfig.getPkceMethod() == PkceType.S256) {
            String pkceValue = OidcAndOAuthCommonHelpers.generateSHA256PkceCodeChallenge(codeVerifier);
            if (pkceValue == null) {
                tracker.add(logger, SAMLAuthenticationTracker.Level.ERROR, "Config-wise, SHA-256 should be used to generate the code challenge. However, we cannot get the SHA-256 instance on your system", new Object[0]);
                return;
            }
            urlBuilder.addQueryParameter("code_challenge", pkceValue);
            urlBuilder.addQueryParameter("code_challenge_method", "S256");
        } else if (oauthConfig.getPkceMethod() == PkceType.PLAIN) {
            urlBuilder.addQueryParameter("code_challenge", codeVerifier);
            urlBuilder.addQueryParameter("code_challenge_method", "plain");
        }
    }

    public static void validateOAuth2Basics(@Nonnull OAuth2IdpConfigurationData oauthConfig, @Nonnull ConfigurationData configurationData, @Nonnull ValidationResult result) {
        if (StringUtil.isNullOrEmpty((String)oauthConfig.clientId)) {
            result.add("clientId", "ClientId must not be empty");
        }
        if (StringUtil.isNullOrEmpty((String)oauthConfig.clientSecret)) {
            result.add("clientSecret", "ClientSecret must not be empty");
        }
        if (StringUtil.isNullOrEmpty((String)oauthConfig.authEndpoint)) {
            result.add("authEndpoint", "AuthEndpoint must not be empty");
        }
        if (StringUtil.isNullOrEmpty((String)oauthConfig.tokenEndpoint)) {
            result.add("tokenEndpoint", "TokenEndpoint must not be empty");
        }
        if (oauthConfig.oAuthFlow == null) {
            result.add("oAuthFlow", "You must choose an OAuth2 flow");
        } else if (oauthConfig.oAuthFlow != OAuthFlow.AUTHN_CODE) {
            result.add("oAuthFlow", "This app currently only supports the auth code flow");
        }
        if (oauthConfig.doSingleLogout) {
            if (StringUtil.isNullOrEmpty((String)oauthConfig.endSessionEndpoint)) {
                result.add("endSessionEndpoint", "When single logout is active, you must add an url here");
            } else if (!UrlUtil.isValid((String)oauthConfig.endSessionEndpoint)) {
                result.add("endSessionEndpoint", "Enter a valid url");
            }
        }
    }

    public static ValidationResult validateUserInfoEndpoints(OAuth2IdpConfigurationData oauthConfig) {
        ValidationResult userInfoEndpointsResult = ValidationResult.create();
        for (int i = 0; i < oauthConfig.userInfoEndpoints.size(); ++i) {
            String userInfoEndpoint = oauthConfig.userInfoEndpoints.get(i);
            if (userInfoEndpoint != null && !userInfoEndpoint.isEmpty()) continue;
            userInfoEndpointsResult.add(i, "You must enter something", null);
        }
        return userInfoEndpointsResult;
    }

    @Nullable
    public static String getSubClaimOrNull(StructuredData userClaims) {
        if (userClaims == null) {
            return null;
        }
        if (userClaims.isEmpty()) {
            return null;
        }
        try {
            StructuredData sub = userClaims.asMap().get((Object)"sub");
            if (sub == null) {
                return null;
            }
            if (sub.isString()) {
                return sub.asString();
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    static {
        try {
            messageDigest = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            messageDigest = null;
        }
    }
}

