/*
 * Decompiled with CFR 0.152.
 */
package com.resolution.atlasplugins.samlsso.oidcandoauth;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.resolution.atlasplugins.samlsso.ResourceLoader;
import com.resolution.atlasplugins.samlsso.Utils;
import com.resolution.atlasplugins.samlsso.configuration.frontend.SamlSsoConfigurationService;
import com.resolution.atlasplugins.samlsso.servlet.ErrorResponse;
import de.resolution.atlasuser.api.exception.DirectoryNameExistsAlreadyException;
import de.resolution.atlasuser.api.exception.InvalidOperationException;
import de.resolution.commons.util.JSONUtil;
import de.resolution.commons.util.StringUtil;
import de.resolution.reconfigure.InsufficientUserPrivilegeException;
import de.resolution.reconfigure.PrivilegeChecker;
import de.resolution.retransform.config.AttributeTransformationConfig;
import de.resolution.usersync.api.ConnectorService;
import de.resolution.usersync.builtin.jit.JitConnector;
import de.resolution.usersync.builtin.jit.JitConnectorConfiguration;
import de.resolution.usersync.builtin.jit.JitConnectorConfigurationImpl;
import de.resolution.usersync.external.api.exception.ConfigurationFailedException;
import de.resolution.usersync.external.api.exception.ConnectorFactoryNotAvailableException;
import de.resolution.usersync.external.api.exception.ConnectorNotFoundException;
import de.resolution.usersync.spi.Connector;
import jakarta.annotation.Nonnull;
import jakarta.inject.Inject;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Component;

@Path(value="/managejit")
@Component
public class ManageJitRestResource {
    private static final String IDP_TYPE = "idpType";
    private static final String IDP_NAME = "idpName";
    public static final String PROTOCOL_TYPE = "protocolType";
    private final SamlSsoConfigurationService samlSsoConfigurationService;
    private final PrivilegeChecker privilegeChecker;
    private final ConnectorService connectorService;

    @Inject
    public ManageJitRestResource(ConnectorService connectorService, PrivilegeChecker privilegeChecker, SamlSsoConfigurationService samlSsoConfigurationService) {
        this.privilegeChecker = privilegeChecker;
        this.connectorService = connectorService;
        this.samlSsoConfigurationService = samlSsoConfigurationService;
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response createJitConnector(String jsonStr, @Context HttpServletRequest request) throws InsufficientUserPrivilegeException, DirectoryNameExistsAlreadyException, InvalidOperationException, JsonProcessingException {
        this.privilegeChecker.checkSysAdmin(request);
        Map postBody = JSONUtil.deserializeMap((String)jsonStr, String.class, String.class);
        if (postBody.isEmpty()) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)Utils.asJson(new ErrorResponse("No body in request to backend"))).cacheControl(Utils.ccNoCache).build();
        }
        if (!postBody.containsKey(IDP_TYPE) || StringUtil.isNullOrEmpty((String)((String)postBody.get(IDP_TYPE)))) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)Utils.asJson(new ErrorResponse("No idpType in request to backend"))).cacheControl(Utils.ccNoCache).build();
        }
        if (!postBody.containsKey(IDP_NAME) || StringUtil.isNullOrEmpty((String)((String)postBody.get(IDP_NAME)))) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)Utils.asJson(new ErrorResponse("No idpType in request to backend"))).cacheControl(Utils.ccNoCache).build();
        }
        if (!postBody.containsKey(PROTOCOL_TYPE) || StringUtil.isNullOrEmpty((String)((String)postBody.get(PROTOCOL_TYPE)))) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)Utils.asJson(new ErrorResponse("No protocolType in request to backend"))).cacheControl(Utils.ccNoCache).build();
        }
        String protocolType = ((String)postBody.get(PROTOCOL_TYPE)).trim();
        String idpType = ((String)postBody.get(IDP_TYPE)).trim();
        String idpName = ((String)postBody.get(IDP_NAME)).trim();
        List<AttributeTransformationConfig> presetToUse = this.loadPreset(protocolType, idpType);
        if (presetToUse.isEmpty()) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)Utils.asJson(new ErrorResponse("Could not load preset"))).cacheControl(Utils.ccNoCache).build();
        }
        Connector<JitConnectorConfiguration> res = null;
        try {
            res = this.connectorService.create(JitConnector.class);
        }
        catch (ConfigurationFailedException | ConnectorFactoryNotAvailableException e) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)Utils.asJson(new ErrorResponse("Cannot create connector " + e.getMessage()))).cacheControl(Utils.ccNoCache).build();
        }
        JitConnectorConfigurationImpl config = this.configureConnector(res, idpName, idpType, presetToUse);
        try {
            this.connectorService.configure(res.getUniqueId(), config);
        }
        catch (ConfigurationFailedException | ConnectorFactoryNotAvailableException | ConnectorNotFoundException e) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)Utils.asJson(new ErrorResponse("Something went wrong when configuring the connector " + e.getMessage()))).cacheControl(Utils.ccNoCache).build();
        }
        HashMap<String, Object> resp = new HashMap<String, Object>();
        resp.put("uniqueId", res.getUniqueId());
        resp.put("newConnectors", this.samlSsoConfigurationService.createConnectorList());
        return Response.ok().entity((Object)Utils.asJson(resp)).cacheControl(Utils.ccNoCache).build();
    }

    @Nonnull
    private JitConnectorConfigurationImpl configureConnector(@Nonnull Connector<JitConnectorConfiguration> toConfigure, @Nonnull String idpName, @Nonnull String idpType, @Nonnull List<AttributeTransformationConfig> presetToUse) throws InvalidOperationException, DirectoryNameExistsAlreadyException {
        JitConnectorConfigurationImpl config = (JitConnectorConfigurationImpl)toConfigure.getConfiguration();
        String connectorName = this.connectorService.makeDirectoryNameUnique("Jit for " + idpName + " (" + idpType + ")");
        config.setName(connectorName);
        long dirId = this.connectorService.createDirectory(connectorName, "");
        config.setDirectoryId(dirId);
        config.setAttributeTransformationConfigs(presetToUse);
        config.setFindByAttributeName("auth_attribute");
        return config;
    }

    @Nonnull
    private List<AttributeTransformationConfig> loadPreset(@Nonnull String protocolType, @Nonnull String idpType) {
        String path = "data/jitConnectors/" + protocolType + "/" + idpType + ".json";
        if (!ResourceLoader.exists(path)) {
            return Collections.emptyList();
        }
        return JSONUtil.deserializeList((String)ResourceLoader.load(path), AttributeTransformationConfig.class);
    }
}

