/*
 * Decompiled with CFR 0.152.
 */
package com.resolution.atlasplugins.samlsso.jira.userauth;

import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.UserWithAttributes;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.preferences.ExtendedPreferences;
import com.atlassian.jira.user.preferences.UserPreferencesManager;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.plugin.spring.scanner.annotation.component.JiraComponent;
import com.atlassian.plugin.spring.scanner.annotation.imports.JiraImport;
import com.resolution.atlasplugins.samlsso.userauth.AbstractSamlUserMigrator;
import de.resolution.atlasuser.api.user.AtlasUserAdapter;
import jakarta.annotation.Nonnull;
import jakarta.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JiraComponent
public class JiraSamlUserMigrator
extends AbstractSamlUserMigrator {
    private static final Logger logger = LoggerFactory.getLogger(JiraSamlUserMigrator.class);
    private final UserPreferencesManager userPreferencesManager;
    private final CrowdService crowdService;
    private final UserManager userManager;

    @Inject
    public JiraSamlUserMigrator(AtlasUserAdapter atlasUserAdapter, @JiraImport UserPreferencesManager userPreferencesManager, @JiraImport CrowdService crowdService, @JiraImport(value="jiraUserManager") UserManager userManager) {
        super(atlasUserAdapter);
        this.userPreferencesManager = userPreferencesManager;
        this.crowdService = crowdService;
        this.userManager = userManager;
    }

    @Override
    public boolean isLegacySamlUser(@Nonnull String userid) {
        String SAML_JIRA_LEGACY_ATTRIBUTE = "createdFromSAMLSingleSignOn";
        ApplicationUser appUser = this.userManager.getUserByName(userid);
        ExtendedPreferences pref = this.userPreferencesManager.getExtendedPreferences(appUser);
        boolean hasSAMLPref = pref.getBoolean("createdFromSAMLSingleSignOn");
        if (hasSAMLPref) {
            return true;
        }
        UserWithAttributes userWithAttributes = null;
        if (appUser != null) {
            userWithAttributes = this.crowdService.getUserWithAttributes(appUser.getUsername());
        }
        if (userWithAttributes == null) {
            logger.warn("CrowdService returned no user for userid {}, just returning false", (Object)userid);
            return false;
        }
        return userWithAttributes.getValue("createdFromSAMLSingleSignOn") != null;
    }
}

