/*
 * Decompiled with CFR 0.152.
 */
package com.resolution.atlasplugins.samlsso.jira.servlet;

import com.atlassian.templaterenderer.TemplateRenderer;
import com.resolution.atlasplugins.samlsso.SamlSsoService;
import com.resolution.atlasplugins.samlsso.servlet.BasicServlet;
import jakarta.annotation.Nonnull;
import jakarta.inject.Inject;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;

public class RedirectToDashboardServlet
extends BasicServlet {
    private final String secureDashboardPath;
    private final String defaultDashboardPath;

    @Inject
    public RedirectToDashboardServlet(SamlSsoService samlSsoService, TemplateRenderer renderer) {
        super(samlSsoService, renderer);
        String relativeBaseUrl = samlSsoService.getRelativeBaseUrl();
        this.secureDashboardPath = relativeBaseUrl + "/secure/Dashboard.jspa";
        this.defaultDashboardPath = relativeBaseUrl + "/default.jsp";
    }

    @Override
    public void processRequest(@Nonnull HttpServletRequest req, @Nonnull HttpServletResponse resp) throws ServletException, IOException {
        String pageId = req.getParameter("selectPageId");
        String redirectUrl = this.buildRedirectUrl(pageId);
        resp.setHeader("cache-control", "no-cache, no-store, must-revalidate");
        resp.sendRedirect(redirectUrl);
    }

    private String buildRedirectUrl(String pageId) {
        if (pageId == null) {
            return this.secureDashboardPath;
        }
        try {
            int parsedPageId = Integer.parseInt(pageId);
            return this.secureDashboardPath + "?selectPageId=" + parsedPageId;
        }
        catch (NumberFormatException ex) {
            return this.defaultDashboardPath;
        }
    }
}

