/*
 * Decompiled with CFR 0.152.
 */
package com.resolution.atlasplugins.samlsso.jira;

import com.atlassian.annotations.security.UnrestrictedAccess;
import com.atlassian.plugin.spring.scanner.annotation.component.JiraComponent;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.resolution.atlasplugins.samlsso.SamlSsoService;
import com.resolution.atlasplugins.samlsso.SingleLogoutService;
import com.resolution.atlasplugins.samlsso.SingleLogoutServiceException;
import com.resolution.atlasplugins.samlsso.configuration.RunningConfiguration;
import com.resolution.atlasplugins.samlsso.jira.servlet.RedirectServiceDeskUtil;
import com.resolution.atlasplugins.samlsso.jira.userauth.JiraServiceDeskLogoutHandler;
import com.resolution.atlasplugins.samlsso.servlet.ServletUtil;
import com.resolution.atlasplugins.samlsso.tracker.AuthenticationTracker;
import com.resolution.atlasplugins.samlsso.tracker.AuthenticationTrackerRepository;
import de.resolution.commons.license.LicenseChecker;
import de.resolution.commons.license.LicenseStatus;
import de.resolution.commons.util.StringUtil;
import de.resolution.commons.util.boundedregex.BoundedRegex;
import de.resolution.commons.util.boundedregex.TimeoutExceededException;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.inject.Inject;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JiraComponent
@UnrestrictedAccess
public class RedirectServiceDeskLoginToSsoFilter
implements Filter {
    private static final Logger logger = LoggerFactory.getLogger(RedirectServiceDeskLoginToSsoFilter.class);
    private static final String ALREADY_FILTERED = RedirectServiceDeskLoginToSsoFilter.class.getName() + "_already_filtered";
    private static final String SERVICE_DESK_PREFIX = "/servicedesk/customer/";
    private static final String DESTINATION = "destination";
    private static final String UTF_8 = "UTF-8";
    private static final String LOGOUT = "logout";
    private final SamlSsoService samlSsoService;
    private final RunningConfiguration pluginConfiguration;
    private final LicenseChecker licenseChecker;
    private final SingleLogoutService singleLogoutService;
    private final JiraServiceDeskLogoutHandler logoutHandler;
    private final AuthenticationTrackerRepository trackerRepository;
    private final TemplateRenderer templateRenderer;
    private final RedirectServiceDeskUtil redirectServicedeskUtil;
    private static final Pattern PORTAL_PATTERN = Pattern.compile("/servicedesk/customer/portal/(\\d+)/user/login");

    @Inject
    public RedirectServiceDeskLoginToSsoFilter(RedirectServiceDeskUtil redirectServicedeskUtil, SamlSsoService samlSsoService, LicenseChecker licenseChecker, RunningConfiguration pluginConfiguration, SingleLogoutService singleLogoutService, AuthenticationTrackerRepository trackerRepository, @ComponentImport TemplateRenderer templateRenderer) {
        this.redirectServicedeskUtil = redirectServicedeskUtil;
        this.samlSsoService = samlSsoService;
        this.licenseChecker = licenseChecker;
        this.pluginConfiguration = pluginConfiguration;
        this.singleLogoutService = singleLogoutService;
        this.trackerRepository = trackerRepository;
        this.templateRenderer = templateRenderer;
        this.logoutHandler = new JiraServiceDeskLogoutHandler(samlSsoService, pluginConfiguration);
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        if (req.getAttribute(ALREADY_FILTERED) != null) {
            chain.doFilter(req, res);
            return;
        }
        req.setAttribute(ALREADY_FILTERED, (Object)"yes");
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)res;
        if (this.checkNoSSO(request, response, chain)) {
            return;
        }
        if (this.checkReferrer(request, response, chain)) {
            return;
        }
        if (this.checkUserAgent(request, response, chain)) {
            return;
        }
        if (this.checkDestinationParameter(request, response, chain)) {
            return;
        }
        if (this.checkLoggedInUser(request, response, chain)) {
            return;
        }
        if (this.checkLicense(request, response, chain)) {
            return;
        }
        if (this.checkLogout(request, response, chain)) {
            return;
        }
        if (this.redirectServicedeskUtil.shouldRedirect(RedirectServiceDeskLoginToSsoFilter.readPortalFromURI(request.getRequestURI()))) {
            this.redirectToSsoServlet(request, response);
        } else {
            chain.doFilter(req, res);
        }
    }

    private boolean checkNoSSO(@Nonnull HttpServletRequest request, @Nonnull HttpServletResponse response, @Nonnull FilterChain chain) throws ServletException, IOException {
        if ((request.getParameter("nosso") != null || request.getParameter("auth_fallback") != null) && this.pluginConfiguration.isNossoEnabled()) {
            logger.debug("found parameter nosso or auth_fallback in request, not redirecting");
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
            return true;
        }
        String destination = request.getParameter(DESTINATION);
        if (destination != null && destination.contains("nosso") && this.pluginConfiguration.isNossoEnabled()) {
            logger.debug("found nosso in destination parameter, not redirecting");
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
            return true;
        }
        logger.debug("nosso is not present");
        return false;
    }

    private boolean checkReferrer(@Nonnull HttpServletRequest request, @Nonnull HttpServletResponse response, @Nonnull FilterChain chain) throws ServletException, IOException {
        String referer = request.getHeader("referer");
        String loginUrlRegex = ".*/servicedesk/customer/.*/login.*";
        try {
            if (referer != null && BoundedRegex.matches((String)loginUrlRegex, (String)referer, (long)this.samlSsoService.getRegexTimeout())) {
                logger.debug("Referer {} matches {}, not redirecting", (Object)referer, (Object)loginUrlRegex);
                chain.doFilter((ServletRequest)request, (ServletResponse)response);
                return true;
            }
            return false;
        }
        catch (TimeoutExceededException e) {
            ServletUtil.sendErrorHelper(response, null, null, this.samlSsoService.getRelativeNossoLoginPageUrl(), this.samlSsoService.getRelativeInitiateSSOUrl(), e, this.pluginConfiguration.getErrorPageTemplate(), this.templateRenderer);
            return true;
        }
    }

    private boolean checkUserAgent(@Nonnull HttpServletRequest request, @Nonnull HttpServletResponse response, @Nonnull FilterChain chain) throws ServletException, IOException {
        String userAgentHeader = request.getHeader("user-agent");
        for (String nonSsoUserAgent : this.pluginConfiguration.getNonSsoUserAgents()) {
            if (userAgentHeader == null || !userAgentHeader.contains(nonSsoUserAgent)) continue;
            logger.trace("Not redirecting, this is a non-sso user agent: {}", (Object)userAgentHeader);
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
            return true;
        }
        return false;
    }

    private boolean checkDestinationParameter(@Nonnull HttpServletRequest request, @Nonnull HttpServletResponse response, @Nonnull FilterChain chain) throws ServletException, IOException {
        String destination = request.getParameter(DESTINATION);
        if (destination != null && !destination.isEmpty()) {
            for (String nonSsoDestination : this.pluginConfiguration.getNonSsoDestinations()) {
                if (!nonSsoDestination.contains(SERVICE_DESK_PREFIX)) continue;
                String nonSsoDestinationWithoutPrefix = nonSsoDestination.replace(SERVICE_DESK_PREFIX, "");
                try {
                    if (!BoundedRegex.matches((String)nonSsoDestinationWithoutPrefix, (String)destination, (long)this.samlSsoService.getRegexTimeout())) continue;
                    if (logger.isDebugEnabled()) {
                        logger.debug("Not redirecting, this is a non-sso link url for Service Desk Portal: {}", (Object)StringUtil.sanitize((String)destination));
                    }
                    chain.doFilter((ServletRequest)request, (ServletResponse)response);
                    return true;
                }
                catch (TimeoutExceededException e) {
                    ServletUtil.sendErrorHelper(response, null, null, this.samlSsoService.getRelativeNossoLoginPageUrl(), this.samlSsoService.getRelativeInitiateSSOUrl(), e, this.pluginConfiguration.getErrorPageTemplate(), this.templateRenderer);
                }
            }
        }
        return false;
    }

    private boolean checkLoggedInUser(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws ServletException, IOException {
        if (this.samlSsoService.isLoggedInUser(request)) {
            logger.debug("There is already a user logged in, nothing to do");
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
            return true;
        }
        return false;
    }

    private boolean checkLicense(@Nonnull HttpServletRequest request, @Nonnull HttpServletResponse response, @Nonnull FilterChain chain) throws ServletException, IOException {
        LicenseStatus licenseCheck = this.licenseChecker.checkLicense();
        if (!licenseCheck.isLicensed()) {
            logger.error("Not redirecting, license is not valid: {}", (Object)licenseCheck.getMessage());
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
            return true;
        }
        return false;
    }

    private boolean checkLogout(@Nonnull HttpServletRequest req, @Nonnull HttpServletResponse res, @Nonnull FilterChain chain) throws IOException, ServletException {
        if (req.getParameter(LOGOUT) == null || !req.getParameter(LOGOUT).equals("true")) {
            return false;
        }
        Cookie[] cookies = req.getCookies();
        if (cookies == null) {
            logger.debug("logout parameter is present, but no cookies are set, assuming this is not a SAML logout, not redirecting");
            chain.doFilter((ServletRequest)req, (ServletResponse)res);
            return true;
        }
        Cookie sdCookie = null;
        String sdCookieValue = null;
        for (Cookie cookie : cookies) {
            if (cookie.getName().equals("JiraSDSamlssoLogin")) {
                sdCookie = cookie;
                sdCookieValue = sdCookie.getValue();
                continue;
            }
            if (!cookie.getName().equals("JiraSDSamlssoLoginV2")) continue;
            sdCookie = cookie;
            if (sdCookie.getValue() == null) break;
            sdCookieValue = URLDecoder.decode(sdCookie.getValue(), UTF_8);
            break;
        }
        if (sdCookie != null) {
            logger.debug("SDCOOKIE is present, assuming this is a SAML logout");
            if (sdCookieValue != null) {
                String[] splitted = sdCookieValue.split("###");
                if (splitted.length != 4) {
                    if (logger.isErrorEnabled()) {
                        logger.error("Splitted cookie value {} has unexpected length {}, not performing single logout", (Object)StringUtil.sanitize((String)sdCookieValue), (Object)splitted.length);
                    }
                } else {
                    String sessionIndex = splitted[0];
                    String nameId = splitted[1];
                    String idpId = splitted[2];
                    String trackerid = splitted[3];
                    AuthenticationTracker tracker = (AuthenticationTracker)this.trackerRepository.get(trackerid, true);
                    try {
                        this.singleLogoutService.doServiceManagementSingleLogout(req, res, this.logoutHandler, tracker, sessionIndex, nameId, idpId);
                        return true;
                    }
                    catch (SingleLogoutServiceException e) {
                        ServletUtil.sendErrorHelper(res, null, "Single Logout failed", this.samlSsoService.getRelativeNossoLoginPageUrl(), this.samlSsoService.getRelativeInitiateSSOUrl(), e, this.pluginConfiguration.getErrorPageTemplate(), this.templateRenderer);
                    }
                }
            } else {
                logger.error("Cookie value is null, not performing single logout");
            }
            Cookie clearCookieUnencoded = new Cookie("JiraSDSamlssoLogin", "");
            clearCookieUnencoded.setMaxAge(0);
            clearCookieUnencoded.setPath("/");
            clearCookieUnencoded.setHttpOnly(true);
            clearCookieUnencoded.setSecure(this.samlSsoService.isHttps());
            res.addCookie(clearCookieUnencoded);
            Cookie clearCookie = new Cookie("JiraSDSamlssoLoginV2", "");
            clearCookie.setMaxAge(0);
            clearCookie.setPath("/");
            clearCookie.setHttpOnly(true);
            clearCookie.setSecure(this.samlSsoService.isHttps());
            res.addCookie(clearCookie);
            String loginPageParam = URLEncoder.encode(this.samlSsoService.getRelativeBaseUrl() + req.getRequestURI() + "?nosso", UTF_8);
            res.setHeader("cache-control", "no-cache, no-store, must-revalidate");
            res.sendRedirect(this.samlSsoService.getRelativeLoggedOutPageUrl() + "?loginurl=" + loginPageParam);
            return true;
        }
        logger.debug("logout parameter is present, not redirecting");
        chain.doFilter((ServletRequest)req, (ServletResponse)res);
        return true;
    }

    private void redirectToSsoServlet(@Nonnull HttpServletRequest request, @Nonnull HttpServletResponse response) throws IOException {
        Object destination;
        boolean absolute;
        String destinationParameterValue = request.getParameter(DESTINATION);
        boolean bl = absolute = request.getParameter("absolute") != null && request.getParameter("absolute").equals("true");
        if (destinationParameterValue == null) {
            logger.debug("No destination given, using /servicedesk/customer/portal/1");
            destination = "/servicedesk/customer/portal/1";
        } else {
            destination = absolute ? (destinationParameterValue.startsWith("/") ? destinationParameterValue.replaceFirst("^" + this.samlSsoService.getRelativeBaseUrl(), "") : destinationParameterValue.replaceFirst("^" + this.samlSsoService.getAbsoluteBaseUrl(), "")) : (destinationParameterValue.startsWith("/") ? "/servicedesk/customer" + destinationParameterValue : SERVICE_DESK_PREFIX + destinationParameterValue);
        }
        String encodedDestination = destination;
        try {
            encodedDestination = URLEncoder.encode((String)destination, UTF_8);
            if (logger.isDebugEnabled()) {
                logger.debug("Encoding destination from {} to {}", (Object)StringUtil.sanitize((String)destination), (Object)StringUtil.sanitize((String)encodedDestination));
            }
        }
        catch (UnsupportedEncodingException e) {
            logger.error("URL encoding failed, proceeding with destination as it is.", (Throwable)e);
        }
        String redirectDestination = this.samlSsoService.getCanonicalBaseUrl() + "/plugins/servlet/samlsso?redirectTo=" + encodedDestination;
        response.setHeader("cache-control", "no-cache, no-store, must-revalidate");
        logger.debug("Redirecting to SSO: {}", (Object)redirectDestination);
        response.sendRedirect(redirectDestination);
    }

    public void init(FilterConfig config) {
    }

    public void destroy() {
    }

    @Nullable
    public static String readPortalFromURI(String requestURI) {
        Matcher matcher = PORTAL_PATTERN.matcher(requestURI);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        return null;
    }
}

