/*
 * Decompiled with CFR 0.152.
 */
package com.resolution.atlasplugins.samlsso.jira;

import com.atlassian.mail.Email;
import com.atlassian.mail.queue.MailQueue;
import com.atlassian.mail.queue.MailQueueItem;
import com.atlassian.mail.queue.SingleMailQueueItem;
import com.atlassian.plugin.spring.scanner.annotation.component.JiraComponent;
import com.atlassian.plugin.spring.scanner.annotation.imports.JiraImport;
import com.resolution.atlasplugins.samlsso.SendEmailService;
import com.resolution.atlasplugins.samlsso.configuration.RunningConfiguration;
import jakarta.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JiraComponent
public class JiraSendEmailServiceImpl
implements SendEmailService {
    private static final Logger logger = LoggerFactory.getLogger(JiraSendEmailServiceImpl.class);
    private final MailQueue mailQueue;
    private final RunningConfiguration pluginConfiguration;

    @Inject
    public JiraSendEmailServiceImpl(@JiraImport MailQueue mailQueue, RunningConfiguration pluginConfiguration) {
        this.mailQueue = mailQueue;
        this.pluginConfiguration = pluginConfiguration;
    }

    @Override
    public void sendEmail(String address, String subject, String body) {
        if (this.pluginConfiguration.getAllowedNotificationEmailAddresses().contains(address)) {
            Email email = new Email(address);
            email.setBody(body);
            email.setSubject(subject);
            SingleMailQueueItem mailQueueItem = new SingleMailQueueItem(email);
            this.mailQueue.addItem((MailQueueItem)mailQueueItem);
        } else {
            logger.warn("{} is not in the list of allowed addresses, not sending", (Object)address);
        }
    }
}

