/*
 * Decompiled with CFR 0.152.
 */
package com.resolution.atlasplugins.samlsso.jira;

import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.security.xsrf.DefaultXsrfInvocationChecker;
import com.atlassian.jira.security.xsrf.XsrfCheckResult;
import com.atlassian.plugin.spring.scanner.annotation.component.JiraComponent;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.JiraImport;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.component.ComponentLocator;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.resolution.atlasplugins.samlsso.AbstractSamlSsoService;
import com.resolution.atlasplugins.samlsso.JiraServiceDeskDetector;
import com.resolution.atlasplugins.samlsso.SamlSsoService;
import com.resolution.atlasplugins.samlsso.cleanup.CleanupJobScheduler;
import com.resolution.atlasplugins.samlsso.cluster.ClusterNotificator;
import com.resolution.atlasplugins.samlsso.configuration.RunningConfiguration;
import com.resolution.atlasplugins.samlsso.idpselection.IdpByRequestHeaderSelector;
import com.resolution.atlasplugins.samlsso.tracker.AuthenticationTrackerRepository;
import com.resolution.atlasplugins.samlsso.userauth.AuthenticatorHook;
import com.resolution.samlwrapper.api.ResponseIDStore;
import com.resolution.samlwrapper.api.SAMLWrapper;
import jakarta.annotation.Nonnull;
import jakarta.inject.Inject;
import jakarta.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;

@JiraComponent(value="samlSsoService")
@ExportAsService(value={SamlSsoService.class})
public class JiraSamlSsoService
extends AbstractSamlSsoService {
    private static final Logger logger = LoggerFactory.getLogger(JiraSamlSsoService.class);
    private final AuthenticatorHook authenticatorHook;
    private final JiraServiceDeskDetector jiraServiceDeskDetector;
    private final DefaultXsrfInvocationChecker xsrfInvocationChecker;
    private final String logoutConfirmPage;

    @Inject
    public JiraSamlSsoService(SAMLWrapper samlWrapper, @Qualifier(value="pluginConfiguration") RunningConfiguration pluginConfiguration, @JiraImport ApplicationProperties applicationProperties, AuthenticatorHook authenticatorHook, @Qualifier(value="clusterNotificator") ClusterNotificator clusterNotificator, JiraServiceDeskDetector jiraServiceDeskDetector, @JiraImport TemplateRenderer templateRenderer, ResponseIDStore responseIdStore, AuthenticationTrackerRepository authenticationTrackerRepository, IdpByRequestHeaderSelector idpByRequestHeaderSelector, @JiraImport GlobalPermissionManager globalPermissionManager, @JiraImport PermissionManager permissionManager, CleanupJobScheduler cleanupJobScheduler) {
        super(samlWrapper, pluginConfiguration, applicationProperties, clusterNotificator, templateRenderer, responseIdStore, authenticationTrackerRepository, idpByRequestHeaderSelector, cleanupJobScheduler);
        this.authenticatorHook = authenticatorHook;
        String jiraVersionString = applicationProperties.getVersion();
        logger.debug("Jira Version is {}", (Object)jiraVersionString);
        this.jiraServiceDeskDetector = jiraServiceDeskDetector;
        this.xsrfInvocationChecker = (DefaultXsrfInvocationChecker)ComponentLocator.getComponent(DefaultXsrfInvocationChecker.class);
        this.logoutConfirmPage = "/logoutconfirm.jsp";
    }

    @Override
    public boolean isLoggedInUser(@Nonnull HttpServletRequest httpServletRequest) {
        return this.authenticatorHook.isLoggedInUser(httpServletRequest);
    }

    @Override
    public String getRelativeNossoLoginPageUrl() {
        return this.getRelativeBaseUrl() + this.getRelativeDefaultLoginPageUrl() + "?nosso";
    }

    @Override
    protected String getRelativeDefaultLoginPageUrl() {
        return "/login.jsp";
    }

    @Override
    public boolean isJira() {
        return true;
    }

    @Override
    public boolean isJiraServiceDesk() {
        return this.jiraServiceDeskDetector.isJiraServiceDesk();
    }

    @Override
    public String getRelativeRedirectUrlForLogout(@Nonnull HttpServletRequest request) {
        String servletPath = request.getServletPath();
        if (servletPath.contains("/secure/Logout!default.jspa") || servletPath.equals("/logout") || servletPath.equals("/secure/Logout.jspa")) {
            String atlToken = request.getParameter("atl_token");
            if (atlToken == null) {
                logger.debug("atl_token was null, redirecting to logoutconfirm.jsp");
                return this.getRelativeBaseUrl() + this.logoutConfirmPage;
            }
            if (this.xsrfInvocationChecker == null) {
                logger.error("XsrfInvocationChecker was null, that should not happen. Falling back to ask for confirmation for logout");
                return this.getRelativeBaseUrl() + this.logoutConfirmPage;
            }
            XsrfCheckResult ret = this.xsrfInvocationChecker.checkWebRequestInvocation(request);
            if (ret.isValid()) {
                logger.debug("atl_token was valid, redirecting to logout");
                return this.getRelativeBaseUrl() + "/plugins/servlet/samlsso/logout";
            }
            logger.debug("atl_token was NOT valid, redirecting to /logoutconfirm.jsp");
            return this.getRelativeBaseUrl() + this.logoutConfirmPage;
        }
        return null;
    }

    @Override
    @Nonnull
    public String getLogoutUrl() {
        return this.getRelativeBaseUrl() + "/logout?atl_token=#TOKEN#";
    }
}

