/*
 * Decompiled with CFR 0.152.
 */
package com.resolution.atlasplugins.samlsso.jira;

import com.atlassian.application.api.ApplicationKey;
import com.atlassian.jira.application.ApplicationKeys;
import com.atlassian.jira.bc.license.JiraLicenseService;
import com.atlassian.jira.license.LicenseDetails;
import com.atlassian.plugin.spring.scanner.annotation.component.JiraComponent;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.JiraImport;
import com.resolution.atlasplugins.samlsso.JiraServiceDeskDetector;
import jakarta.inject.Inject;

@JiraComponent
@ExportAsService
public class JiraJiraServiceDeskDetector
implements JiraServiceDeskDetector {
    private final JiraLicenseService licenseService;

    @Inject
    public JiraJiraServiceDeskDetector(@JiraImport JiraLicenseService licenseService) {
        this.licenseService = licenseService;
    }

    @Override
    public boolean isJiraServiceDesk() {
        for (LicenseDetails licenseDetails : this.licenseService.getLicenses()) {
            for (ApplicationKey appKey : licenseDetails.getLicensedApplications().getKeys()) {
                if (!appKey.equals((Object)ApplicationKeys.SERVICE_DESK)) continue;
                return true;
            }
        }
        return false;
    }
}

