/*
 * Decompiled with CFR 0.152.
 */
package com.resolution.atlasplugins.samlsso.idpselection;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.resolution.atlasplugins.samlsso.Utils;
import com.resolution.atlasplugins.samlsso.configuration.RunningConfiguration;
import com.resolution.atlasplugins.samlsso.idpselection.EmailTestData;
import com.resolution.atlasplugins.samlsso.idpselection.HeaderTestData;
import com.resolution.atlasplugins.samlsso.idpselection.IdpByEmailDomainSelector;
import com.resolution.atlasplugins.samlsso.idpselection.IdpByRequestHeaderSelector;
import com.resolution.atlasplugins.samlsso.idpselection.TestResult;
import com.resolution.atlasplugins.samlsso.tracker.AuthenticationTracker;
import de.resolution.reconfigure.InsufficientUserPrivilegeException;
import de.resolution.reconfigure.PrivilegeChecker;
import jakarta.inject.Inject;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.util.Collections;
import org.springframework.stereotype.Component;

@Path(value="/testidpselection")
@Component
public class IdpSelectionTestResource {
    private final IdpByRequestHeaderSelector idpByRequestHeaderSelector;
    private final IdpByEmailDomainSelector idpByEmailDomainSelector;
    private final RunningConfiguration pluginConfiguration;
    private final PrivilegeChecker privilegeChecker;
    private final ObjectMapper objectMapper = new ObjectMapper();

    @Inject
    public IdpSelectionTestResource(IdpByRequestHeaderSelector idpByRequestHeaderSelector, IdpByEmailDomainSelector idpByEmailDomainSelector, RunningConfiguration pluginConfiguration, PrivilegeChecker privilegeChecker) {
        this.idpByRequestHeaderSelector = idpByRequestHeaderSelector;
        this.idpByEmailDomainSelector = idpByEmailDomainSelector;
        this.pluginConfiguration = pluginConfiguration;
        this.privilegeChecker = privilegeChecker;
    }

    @PUT
    @Path(value="/email")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response testEmailDomains(String testDataString, @Context HttpServletRequest request) throws InsufficientUserPrivilegeException, IOException {
        this.privilegeChecker.checkSysAdmin(request);
        EmailTestData testData = (EmailTestData)this.objectMapper.readValue(testDataString, EmailTestData.class);
        int result = this.idpByEmailDomainSelector.selectIdpByEmailDomain(testData.testValue, testData.lines, this.pluginConfiguration.getRegexTimeout());
        return Response.ok((Object)Utils.asJson(new TestResult(result, ""))).cacheControl(Utils.ccNoCache).build();
    }

    @PUT
    @Path(value="/header")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response testHeader(String testDataString, @Context HttpServletRequest request) throws InsufficientUserPrivilegeException, IOException {
        this.privilegeChecker.checkSysAdmin(request);
        HeaderTestData testData = (HeaderTestData)this.objectMapper.readValue(testDataString, HeaderTestData.class);
        if (testData.name != null) {
            testData.name = testData.name.toLowerCase();
        }
        int result = this.idpByRequestHeaderSelector.selectIdPbyRequestHeaderList(Collections.singletonMap(testData.name, testData.value), testData.lines, AuthenticationTracker.createDummy());
        return Response.ok((Object)Utils.asJson(new TestResult(result, ""))).cacheControl(Utils.ccNoCache).build();
    }
}

