/*
 * Decompiled with CFR 0.152.
 */
package com.resolution.atlasplugins.samlsso.idpselection;

import com.resolution.atlasplugins.samlsso.configuration.HeaderValueIdpId;
import com.resolution.atlasplugins.samlsso.configuration.RunningConfiguration;
import com.resolution.atlasplugins.samlsso.tracker.AuthenticationTracker;
import com.resolution.samlwrapper.api.tracker.SAMLAuthenticationTracker;
import de.resolution.commons.util.boundedregex.BoundedRegex;
import de.resolution.commons.util.boundedregex.TimeoutExceededException;
import jakarta.inject.Inject;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.PatternSyntaxException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class IdpByRequestHeaderSelector {
    private static final Logger logger = LoggerFactory.getLogger(IdpByRequestHeaderSelector.class);
    private final RunningConfiguration pluginConfiguration;

    @Inject
    public IdpByRequestHeaderSelector(RunningConfiguration pluginConfiguration) {
        this.pluginConfiguration = pluginConfiguration;
    }

    public int selectIdpByRequestHeader(HttpServletRequest req, AuthenticationTracker tracker) {
        HashMap<String, String> headers = new HashMap<String, String>();
        logger.trace("______ HEADERS ______");
        Enumeration names = req.getHeaderNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            String value = req.getHeader(name);
            headers.put(name, value);
            logger.trace("{} : {}", (Object)name, (Object)value);
        }
        logger.trace("____ END HEADERS ____");
        return this.selectIdPbyRequestHeaderMap(headers, tracker);
    }

    public int selectIdPbyRequestHeaderMap(Map<String, String> headers, AuthenticationTracker tracker) {
        return this.selectIdPbyRequestHeaderList(headers, this.pluginConfiguration.getRequestHeadersForIdpSelection(), tracker);
    }

    public int selectIdPbyRequestHeaderList(Map<String, String> headers, List<HeaderValueIdpId> headerValueIdpIds, AuthenticationTracker tracker) {
        for (HeaderValueIdpId current : headerValueIdpIds) {
            String currentRegex;
            String lowercasedHeaderName;
            if (current.name == null || current.name.trim().isEmpty() || !headers.containsKey(lowercasedHeaderName = current.name.toLowerCase())) continue;
            String headerValue = headers.get(lowercasedHeaderName);
            if (headerValue == null) {
                headerValue = "";
            }
            if ((currentRegex = current.value) == null) {
                currentRegex = "";
            }
            try {
                if (!BoundedRegex.matches((String)currentRegex, (String)headerValue, (long)this.pluginConfiguration.getRegexTimeout())) continue;
                tracker.add(logger, SAMLAuthenticationTracker.Level.DEBUG, "Value {} of header {} matches regex {}, returning idp {}", new Object[]{headerValue, lowercasedHeaderName, currentRegex, current.idpId});
                return current.idpId;
            }
            catch (TimeoutExceededException | PatternSyntaxException e) {
                tracker.add(logger, SAMLAuthenticationTracker.Level.WARNING, "{} could not be applied as a regex, skipping", new Object[]{currentRegex, e});
            }
        }
        return 0;
    }
}

