/*
 * Decompiled with CFR 0.152.
 */
package com.resolution.atlasplugins.samlsso.idpselection;

import com.resolution.atlasplugins.samlsso.configuration.EmailDomainIdpId;
import com.resolution.atlasplugins.samlsso.configuration.RunningConfiguration;
import de.resolution.commons.util.boundedregex.BoundedRegex;
import de.resolution.commons.util.boundedregex.TimeoutExceededException;
import jakarta.inject.Inject;
import java.util.List;
import java.util.regex.PatternSyntaxException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class IdpByEmailDomainSelector {
    private static final Logger logger = LoggerFactory.getLogger(IdpByEmailDomainSelector.class);
    private final RunningConfiguration pluginConfiguration;

    @Inject
    public IdpByEmailDomainSelector(RunningConfiguration pluginConfiguration) {
        this.pluginConfiguration = pluginConfiguration;
    }

    public int selectIdpByEmailDomain(String emailDomain) {
        return this.selectIdpByEmailDomain(emailDomain, this.pluginConfiguration.getEmailDomainsForIdpSelection(), this.pluginConfiguration.getRegexTimeout());
    }

    public int selectIdpByEmailDomain(String emailDomain, List<EmailDomainIdpId> emailDomainIdpList, long timeout) {
        if (emailDomain == null || emailDomain.trim().isEmpty()) {
            return 0;
        }
        for (EmailDomainIdpId current : emailDomainIdpList) {
            try {
                if (!BoundedRegex.matches((String)current.emailDomain, (String)emailDomain, (long)timeout)) continue;
                return current.idpId;
            }
            catch (TimeoutExceededException | PatternSyntaxException e) {
                logger.error(current.emailDomain + "could not be applied as a regex, skipping", e);
            }
        }
        return 0;
    }
}

