/*
 * Decompiled with CFR 0.152.
 */
package com.resolution.atlasplugins.samlsso.idpselection;

import com.atlassian.annotations.security.UnrestrictedAccess;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.resolution.atlasplugins.samlsso.Utils;
import com.resolution.atlasplugins.samlsso.idpselection.IdpByEmailDomainSelector;
import jakarta.inject.Inject;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import org.springframework.stereotype.Component;

@Component
@UnrestrictedAccess
@Path(value="/idpByEmail")
public class IdPSelectionByEmailResource {
    private final IdpByEmailDomainSelector idpByEmailDomainSelector;

    @Inject
    public IdPSelectionByEmailResource(IdpByEmailDomainSelector idpByEmailDomainSelector) {
        this.idpByEmailDomainSelector = idpByEmailDomainSelector;
    }

    @GET
    @Path(value="/{emailaddress}")
    @Produces(value={"application/json"})
    public Response getIdP(@PathParam(value="emailaddress") String emailaddress) throws JsonProcessingException {
        if (emailaddress != null && !emailaddress.trim().isEmpty()) {
            String emailDomain = Utils.getDomainPartFromEmailAddress(emailaddress);
            return Response.ok().entity((Object)Utils.asJson(new IdpResult(this.idpByEmailDomainSelector.selectIdpByEmailDomain(emailDomain)))).build();
        }
        return Response.ok().entity((Object)Utils.asJson(new IdpResult(0))).build();
    }

    public static class IdpResult {
        private final int idpId;

        public IdpResult(int idpId) {
            this.idpId = idpId;
        }

        public int getIdpId() {
            return this.idpId;
        }
    }
}

