/*
 * Decompiled with CFR 0.152.
 */
package com.resolution.atlasplugins.samlsso.confluence;

import com.atlassian.confluence.mail.template.ConfluenceMailQueueItem;
import com.atlassian.core.task.MultiQueueTaskManager;
import com.atlassian.core.task.Task;
import com.atlassian.plugin.spring.scanner.annotation.component.ConfluenceComponent;
import com.atlassian.plugin.spring.scanner.annotation.imports.ConfluenceImport;
import com.resolution.atlasplugins.samlsso.SendEmailService;
import com.resolution.atlasplugins.samlsso.configuration.RunningConfiguration;
import jakarta.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ConfluenceComponent
public class ConfluenceSendEmailServiceImpl
implements SendEmailService {
    private static final Logger logger = LoggerFactory.getLogger(ConfluenceSendEmailServiceImpl.class);
    private final MultiQueueTaskManager multiQueueTaskManager;
    private final RunningConfiguration pluginConfiguration;

    @Inject
    public ConfluenceSendEmailServiceImpl(@ConfluenceImport MultiQueueTaskManager multiQueueTaskManager, RunningConfiguration pluginConfiguration) {
        this.multiQueueTaskManager = multiQueueTaskManager;
        this.pluginConfiguration = pluginConfiguration;
    }

    @Override
    public void sendEmail(String address, String subject, String body) {
        if (this.pluginConfiguration.getAllowedNotificationEmailAddresses().contains(address)) {
            ConfluenceMailQueueItem mailQueueItem = new ConfluenceMailQueueItem(address, subject, body, "text/plain");
            this.multiQueueTaskManager.addTask("mail", (Task)mailQueueItem);
        } else {
            logger.warn("{} is not in the list of allowed addresses, not sending", (Object)address);
        }
    }
}

