/*
 * Decompiled with CFR 0.152.
 */
package com.resolution.atlasplugins.samlsso.confluence;

import com.atlassian.plugin.spring.scanner.annotation.component.ConfluenceComponent;
import com.atlassian.plugin.spring.scanner.annotation.imports.ConfluenceImport;
import com.atlassian.sal.api.ApplicationProperties;
import com.resolution.atlasplugins.samlsso.JiraServiceDeskDetector;
import com.resolution.atlasplugins.samlsso.Utils;
import com.resolution.atlasplugins.samlsso.configuration.ConfigurationData;
import com.resolution.atlasplugins.samlsso.configuration.ConfigurationDefaultSetter;
import de.resolution.atlasuser.api.directory.DirectoryAdapter;
import jakarta.annotation.Nonnull;
import jakarta.inject.Inject;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ConfluenceComponent
public class ConfluenceConfigurationDefaultSetter
extends ConfigurationDefaultSetter {
    private static final Logger logger = LoggerFactory.getLogger(ConfluenceConfigurationDefaultSetter.class);

    @Inject
    public ConfluenceConfigurationDefaultSetter(@ConfluenceImport ApplicationProperties applicationProperties, DirectoryAdapter directoryAdapter, JiraServiceDeskDetector jiraServiceDeskDetector) {
        super(applicationProperties, directoryAdapter, jiraServiceDeskDetector);
    }

    @Override
    public void addSamlDefaults(@Nonnull ConfigurationData configurationData, boolean newConfig) {
        if (newConfig && configurationData.nonSsoDestinations.isEmpty()) {
            logger.info("Setting nonSsoDestinations to default {}", (Object)"/plugins/servlet/applinks.*,.*applicationlinks.*");
            configurationData.nonSsoDestinations = Utils.splitString("/plugins/servlet/applinks.*,.*applicationlinks.*");
        }
        if (newConfig && configurationData.enforceSsoDestinations.isEmpty()) {
            logger.info("Setting enforceSsoDestinations to default {}", (Object)"/");
            configurationData.enforceSsoDestinations = Utils.splitString("/");
        }
        super.addSamlDefaults(configurationData, newConfig);
    }

    @Override
    @Nonnull
    public List<String> getDefaultEnforceSsoUrls() {
        return Utils.splitString("/");
    }

    @Override
    @Nonnull
    public List<String> getDefaultNonSsoUrls() {
        return Utils.splitString("/plugins/servlet/applinks.*,.*applicationlinks.*");
    }
}

