/*
 * Decompiled with CFR 0.152.
 */
package com.resolution.atlasplugins.samlsso.configuration.validation;

import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.resolution.atlasplugins.samlsso.configuration.CommonIdpConfigurationData;
import com.resolution.atlasplugins.samlsso.configuration.ConfigurationData;
import com.resolution.atlasplugins.samlsso.configuration.oauth.OAuth2IdpConfigurationData;
import com.resolution.atlasplugins.samlsso.configuration.validation.CommonIdpConfigurationDataValidator;
import com.resolution.atlasplugins.samlsso.oidcandoauth.OidcAndOAuthCommonHelpers;
import com.resolution.atlasplugins.samlsso.oidcandoauth.oauth2.PkceType;
import de.resolution.commons.util.CollectionUtil;
import de.resolution.commons.validate.api.ValidationResult;
import de.resolution.retransform.config.AttributeTransformationConfigValidator;
import de.resolution.usersync.api.UserSyncService;
import jakarta.inject.Inject;
import org.springframework.stereotype.Component;

@Component
@ExportAsService(value={OAuthIdpConfigurationDataValidator.class})
public class OAuthIdpConfigurationDataValidator
extends CommonIdpConfigurationDataValidator<OAuth2IdpConfigurationData> {
    @Inject
    protected OAuthIdpConfigurationDataValidator(AttributeTransformationConfigValidator attributeTransformationConfigValidator, UserSyncService userSyncService) {
        super(attributeTransformationConfigValidator, userSyncService);
    }

    @Override
    public ValidationResult validate(OAuth2IdpConfigurationData oauthConfig, ConfigurationData configurationData) {
        ValidationResult result = super.validate(oauthConfig, configurationData);
        OidcAndOAuthCommonHelpers.validateOAuth2Basics(oauthConfig, configurationData, result);
        if (CollectionUtil.isNullOrEmpty(oauthConfig.userInfoEndpoints)) {
            result.add("userInfoEndpoints", "You must add a user information endpoint");
        } else {
            result.add("userInfoEndpoints", OidcAndOAuthCommonHelpers.validateUserInfoEndpoints(oauthConfig));
        }
        if (CollectionUtil.isNullOrEmpty(oauthConfig.scopes)) {
            result.add("scopes", null, "You might want to request some scope(s). You can find this in API docs of your OAuth2 provider.");
        }
        if (oauthConfig.userUpdateMethod == CommonIdpConfigurationData.UserUpdateMethod.SAML || oauthConfig.userUpdateMethod == CommonIdpConfigurationData.UserUpdateMethod.CONNECTORANDSAML) {
            result.add("userUpdateMethod", "Update from SAML (and Connector) is not available for OAuth2.");
        }
        if (oauthConfig.usePkce && oauthConfig.pkceMethod == null) {
            result.add("pkceMethod", "PKCE method is null");
        }
        if (oauthConfig.usePkce && oauthConfig.pkceMethod == PkceType.PLAIN) {
            result.add("pkceMethod", null, "Unless you have good reason to use 'plain', we suggest to stick to SHA-256");
        }
        if (oauthConfig.authScheme == null) {
            result.add("authScheme", "The auth scheme is null. Please choose one of the provided options or add a custom one");
        }
        return result;
    }
}

