/*
 * Decompiled with CFR 0.152.
 */
package com.resolution.atlasplugins.samlsso.configuration.metadata;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.resolution.atlasplugins.samlsso.configuration.ConfigurationData;
import de.resolution.commons.validate.api.ValidationResult;
import jakarta.annotation.Nonnull;
import java.util.Collections;
import java.util.List;

@JsonAutoDetect
public class MultiIdPMetadataMergeResult {
    @Nonnull
    private final String message;
    @Nonnull
    private final ConfigurationData configurationData;
    @Nonnull
    private final ValidationResult validationResult;
    @Nonnull
    private final List<String> changedIds;
    @Nonnull
    private final List<String> addedIds;
    @Nonnull
    private final List<String> removedIds;
    private final boolean success;

    public MultiIdPMetadataMergeResult(boolean success, @Nonnull ConfigurationData configurationData, @Nonnull ValidationResult validationResult, @Nonnull String message, @Nonnull List<String> changedIds, @Nonnull List<String> addedIds, @Nonnull List<String> removedIds) {
        this.success = success;
        this.configurationData = configurationData;
        this.validationResult = validationResult;
        this.message = message;
        this.changedIds = changedIds;
        this.addedIds = addedIds;
        this.removedIds = removedIds;
    }

    @Nonnull
    public static MultiIdPMetadataMergeResult createdUnchanged(@Nonnull ConfigurationData configurationData, @Nonnull String message) {
        return new MultiIdPMetadataMergeResult(true, configurationData, ValidationResult.create(), message, Collections.emptyList(), Collections.emptyList(), Collections.emptyList());
    }

    @Nonnull
    public String getMessage() {
        return this.message;
    }

    @Nonnull
    public ConfigurationData getConfigurationData() {
        return this.configurationData;
    }

    @Nonnull
    public ValidationResult getValidationResult() {
        return this.validationResult;
    }

    public boolean isChanged() {
        return !this.changedIds.isEmpty() || !this.addedIds.isEmpty() || !this.removedIds.isEmpty();
    }

    public boolean isSuccess() {
        return this.success;
    }

    public int getChangedCount() {
        return this.changedIds.size();
    }

    public int getAddedCount() {
        return this.addedIds.size();
    }

    public int getRemovedCount() {
        return this.removedIds.size();
    }

    @Nonnull
    public List<String> getChangedIds() {
        return this.changedIds;
    }

    @Nonnull
    public List<String> getAddedIds() {
        return this.addedIds;
    }

    @Nonnull
    public List<String> getRemovedIds() {
        return this.removedIds;
    }
}

