/*
 * Decompiled with CFR 0.152.
 */
package com.resolution.atlasplugins.samlsso.configuration.metadata;

import com.resolution.atlasplugins.samlsso.configuration.CommonIdpConfigurationData;
import com.resolution.atlasplugins.samlsso.configuration.ConfigurationData;
import com.resolution.atlasplugins.samlsso.configuration.ConfigurationDefaultSetter;
import com.resolution.atlasplugins.samlsso.configuration.SamlIdpConfigurationData;
import com.resolution.atlasplugins.samlsso.configuration.metadata.MultiIdPMetadataMergeResult;
import com.resolution.atlasplugins.samlsso.configuration.validation.ConfigurationDataValidator;
import com.resolution.samlwrapper.api.IdPMetadata;
import com.resolution.samlwrapper.api.SAMLWrapper;
import de.resolution.commons.validate.api.ValidationResult;
import groovy.lang.Binding;
import groovy.lang.GroovyShell;
import groovy.lang.Script;
import jakarta.annotation.Nonnull;
import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.control.customizers.CompilationCustomizer;
import org.codehaus.groovy.control.customizers.ImportCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class MetadataIntoConfigurationMerger {
    private static final Logger logger = LoggerFactory.getLogger(MetadataIntoConfigurationMerger.class);
    private final ConfigurationDefaultSetter defaultSetter;
    private final ConfigurationDataValidator validator;

    @Inject
    public MetadataIntoConfigurationMerger(ConfigurationDefaultSetter defaultSetter, ConfigurationDataValidator validator) {
        this.defaultSetter = defaultSetter;
        this.validator = validator;
    }

    public static boolean differs(String dataInConfig, String dataInMetadata) {
        if (dataInConfig == null && dataInMetadata == null) {
            return false;
        }
        if (dataInConfig != null && dataInMetadata == null) {
            return true;
        }
        if (dataInConfig == null) {
            return true;
        }
        return !dataInConfig.equals(dataInMetadata);
    }

    private boolean updateSelectedLoginBinding(SamlIdpConfigurationData idpConfiguration) {
        if (idpConfiguration.postBindingURL == null || idpConfiguration.redirectBindingURL == null) {
            if (idpConfiguration.postBindingURL == null && idpConfiguration.redirectBindingURL != null) {
                if (idpConfiguration.selectedLoginBinding != SAMLWrapper.Binding.REDIRECT) {
                    idpConfiguration.selectedLoginBinding = SAMLWrapper.Binding.REDIRECT;
                    return true;
                }
            } else if (idpConfiguration.selectedLoginBinding != SAMLWrapper.Binding.POST) {
                idpConfiguration.selectedLoginBinding = SAMLWrapper.Binding.POST;
                return true;
            }
        }
        return false;
    }

    public boolean mergeIdpMetadata(@Nonnull SamlIdpConfigurationData idpConfiguration, @Nonnull IdPMetadata idPMetadata) {
        logger.debug("Merging IdP metadata for {}", (Object)idpConfiguration.idpId);
        boolean changed = false;
        if (MetadataIntoConfigurationMerger.differs(idpConfiguration.idpId, idPMetadata.getIdpId())) {
            idpConfiguration.idpId = idPMetadata.getIdpId();
            changed = true;
            logger.debug("idpId differs");
        }
        if (MetadataIntoConfigurationMerger.differs(idpConfiguration.postBindingURL, idPMetadata.getPostBindingURL())) {
            idpConfiguration.postBindingURL = idPMetadata.getPostBindingURL();
            changed = true;
            logger.debug("postBindingURL differs");
        }
        if (MetadataIntoConfigurationMerger.differs(idpConfiguration.redirectBindingURL, idPMetadata.getRedirectBindingURL())) {
            idpConfiguration.redirectBindingURL = idPMetadata.getRedirectBindingURL();
            changed = true;
            logger.debug("redirectBindingURL differs");
        }
        boolean bl = changed = this.updateSelectedLoginBinding(idpConfiguration) || changed;
        if (MetadataIntoConfigurationMerger.differs(idpConfiguration.postBindingLogoutURL, idPMetadata.getPostBindingLogoutURL())) {
            idpConfiguration.postBindingLogoutURL = idPMetadata.getPostBindingLogoutURL();
            changed = true;
            logger.debug("postBindingLogoutURL differs");
        }
        if (MetadataIntoConfigurationMerger.differs(idpConfiguration.postBindingLogoutResponseURL, idPMetadata.getPostBindingLogoutResponseURL())) {
            idpConfiguration.postBindingLogoutResponseURL = idPMetadata.getPostBindingLogoutResponseURL();
            changed = true;
            logger.debug("postBindingLogoutResponseURL differs");
        }
        if (MetadataIntoConfigurationMerger.differs(idpConfiguration.redirectBindingLogoutURL, idPMetadata.getRedirectBindingLogoutURL())) {
            idpConfiguration.redirectBindingLogoutURL = idPMetadata.getRedirectBindingLogoutURL();
            changed = true;
            logger.debug("redirectBindingLogoutURL differs");
        }
        if (MetadataIntoConfigurationMerger.differs(idpConfiguration.redirectBindingLogoutResponseURL, idPMetadata.getRedirectBindingLogoutResponseURL())) {
            idpConfiguration.redirectBindingLogoutResponseURL = idPMetadata.getRedirectBindingLogoutResponseURL();
            changed = true;
            logger.debug("redirectBindingLogoutResponseURL differs");
        }
        if (idpConfiguration.certificates.size() != idPMetadata.getCertificates().size() || !new HashSet<String>(idpConfiguration.certificates).containsAll(idPMetadata.getCertificates()) || !new HashSet(idPMetadata.getCertificates()).containsAll(idpConfiguration.certificates)) {
            idpConfiguration.certificates.clear();
            idpConfiguration.certificates.addAll(idPMetadata.getCertificates());
            changed = true;
            logger.debug("certificates differ");
        }
        if (!idpConfiguration.attributeMapping.equals(idPMetadata.getAttributeMapping())) {
            idpConfiguration.attributeMapping.clear();
            idpConfiguration.attributeMapping.putAll(idPMetadata.getAttributeMapping());
            changed = true;
            logger.debug("attributeMapping differs");
        }
        idpConfiguration.metadataReloadStatus = changed ? SamlIdpConfigurationData.MetadataReloadStatus.UPDATED : SamlIdpConfigurationData.MetadataReloadStatus.ACTUAL;
        return changed;
    }

    public static Script createGenerateNameForIdpScript(@Nonnull String groovyCode) {
        ImportCustomizer importCustomizer = new ImportCustomizer();
        importCustomizer.addStarImports(new String[]{"groovy.xml", "groovy.xml.dom"});
        CompilerConfiguration compilerConfiguration = new CompilerConfiguration();
        compilerConfiguration.addCompilationCustomizers(new CompilationCustomizer[]{importCustomizer});
        GroovyShell groovyShell = new GroovyShell(compilerConfiguration);
        return groovyShell.parse(groovyCode);
    }

    public String generateNameForIdP(Script generateNameForIdpScript, IdPMetadata idPMetadata, int id) {
        Binding binding = new Binding();
        binding.setVariable("md", (Object)idPMetadata);
        binding.setVariable("id", (Object)id);
        generateNameForIdpScript.setBinding(binding);
        Object result = generateNameForIdpScript.run();
        return String.valueOf(result);
    }

    @Nonnull
    public MultiIdPMetadataMergeResult mergeMultiIdpMetadata(@Nonnull ConfigurationData currentConfigurationData, @Nonnull Collection<IdPMetadata> metadataCollection) {
        ArrayList<String> addedIdpIds = new ArrayList<String>();
        ArrayList<String> changedIdpIds = new ArrayList<String>();
        ConfigurationData configurationData = new ConfigurationData(currentConfigurationData);
        if (metadataCollection.isEmpty()) {
            logger.warn("metadataCollection is empty, nothing to merge.");
            return new MultiIdPMetadataMergeResult(true, configurationData, this.validator.validate(configurationData, null), "Metadata-collection is empty, nothing to merge", Collections.emptyList(), Collections.emptyList(), Collections.emptyList());
        }
        HashMap idpConfigurationMap = new HashMap();
        configurationData.idpConfigurations.stream().filter(SamlIdpConfigurationData.class::isInstance).forEach(idpConfiguration -> idpConfigurationMap.put(idpConfiguration.idpId, (SamlIdpConfigurationData)idpConfiguration));
        Script generateNameForIdPScript = MetadataIntoConfigurationMerger.createGenerateNameForIdpScript(configurationData.idpNameFromMetadataExpression);
        for (IdPMetadata idPMetadata : metadataCollection) {
            String generatedIdPName;
            boolean added = false;
            SamlIdpConfigurationData idpConfiguration2 = (SamlIdpConfigurationData)idpConfigurationMap.get(idPMetadata.getIdpId());
            if (idpConfiguration2 == null) {
                idpConfiguration2 = this.createNewIdPConfigurationData(configurationData);
                added = true;
            }
            boolean changed = false;
            if (idpConfiguration2.createdFromMetadata && !(generatedIdPName = this.generateNameForIdP(generateNameForIdPScript, idPMetadata, idpConfiguration2.id)).equals(idpConfiguration2.name)) {
                idpConfiguration2.name = generatedIdPName;
                changed = true;
            }
            boolean bl = changed = this.mergeIdpMetadata(idpConfiguration2, idPMetadata) || changed;
            if (added) {
                logger.debug("IdP {} is added", (Object)idpConfiguration2.idpId);
                addedIdpIds.add(idpConfiguration2.idpId);
                continue;
            }
            if (changed) {
                logger.debug("IdP {} is changed", (Object)idpConfiguration2.idpId);
                changedIdpIds.add(idpConfiguration2.idpId);
                continue;
            }
            logger.debug("IdP {} is not modified", (Object)idpConfiguration2.idpId);
        }
        List<String> removedIds = this.removeIdPsNoLongerInMetadata(metadataCollection, configurationData);
        ValidationResult validationResult = this.validator.validate(configurationData, null);
        if (validationResult == null) {
            validationResult = ValidationResult.create();
        }
        if (validationResult.isValid()) {
            return new MultiIdPMetadataMergeResult(true, configurationData, validationResult, "", changedIdpIds, addedIdpIds, removedIds);
        }
        return new MultiIdPMetadataMergeResult(false, configurationData, validationResult.reduceToErrors(), "Configuration is not valid after merging metadata.", changedIdpIds, addedIdpIds, removedIds);
    }

    private SamlIdpConfigurationData createNewIdPConfigurationData(ConfigurationData configurationData) {
        SamlIdpConfigurationData idpConfiguration = new SamlIdpConfigurationData();
        this.defaultSetter.addSamlDefaults(idpConfiguration);
        int id = 1;
        while (this.containsId(configurationData.idpConfigurations, id)) {
            ++id;
        }
        idpConfiguration.id = id;
        int weight = 10;
        while (this.containsWeight(configurationData.idpConfigurations, weight)) {
            weight += 10;
        }
        idpConfiguration.weight = weight;
        idpConfiguration.createdFromMetadata = true;
        idpConfiguration.autoReloadMetadata = false;
        logger.debug("Creating new IdPConfiguration for {} with Id {} name {} and weight {}", new Object[]{idpConfiguration.idpId, idpConfiguration.id, idpConfiguration.name, idpConfiguration.weight});
        configurationData.idpConfigurations.add(idpConfiguration);
        return idpConfiguration;
    }

    private List<String> removeIdPsNoLongerInMetadata(Collection<IdPMetadata> metadataCollection, ConfigurationData configurationData) {
        Set idsFromMetadata = metadataCollection.stream().map(IdPMetadata::getIdpId).collect(Collectors.toSet());
        ArrayList<String> removedIds = new ArrayList<String>();
        ArrayList<SamlIdpConfigurationData> configsToRemove = new ArrayList<SamlIdpConfigurationData>();
        for (CommonIdpConfigurationData currentIdp : configurationData.idpConfigurations) {
            if (!(currentIdp instanceof SamlIdpConfigurationData)) continue;
            SamlIdpConfigurationData currentSamlIdp = (SamlIdpConfigurationData)currentIdp;
            if (!currentSamlIdp.createdFromMetadata || idsFromMetadata.contains(currentSamlIdp.idpId)) continue;
            configsToRemove.add(currentSamlIdp);
            removedIds.add(currentSamlIdp.idpId);
        }
        configurationData.idpConfigurations.removeAll(configsToRemove);
        return removedIds;
    }

    private boolean containsId(Collection<CommonIdpConfigurationData> idPs, int id) {
        return idPs.stream().anyMatch(idp -> idp.id == id);
    }

    private boolean containsWeight(Collection<CommonIdpConfigurationData> idPs, int weight) {
        return idPs.stream().anyMatch(idp -> idp.weight == weight);
    }
}

