/*
 * Decompiled with CFR 0.152.
 */
package com.resolution.atlasplugins.samlsso.configuration.metadata;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.resolution.atlasplugins.samlsso.Utils;
import com.resolution.atlasplugins.samlsso.configuration.ConfigurationData;
import com.resolution.atlasplugins.samlsso.configuration.RunningConfiguration;
import com.resolution.atlasplugins.samlsso.configuration.metadata.MetadataIntoConfigurationMerger;
import com.resolution.atlasplugins.samlsso.configuration.metadata.MetadataMergeInformation;
import com.resolution.atlasplugins.samlsso.configuration.metadata.MultiIdPMetadataMergeResult;
import com.resolution.atlasplugins.samlsso.servlet.ErrorResponse;
import com.resolution.samlwrapper.api.IdPMetadata;
import com.resolution.samlwrapper.api.SAMLWrapper;
import com.resolution.samlwrapper.api.exception.MetadataException;
import de.resolution.reconfigure.InsufficientUserPrivilegeException;
import de.resolution.reconfigure.PrivilegeChecker;
import groovy.lang.Script;
import jakarta.inject.Inject;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Path(value="/mergeMetadata")
@Component
public class MergeMetadataRESTResource {
    private static final Logger logger = LoggerFactory.getLogger(MergeMetadataRESTResource.class);
    private final SAMLWrapper samlWrapper;
    private final RunningConfiguration pluginConfiguration;
    private final MetadataIntoConfigurationMerger metadataMerger;
    private final PrivilegeChecker privilegeChecker;
    private final ObjectMapper objectMapper = new ObjectMapper();

    @Inject
    public MergeMetadataRESTResource(SAMLWrapper samlWrapper, RunningConfiguration pluginConfiguration, PrivilegeChecker privilegeChecker, MetadataIntoConfigurationMerger metadataMerger) {
        this.samlWrapper = samlWrapper;
        this.pluginConfiguration = pluginConfiguration;
        this.privilegeChecker = privilegeChecker;
        this.metadataMerger = metadataMerger;
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response readMetadataFromURL(String mergeInfoJson, @Context HttpServletRequest request) throws InsufficientUserPrivilegeException, IOException {
        String metadataURL;
        MetadataMergeInformation mergeInfo = (MetadataMergeInformation)this.objectMapper.readValue(mergeInfoJson, MetadataMergeInformation.class);
        this.privilegeChecker.checkPrivileges(request, this.privilegeChecker.getPrivilegeFactory().isSysadmin());
        ConfigurationData configurationData = mergeInfo.getConfigurationData();
        if (configurationData == null) {
            configurationData = this.pluginConfiguration.getConfigurationData();
        }
        if ((metadataURL = configurationData.commonMetadataUrl) == null || metadataURL.trim().isEmpty()) {
            metadataURL = mergeInfo.getMetadataURL();
            configurationData.commonMetadataUrl = mergeInfo.getMetadataURL();
        }
        if (metadataURL == null || metadataURL.trim().isEmpty()) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)Utils.asJson(new ErrorResponse("no metadata URL provided"))).cacheControl(Utils.ccNoCache).build();
        }
        try {
            Collection metadataCollection = this.samlWrapper.readMultipleIdPMetadata(metadataURL, mergeInfo.isIgnoreCertificate(), mergeInfo.getMetadataCertificate(), mergeInfo.getIdpsToSkip());
            MultiIdPMetadataMergeResult mergeResult = this.metadataMerger.mergeMultiIdpMetadata(configurationData, metadataCollection);
            if (mergeResult.isChanged()) {
                logger.info("\n=================================================\nMerged multi-IdP Metadata, needs to be saved:\nAdded IdPs:   {}\nChanged IdPs: {}\nRemoved IdPs: {}\n=================================================", new Object[]{mergeResult.getAddedIds(), mergeResult.getChangedIds(), mergeResult.getRemovedIds()});
            } else {
                logger.info("Multi-IdP Metadata has not changed");
            }
            return Response.ok().entity((Object)Utils.asJson(mergeResult)).cacheControl(Utils.ccNoCache).build();
        }
        catch (MetadataException e) {
            logger.error("Fetching Metadata failed", (Throwable)e);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)Utils.asJson(new ErrorResponse("Fetching Metadata failed: " + e.getMessage()))).cacheControl(Utils.ccNoCache).build();
        }
    }

    @Path(value="/createNames")
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response generateIdPNames(String createNamesJson, @Context HttpServletRequest request) throws InsufficientUserPrivilegeException, IOException {
        CreateNamesData namesData = (CreateNamesData)this.objectMapper.readValue(createNamesJson, CreateNamesData.class);
        this.privilegeChecker.checkPrivileges(request, this.privilegeChecker.getPrivilegeFactory().isSysadmin());
        String groovy = namesData.getGenerateNamesGroovy();
        String metadataURL = namesData.getMetadataURL();
        if (metadataURL == null || metadataURL.trim().isEmpty()) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)Utils.asJson(new ErrorResponse("no metadata URL provided"))).cacheControl(Utils.ccNoCache).build();
        }
        Script nameScript = MetadataIntoConfigurationMerger.createGenerateNameForIdpScript(groovy);
        try {
            Collection metadataCollection = this.samlWrapper.readMultipleIdPMetadata(metadataURL, true, null, namesData.getIdpsToSkip());
            ArrayList<String> nameList = new ArrayList<String>();
            for (IdPMetadata idPMetadata : metadataCollection) {
                String name = this.metadataMerger.generateNameForIdP(nameScript, idPMetadata, 0);
                nameList.add(name);
            }
            return Response.ok().entity((Object)Utils.asJson(nameList)).cacheControl(Utils.ccNoCache).build();
        }
        catch (MetadataException e) {
            logger.error("Fetching Metadata failed", (Throwable)e);
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)Utils.asJson(new ErrorResponse("Fetching Metadata failed: " + e.getMessage()))).cacheControl(Utils.ccNoCache).build();
        }
    }

    private static class CreateNamesData {
        private final String metadataURL;
        private final String generateNamesGroovy;
        private final List<String> idpsToSkip;

        @JsonCreator
        public CreateNamesData(@JsonProperty(value="metadataURL") String metadataURL, @JsonProperty(value="generateNamesGroovy") String generateNamesGroovy, @JsonProperty(value="idpsToSkip") List<String> idpsToSkip) {
            this.metadataURL = metadataURL;
            this.generateNamesGroovy = generateNamesGroovy;
            this.idpsToSkip = idpsToSkip == null ? Collections.emptyList() : idpsToSkip;
        }

        public String getMetadataURL() {
            return this.metadataURL;
        }

        public String getGenerateNamesGroovy() {
            return this.generateNamesGroovy;
        }

        public List<String> getIdpsToSkip() {
            return this.idpsToSkip;
        }
    }
}

