/*
 * Decompiled with CFR 0.152.
 */
package com.resolution.atlasplugins.samlsso.configuration.legacyloader;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.resolution.atlasplugins.samlsso.Utils;
import com.resolution.atlasplugins.samlsso.configuration.EmailDomainIdpId;
import com.resolution.atlasplugins.samlsso.configuration.HeaderValueIdpId;
import com.resolution.atlasplugins.samlsso.configuration.RunningConfiguration;
import com.resolution.atlasplugins.samlsso.configuration.legacyloader.V2IdpConfiguration;
import com.resolution.atlasplugins.samlsso.configuration.legacyloader.V3ConfigurationData;
import com.resolution.atlasplugins.samlsso.configuration.legacyloader.VersionedConfigurationData;
import com.resolution.samlwrapper.api.metadata.MetadataInformation;
import com.resolution.samlwrapper.api.metadata.impl.MetadataInformationImpl;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlElementWrapper;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlTransient;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude
public final class V2ConfigurationData
implements Cloneable,
VersionedConfigurationData {
    @XmlTransient
    public static final int CURRENT_VERSION = 2;
    @XmlTransient
    private static final Logger logger = LoggerFactory.getLogger(V2ConfigurationData.class);
    public int version = 0;
    public String defaultRedirectUrl;
    public boolean overrideLoginUrl;
    public boolean overrideLogoutUrl;
    public boolean preventLoginForm;
    public String logoutUrl;
    public boolean enableUserForLogin;
    public String userGroupForEnablement;
    public boolean enableIdPSelection;
    public String jiraGroups;
    public String useridTransformationRegex;
    public String useridTransformationReplacement;
    public String errorPageTemplate;
    public String loggedInPageTemplate;
    public String loggedOutPageTemplate;
    public String idpSelectionPageTemplate;
    public String idpByEmailPageTemplate;
    public String serviceDeskErrorPageTemplate;
    public boolean enableIdPSelectionByEmailAddress;
    public String groupsToAddUserTo;
    public String nonSsoDestinations;
    public String nonSsoUserAgents;
    public String enforceSsoDestinations;
    public String jiraIssueCollectors;
    public boolean redirectServiceDeskLogin;
    public boolean setRememberMeCookie = false;
    public boolean enforceResponseValidityDates = true;
    public boolean enforceResponseIDUniqueness = true;
    public boolean includeSigingCertificateInMetadata = true;
    public boolean includeEncryptionCertificateInMetadata;
    public String nossoRequestHeader = null;
    public String nossoRequestHeaderValue = null;
    public boolean signRequests = false;
    public String privateKeyPEM;
    public String certificatePEM;
    public int clockSkew = 60;
    public boolean skipBaseUrlCheck = false;
    public Map<String, Long> directoryList;
    public Map<String, String> bindingList;
    public Map<String, String> nameIdFormatList;
    public MetadataInformationImpl metadataInformation = new MetadataInformationImpl();
    @XmlElementWrapper(name="idpConfigurations")
    @XmlElement(name="idpConfiguration")
    public List<V2IdpConfiguration> idpConfigurations = new ArrayList<V2IdpConfiguration>();
    public V2IdpConfiguration defaultIdpConfiguration;

    public boolean equals(Object otherObject) {
        if (otherObject == null) {
            return false;
        }
        if (!(otherObject instanceof V2ConfigurationData)) {
            return false;
        }
        V2ConfigurationData other = (V2ConfigurationData)otherObject;
        if (this.idpConfigurations.size() != other.idpConfigurations.size()) {
            return false;
        }
        for (int i = 0; i < this.idpConfigurations.size(); ++i) {
            if (this.idpConfigurations.get(i).equals(other.idpConfigurations.get(i))) continue;
            return false;
        }
        Field[] fields = this.getClass().getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            if (fields[i].getName().equals("idpConfigurations")) continue;
            try {
                Object thisField = fields[i].get(this);
                Object otherField = fields[i].get(other);
                if (thisField == null && otherField != null) {
                    logger.debug("{} differs", (Object)fields[i].getName());
                    return false;
                }
                if (thisField != null && otherField == null) {
                    logger.debug("{} differs", (Object)fields[i].getName());
                    return false;
                }
                if (thisField == null || otherField == null || thisField.equals(otherField)) continue;
                logger.debug("{} differs", (Object)fields[i].getName());
                return false;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return true;
    }

    public V2ConfigurationData clone() {
        V2ConfigurationData ret = new V2ConfigurationData();
        for (V2IdpConfiguration idpconfig : this.idpConfigurations) {
            ret.idpConfigurations.add(idpconfig.clone());
        }
        Field[] fields = this.getClass().getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            if (fields[i].getName().equals("idpConfigurations") || Modifier.isStatic(fields[i].getModifiers())) continue;
            try {
                fields[i].set(ret, fields[i].get(this));
                continue;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return ret;
    }

    protected static String newLinesToSeparators(String string) {
        if (string == null) {
            return null;
        }
        return string.trim().replaceAll("\n", ",");
    }

    protected static String separatorsToNewLines(String string) {
        if (string == null) {
            return null;
        }
        return string.replaceAll(",", "\n");
    }

    public static final String getPluginSettingsKey(String parameter) {
        return V2ConfigurationData.getPluginSettingsKey(parameter, true);
    }

    public static final String getPluginSettingsKey(String parameter, boolean versioned) {
        if (versioned) {
            return "com.resolution.atlasplugins.samlsso:2:" + parameter;
        }
        return "com.resolution.atlasplugins.samlsso:" + parameter;
    }

    @Override
    public int getVersion() {
        return 2;
    }

    @Override
    public V3ConfigurationData migrateToNewerModelVersion() {
        logger.debug("Migrating ConfigurationData from version 2 to 3.");
        V3ConfigurationData migratedConfigurationData = new V3ConfigurationData();
        migratedConfigurationData.version = 3;
        migratedConfigurationData.defaultRedirectUrl = this.defaultRedirectUrl;
        migratedConfigurationData.overrideLoginUrl = this.overrideLoginUrl;
        migratedConfigurationData.preventLoginForm = this.preventLoginForm;
        migratedConfigurationData.overrideLoggedOutUrlMethod = this.overrideLogoutUrl ? RunningConfiguration.OverrideLoggedOutUrlMethod.REDIRECT_ALL : RunningConfiguration.OverrideLoggedOutUrlMethod.NO_REDIRECTION;
        migratedConfigurationData.logoutUrl = this.logoutUrl;
        migratedConfigurationData.enableUserForLogin = this.enableUserForLogin;
        migratedConfigurationData.idpSelectionMethod = this.enableIdPSelection ? RunningConfiguration.IdpSelectionMethod.SELECTIONPAGE : (this.enableIdPSelectionByEmailAddress ? RunningConfiguration.IdpSelectionMethod.EMAIL : RunningConfiguration.IdpSelectionMethod.FIRST);
        migratedConfigurationData.errorPageTemplate = this.errorPageTemplate;
        migratedConfigurationData.loggedInPageTemplate = this.loggedInPageTemplate;
        migratedConfigurationData.loggedOutPageTemplate = this.loggedOutPageTemplate;
        migratedConfigurationData.idpSelectionPageTemplate = this.idpSelectionPageTemplate;
        migratedConfigurationData.idpByEmailPageTemplate = this.idpByEmailPageTemplate;
        migratedConfigurationData.serviceDeskErrorPageTemplate = this.serviceDeskErrorPageTemplate;
        migratedConfigurationData.groupsToAddUserTo = Utils.splitString(this.groupsToAddUserTo);
        migratedConfigurationData.nonSsoDestinations = Utils.splitString(this.nonSsoDestinations);
        migratedConfigurationData.nonSsoUserAgents = Utils.splitString(this.nonSsoUserAgents);
        migratedConfigurationData.enforceSsoDestinations = Utils.splitString(this.enforceSsoDestinations);
        migratedConfigurationData.jiraIssueCollectors = Utils.splitString(this.jiraIssueCollectors);
        migratedConfigurationData.redirectServiceDeskLogin = this.redirectServiceDeskLogin;
        migratedConfigurationData.setRememberMeCookie = this.setRememberMeCookie;
        migratedConfigurationData.enforceResponseValidityDates = this.enforceResponseValidityDates;
        migratedConfigurationData.enforceResponseIDUniqueness = this.enforceResponseIDUniqueness;
        migratedConfigurationData.includeSigningCertificateInMetadata = this.includeSigingCertificateInMetadata;
        migratedConfigurationData.includeEncryptionCertificateInMetadata = this.includeEncryptionCertificateInMetadata;
        migratedConfigurationData.entityId = null;
        migratedConfigurationData.privateKeyPEM = this.privateKeyPEM;
        migratedConfigurationData.certificatePEM = this.certificatePEM;
        migratedConfigurationData.clockSkew = this.clockSkew;
        migratedConfigurationData.skipBaseUrlCheck = this.skipBaseUrlCheck;
        migratedConfigurationData.trackerStorageHours = 48;
        migratedConfigurationData.trackerCleanupIntervalInMinutes = 60;
        migratedConfigurationData.metadataInformation = this.metadataInformation;
        for (V2IdpConfiguration v2 : this.idpConfigurations) {
            migratedConfigurationData.idpConfigurations.add(v2.migrateToNewerModelVersion());
            if (v2.requestHeader != null && !v2.requestHeader.trim().isEmpty()) {
                String value = v2.requestHeaderValue == null || v2.requestHeaderValue.trim().isEmpty() ? ".*" : v2.requestHeaderValue;
                HeaderValueIdpId requestHeader = new HeaderValueIdpId(v2.requestHeader, value, v2.id);
                migratedConfigurationData.requestHeadersForIdpSelection.add(requestHeader);
            }
            for (String emailDomain : Utils.splitString(v2.emailDomains)) {
                emailDomain = emailDomain.replaceAll("\\.", "\\.");
                EmailDomainIdpId emailDomainIdP = new EmailDomainIdpId(emailDomain, v2.id);
                migratedConfigurationData.emailDomainsForIdpSelection.add(emailDomainIdP);
            }
        }
        if (this.nossoRequestHeader != null && !this.nossoRequestHeader.trim().isEmpty()) {
            String value = this.nossoRequestHeaderValue == null || this.nossoRequestHeaderValue.trim().isEmpty() ? ".*" : this.nossoRequestHeaderValue;
            HeaderValueIdpId requestHeaderNoSSO = new HeaderValueIdpId(this.nossoRequestHeader, value, -1);
            migratedConfigurationData.requestHeadersForIdpSelection.add(requestHeaderNoSSO);
        }
        return migratedConfigurationData;
    }

    @Override
    public MetadataInformation getMetadataInformation() {
        return this.metadataInformation;
    }

    @Override
    public void setMetadataInformation(MetadataInformationImpl metadataInformation) {
        this.metadataInformation = metadataInformation;
    }
}

