/*
 * Decompiled with CFR 0.152.
 */
package com.resolution.atlasplugins.samlsso.configuration.legacyloader;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.resolution.atlasplugins.samlsso.Utils;
import com.resolution.atlasplugins.samlsso.configuration.legacyloader.V2IdpConfiguration;
import com.resolution.atlasplugins.samlsso.configuration.legacyloader.VersionedIdPConfiguration;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElementWrapper;
import jakarta.xml.bind.annotation.XmlTransient;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@XmlAccessorType(value=XmlAccessType.PROPERTY)
@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude
public class V1IdpConfiguration
implements VersionedIdPConfiguration {
    private Integer id = null;
    private String name;
    private String description;
    private String url;
    private String issuer;
    private String certificate;
    private String secondCertificate;
    private String relayStateParameterName;
    private String ssoUrl = null;
    private String useridAttribute = null;
    private String fullnameAttribute = null;
    private String emailAttribute = null;
    private String groupAttribute = null;
    private String groupsForNewUsers = null;
    private String groupsForNewSdCustomers = null;
    private String emailDomains = null;
    private String useridTransformationRegex;
    private String useridTransformationReplacement;
    private Long directoryIdForNewUsers;
    private boolean omitRequestedAuthnContext = true;
    private boolean removeFromGroups = false;
    private boolean updateExisting = false;
    private boolean enableUserUpdate = false;
    private boolean lowercaseConvert = false;
    private boolean lowercaseConvertGroups = false;
    private String metadataurl;
    private String metadataxml;
    private boolean metadataignorecert;
    private boolean useMetadataxml = false;
    private HashMap<String, String> idpAttributes = new HashMap();

    @XmlElementWrapper(name="idpAttributes")
    public Map<String, String> getIdpAttributes() {
        return this.idpAttributes;
    }

    public void setIdpAttributes(HashMap<String, String> idpAttributes) {
        this.idpAttributes = idpAttributes;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getCertificate() {
        return this.certificate;
    }

    public void setCertificate(String certificate) {
        this.certificate = certificate;
    }

    public String getSecondCertificate() {
        return this.secondCertificate;
    }

    public void setSecondCertificate(String secondCertificate) {
        this.secondCertificate = secondCertificate;
    }

    public String getRelayStateParameterName() {
        return this.relayStateParameterName;
    }

    public void setRelayStateParameterName(String relayStateParameterName) {
        this.relayStateParameterName = relayStateParameterName;
    }

    public String getUseridTransformationRegex() {
        return this.useridTransformationRegex;
    }

    public void setUseridTransformationRegex(String useridTransformationRegex) {
        this.useridTransformationRegex = useridTransformationRegex;
    }

    public String getUseridTransformationReplacement() {
        return this.useridTransformationReplacement;
    }

    public void setUseridTransformationReplacement(String useridTransformationReplacement) {
        this.useridTransformationReplacement = useridTransformationReplacement;
    }

    public boolean isOmitRequestedAuthnContext() {
        return this.omitRequestedAuthnContext;
    }

    public void setOmitRequestedAuthnContext(boolean omitRequestedAuthnContext) {
        this.omitRequestedAuthnContext = omitRequestedAuthnContext;
    }

    public boolean isEnableUserUpdate() {
        return this.enableUserUpdate;
    }

    public void setEnableUserUpdate(boolean enableUserUpdate) {
        this.enableUserUpdate = enableUserUpdate;
    }

    public boolean isLowercaseConvert() {
        return this.lowercaseConvert;
    }

    public void setLowercaseConvert(boolean lowercaseConvert) {
        this.lowercaseConvert = lowercaseConvert;
    }

    public boolean isLowercaseConvertGroups() {
        return this.lowercaseConvertGroups;
    }

    public void setLowercaseConvertGroups(boolean lowercaseConvertGroups) {
        this.lowercaseConvertGroups = lowercaseConvertGroups;
    }

    public boolean isRemoveFromGroups() {
        return this.removeFromGroups;
    }

    public void setRemoveFromGroups(boolean removeFromGroups) {
        this.removeFromGroups = removeFromGroups;
    }

    public boolean isUpdateExisting() {
        return this.updateExisting;
    }

    public void setUpdateExisting(boolean updateExisting) {
        this.updateExisting = updateExisting;
    }

    public String getIssuer() {
        return this.issuer;
    }

    public void setIssuer(String issuer) {
        this.issuer = issuer;
    }

    public String getMetadataurl() {
        return this.metadataurl;
    }

    public void setMetadataurl(String metadataurl) {
        this.metadataurl = metadataurl;
    }

    public boolean isMetadataignorecert() {
        return this.metadataignorecert;
    }

    public void setMetadataignorecert(boolean metadataignorecert) {
        this.metadataignorecert = metadataignorecert;
    }

    public String getMetadataxml() {
        return this.metadataxml;
    }

    public void setMetadataxml(String metadataxml) {
        this.metadataxml = metadataxml;
    }

    public boolean isUseMetadataxml() {
        return this.useMetadataxml;
    }

    public void setUseMetadataxml(boolean useMetadataxml) {
        this.useMetadataxml = useMetadataxml;
    }

    public String getSsoUrl() {
        return this.ssoUrl;
    }

    public String getUseridAttribute() {
        return this.useridAttribute;
    }

    public void setUseridAttribute(String useridAttribute) {
        this.useridAttribute = useridAttribute;
    }

    public String getFullnameAttribute() {
        return this.fullnameAttribute;
    }

    public void setFullnameAttribute(String fullnameAttribute) {
        this.fullnameAttribute = fullnameAttribute;
    }

    public String getEmailAttribute() {
        return this.emailAttribute;
    }

    public void setEmailAttribute(String emailAttribute) {
        this.emailAttribute = emailAttribute;
    }

    public String getGroupAttribute() {
        return this.groupAttribute;
    }

    public void setGroupAttribute(String groupAttribute) {
        this.groupAttribute = groupAttribute;
    }

    public String getGroupsForNewUsers() {
        return this.groupsForNewUsers;
    }

    public List<String> getGroupsForNewUsersList() {
        return Utils.splitString(this.getGroupsForNewUsers());
    }

    public void setGroupsForNewUsers(String groupsForNewUsers) {
        this.groupsForNewUsers = groupsForNewUsers;
    }

    public String getGroupsForNewSdCustomers() {
        return this.groupsForNewSdCustomers;
    }

    public List<String> getGroupsForNewSdCustomersList() {
        return Utils.splitString(this.getGroupsForNewSdCustomers());
    }

    public void setGroupsForNewSdCustomers(String groupsForNewSdCustomers) {
        this.groupsForNewSdCustomers = groupsForNewSdCustomers;
    }

    public Long getDirectoryIdForNewUsers() {
        return this.directoryIdForNewUsers;
    }

    public void setDirectoryIdForNewUsers(Long directoryIdForNewUsers) {
        this.directoryIdForNewUsers = directoryIdForNewUsers;
    }

    public String getEmailDomains() {
        return this.emailDomains;
    }

    public List<String> getEmailDomainsList() {
        return Utils.splitString(this.getEmailDomains());
    }

    public void setEmailDomains(String emailDomains) {
        this.emailDomains = emailDomains;
    }

    @XmlTransient
    public void setSsoUrl(String ssoUrl) {
        this.ssoUrl = ssoUrl;
    }

    @Override
    public V2IdpConfiguration migrateToNewerModelVersion() {
        V2IdpConfiguration migratedIdpConfiguration = new V2IdpConfiguration();
        migratedIdpConfiguration.id = this.getId();
        migratedIdpConfiguration.name = this.getName();
        migratedIdpConfiguration.description = this.getDescription();
        migratedIdpConfiguration.postBindingURL = this.getUrl();
        migratedIdpConfiguration.entityId = this.getIssuer();
        migratedIdpConfiguration.certificate = this.getCertificate();
        migratedIdpConfiguration.secondCertificate = this.getSecondCertificate();
        migratedIdpConfiguration.relayStateParameterName = this.getRelayStateParameterName();
        migratedIdpConfiguration.useridAttribute = this.getUseridAttribute();
        migratedIdpConfiguration.fullnameAttribute = this.getFullnameAttribute();
        migratedIdpConfiguration.emailAttribute = this.getEmailAttribute();
        migratedIdpConfiguration.groupAttribute = this.getGroupAttribute();
        migratedIdpConfiguration.groupsForNewUsers = this.getGroupsForNewUsers();
        migratedIdpConfiguration.groupsForNewSdCustomers = this.getGroupsForNewSdCustomers();
        migratedIdpConfiguration.emailDomains = this.getEmailDomains();
        migratedIdpConfiguration.useridTransformationRegex = this.getUseridTransformationRegex();
        migratedIdpConfiguration.useridTransformationReplacement = this.getUseridTransformationReplacement();
        migratedIdpConfiguration.directoryIdForNewUsers = this.getDirectoryIdForNewUsers();
        migratedIdpConfiguration.removeFromGroups = this.isRemoveFromGroups();
        migratedIdpConfiguration.updateExisting = this.isUpdateExisting();
        migratedIdpConfiguration.enableUserUpdate = this.isEnableUserUpdate();
        migratedIdpConfiguration.lowercaseConvert = this.isLowercaseConvert();
        migratedIdpConfiguration.lowercaseConvertGroups = this.isLowercaseConvertGroups();
        migratedIdpConfiguration.metadataurl = this.getMetadataurl();
        migratedIdpConfiguration.metadataxml = this.getMetadataxml();
        migratedIdpConfiguration.metadataignorecert = this.isMetadataignorecert();
        migratedIdpConfiguration.useMetadataxml = this.isUseMetadataxml();
        Map<String, String> v1IdpAttr = this.getIdpAttributes();
        HashMap<String, String> idpAttr = new HashMap<String, String>();
        for (String key : v1IdpAttr.keySet()) {
            idpAttr.put(key, v1IdpAttr.get(key));
        }
        migratedIdpConfiguration.idpAttributes = idpAttr;
        return migratedIdpConfiguration;
    }
}

