/*
 * Decompiled with CFR 0.152.
 */
package com.resolution.atlasplugins.samlsso.configuration.legacyloader;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.resolution.atlasplugins.samlsso.configuration.legacyloader.V1IdpConfiguration;
import com.resolution.atlasplugins.samlsso.configuration.legacyloader.V2ConfigurationData;
import com.resolution.atlasplugins.samlsso.configuration.legacyloader.VersionedConfigurationData;
import com.resolution.samlwrapper.api.metadata.MetadataInformation;
import com.resolution.samlwrapper.api.metadata.impl.MetadataInformationImpl;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlElementWrapper;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlTransient;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude
public class V1ConfigurationData
implements VersionedConfigurationData {
    @XmlTransient
    public static final int CURRENT_VERSION = 1;
    @XmlTransient
    private static final Logger logger = LoggerFactory.getLogger(V1ConfigurationData.class);
    public String defaultRedirectUrl;
    public boolean overrideLoginUrl;
    public boolean overrideLogoutUrl;
    public String logoutUrl;
    public boolean enableUserForLogin;
    public String userGroupForEnablement;
    public boolean redirectWithPOST = true;
    public boolean enableIdPSelection;
    public String jiraGroups;
    public String licenseString;
    public String useridTransformationRegex;
    public String useridTransformationReplacement;
    public String errorPageTemplate;
    public String loggedOutPageTemplate;
    public String idpSelectionPageTemplate;
    public String idpByEmailPageTemplate;
    public String serviceDeskErrorPageTemplate;
    public boolean enableIdPSelectionByEmailAddress;
    public String groupsToAddUserTo;
    public String nonSsoDestinations;
    public String nonSsoUserAgents;
    public String enforceSsoDestinations;
    public String jiraIssueCollectors;
    public boolean redirectServiceDeskLogin;
    public boolean redirectDashboardUrl;
    public boolean setRememberMeCookie = false;
    public boolean enforceResponseValidityDates = true;
    public boolean enforceResponseIDUniqueness = true;
    public int clockSkew = 60;
    public String licenseMessage;
    public boolean licensed;
    public Map<String, Long> directoryList;
    @XmlElementWrapper(name="idpConfigurations")
    @XmlElement(name="idpConfiguration")
    public List<V1IdpConfiguration> idpConfigurations = new ArrayList<V1IdpConfiguration>();
    public V1IdpConfiguration defaultIdpConfiguration;

    protected static String newLinesToSeparators(String string) {
        if (string == null) {
            return null;
        }
        return string.trim().replaceAll("\n", ",");
    }

    protected static String separatorsToNewLines(String string) {
        if (string == null) {
            return null;
        }
        return string.replace(",", "\n");
    }

    @Override
    public int getVersion() {
        return 1;
    }

    @Override
    public V2ConfigurationData migrateToNewerModelVersion() {
        logger.debug("Migrating ConfigurationData from version 1 to 2.");
        V2ConfigurationData migratedConfigurationData = new V2ConfigurationData();
        migratedConfigurationData.version = 2;
        migratedConfigurationData.defaultRedirectUrl = this.defaultRedirectUrl;
        migratedConfigurationData.overrideLoginUrl = this.overrideLoginUrl;
        migratedConfigurationData.overrideLogoutUrl = this.overrideLogoutUrl;
        migratedConfigurationData.logoutUrl = this.logoutUrl;
        migratedConfigurationData.enableUserForLogin = this.enableUserForLogin;
        migratedConfigurationData.userGroupForEnablement = this.userGroupForEnablement;
        migratedConfigurationData.enableIdPSelection = this.enableIdPSelection;
        migratedConfigurationData.enableIdPSelectionByEmailAddress = this.enableIdPSelectionByEmailAddress;
        migratedConfigurationData.jiraGroups = this.jiraGroups;
        migratedConfigurationData.useridTransformationRegex = this.useridTransformationRegex;
        migratedConfigurationData.useridTransformationReplacement = this.useridTransformationReplacement;
        migratedConfigurationData.errorPageTemplate = this.errorPageTemplate;
        migratedConfigurationData.loggedOutPageTemplate = this.loggedOutPageTemplate;
        migratedConfigurationData.idpSelectionPageTemplate = this.idpSelectionPageTemplate;
        migratedConfigurationData.idpByEmailPageTemplate = this.idpByEmailPageTemplate;
        migratedConfigurationData.serviceDeskErrorPageTemplate = this.serviceDeskErrorPageTemplate;
        migratedConfigurationData.groupsToAddUserTo = this.groupsToAddUserTo;
        migratedConfigurationData.nonSsoDestinations = this.nonSsoDestinations;
        migratedConfigurationData.nonSsoUserAgents = this.nonSsoUserAgents;
        migratedConfigurationData.enforceSsoDestinations = this.enforceSsoDestinations;
        migratedConfigurationData.jiraIssueCollectors = this.jiraIssueCollectors;
        migratedConfigurationData.redirectServiceDeskLogin = this.redirectServiceDeskLogin;
        migratedConfigurationData.setRememberMeCookie = this.setRememberMeCookie;
        migratedConfigurationData.enforceResponseValidityDates = this.enforceResponseValidityDates;
        migratedConfigurationData.enforceResponseIDUniqueness = this.enforceResponseIDUniqueness;
        migratedConfigurationData.clockSkew = this.clockSkew;
        for (V1IdpConfiguration v1 : this.idpConfigurations) {
            migratedConfigurationData.idpConfigurations.add(v1.migrateToNewerModelVersion());
        }
        return migratedConfigurationData;
    }

    @Override
    public MetadataInformation getMetadataInformation() {
        return null;
    }

    @Override
    public void setMetadataInformation(MetadataInformationImpl metadataInformation) {
    }
}

