/*
 * Decompiled with CFR 0.152.
 */
package com.resolution.atlasplugins.samlsso.configuration.frontend;

import com.atlassian.sal.api.user.UserProfile;
import com.resolution.atlasplugins.samlsso.Defaults;
import com.resolution.atlasplugins.samlsso.Platform7Util;
import com.resolution.atlasplugins.samlsso.ReadOnlyModeDetector;
import com.resolution.atlasplugins.samlsso.ResourceLoader;
import com.resolution.atlasplugins.samlsso.SamlSsoService;
import com.resolution.atlasplugins.samlsso.Utils;
import com.resolution.atlasplugins.samlsso.configuration.AnalyticsProvider;
import com.resolution.atlasplugins.samlsso.configuration.ConfigurationData;
import com.resolution.atlasplugins.samlsso.configuration.ConfigurationDataSanitizer;
import com.resolution.atlasplugins.samlsso.configuration.ConfigurationDefaultSetter;
import com.resolution.atlasplugins.samlsso.configuration.IdPType;
import com.resolution.atlasplugins.samlsso.configuration.frontend.AttributeMappingTemplateProviderForMoreProtocols;
import com.resolution.atlasplugins.samlsso.configuration.frontend.SamlSsoBackendState;
import com.resolution.atlasplugins.samlsso.configuration.frontend.SamlSsoFrontendDto;
import com.resolution.atlasplugins.samlsso.configuration.validation.ConfigurationDataValidator;
import com.resolution.atlasplugins.samlsso.oidcandoauth.oauth2.OAuth2SpecificHelpers;
import com.resolution.atlasplugins.samlsso.oidcandoauth.oidc.OidcSpecificHelpers;
import com.resolution.atlasplugins.samlsso.tracker.AuthenticationTracker;
import com.resolution.atlasplugins.samlsso.tracker.AuthenticationTrackerRepository;
import com.resolution.atlasplugins.samlsso.userauth.AuthenticatorDetector;
import com.resolution.samlwrapper.api.PluginProperties;
import com.resolution.samlwrapper.api.SAMLWrapper;
import com.resolution.samlwrapper.api.SAMLWrapperConfiguration;
import com.resolution.samlwrapper.api.SAMLWrapperIdpConfiguration;
import com.resolution.samlwrapper.api.tracker.SAMLAuthenticationTrackerRepository;
import de.resolution.atlascompat.api.AtlasCompatApiFactory;
import de.resolution.atlasuser.api.directory.DirectoryAdapter;
import de.resolution.atlasuser.impl.CrowdApiDirectoryAdapter;
import de.resolution.commons.license.LicenseChecker;
import de.resolution.commons.validate.api.ValidationResult;
import de.resolution.reconfigure.LabelValue;
import de.resolution.reconfigure.OptionGroup;
import de.resolution.reconfigure.PrivilegeChecker;
import de.resolution.reconfigure.api.ConfigurationLoadFailedException;
import de.resolution.reconfigure.api.ConfigurationSaveFailedException;
import de.resolution.reconfigure.api.ConfigurationService;
import de.resolution.reconfigure.api.FrontendDTO;
import de.resolution.reconfigure.frontenddefinition.DynamicFragmentProvider;
import de.resolution.retransform.config.AttributeTransformationConfig;
import de.resolution.retransform.config.Target;
import de.resolution.retransform.frontend.AttributeMappingOptionProvider;
import de.resolution.usersync.api.ConnectorSupportInformation;
import de.resolution.usersync.api.SupportInformationGenerator;
import de.resolution.usersync.api.UserSyncService;
import de.resolution.usersync.frontend.UserSyncFrontendService;
import jakarta.annotation.Nullable;
import jakarta.inject.Inject;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.springframework.stereotype.Component;

@Component
public class SamlSsoConfigurationService
implements ConfigurationService<ConfigurationData> {
    private final SamlSsoService samlSsoService;
    private final LicenseChecker licenseChecker;
    private final ConfigurationDataValidator configurationDataValidator;
    private final ReadOnlyModeDetector readOnlyModeDetector;
    private final AuthenticatorDetector authenticatorDetector;
    private final UserSyncService userSyncService;
    private final DirectoryAdapter directoryAdapter;
    private final AttributeMappingOptionProvider attributeMappingOptionProvider;
    private final AttributeMappingTemplateProviderForMoreProtocols attributeMappingTemplateProvider;
    private final UserSyncFrontendService userSyncFrontendService;
    public static final String NONE_CONNECTOR_NAME = "None";
    public static final String NONE_CONNECTOR_UID = "None";
    private static final List<String> statusFilter = Arrays.asList("NEW", "IN_PROGRESS", "LOGGED_IN", "LOGGED_OUT", "SESSION_PRESENT", "LOGIN_PAGE", "FAILED", "ERROR");
    private static final List<String> samlStatusFilter = Arrays.asList("NEW", "CREATED_REQUEST", "SENT_REQUEST", "RECEIVED_RESPONSE", "PROCESSED_RESPONSE", "ERROR");
    private final AuthenticationTrackerRepository authenticationTrackerRepository;
    private final SupportInformationGenerator supportInformationGenerator;
    private final ConfigurationDefaultSetter configurationDefaultSetter;
    private final ConfigurationDataSanitizer configurationDataSanitizer;
    private final CrowdApiDirectoryAdapter crowdApiDirectoryAdapter;
    private final AnalyticsProvider analyticsProvider;
    private final AtlasCompatApiFactory atlasCompatApiFactory;
    private final Platform7Util platform7Util;

    @Inject
    public SamlSsoConfigurationService(SamlSsoService samlSsoService, LicenseChecker licenseChecker, ConfigurationDataValidator configurationDataValidator, ReadOnlyModeDetector readOnlyModeDetector, AuthenticatorDetector authenticatorDetector, UserSyncService userSyncService, UserSyncFrontendService userSyncFrontendService, DirectoryAdapter directoryAdapter, AttributeMappingOptionProvider attributeMappingOptionProvider, AttributeMappingTemplateProviderForMoreProtocols attributeMappingTemplateProvider, AuthenticationTrackerRepository authenticationTrackerRepository, SupportInformationGenerator supportInformationGenerator, ConfigurationDefaultSetter configurationDefaultSetter, ConfigurationDataSanitizer configurationDataSanitizer, CrowdApiDirectoryAdapter crowdApiDirectoryAdapter, AnalyticsProvider analyticsProvider, AtlasCompatApiFactory atlasCompatApiFactory, Platform7Util platform7Util) {
        this.samlSsoService = samlSsoService;
        this.licenseChecker = licenseChecker;
        this.configurationDataValidator = configurationDataValidator;
        this.readOnlyModeDetector = readOnlyModeDetector;
        this.authenticatorDetector = authenticatorDetector;
        this.userSyncService = userSyncService;
        this.userSyncFrontendService = userSyncFrontendService;
        this.directoryAdapter = directoryAdapter;
        this.attributeMappingOptionProvider = attributeMappingOptionProvider;
        this.attributeMappingTemplateProvider = attributeMappingTemplateProvider;
        this.authenticationTrackerRepository = authenticationTrackerRepository;
        this.supportInformationGenerator = supportInformationGenerator;
        this.configurationDefaultSetter = configurationDefaultSetter;
        this.configurationDataSanitizer = configurationDataSanitizer;
        this.crowdApiDirectoryAdapter = crowdApiDirectoryAdapter;
        this.analyticsProvider = analyticsProvider;
        this.atlasCompatApiFactory = atlasCompatApiFactory;
        this.platform7Util = platform7Util;
    }

    @Override
    public String getPluginFamily() {
        return "samlsso";
    }

    @Override
    public Predicate<UserProfile> getRequiredPrivilege(PrivilegeChecker.PrivilegeFactory privilegeFactory, PrivilegeChecker.AccessMode accessMode, String uipath) {
        return privilegeFactory.isSysadmin();
    }

    private List<OptionGroup<String>> buildIdpListForFrontend(List<IdPType> idps) {
        ArrayList<OptionGroup<String>> ret = new ArrayList<OptionGroup<String>>();
        idps.stream().map(IdPType::deployment).distinct().forEach(deployment -> {
            List options = Arrays.stream(IdPType.values()).filter(idps::contains).filter(idpType -> idpType.deployment() == deployment).map(idpType -> new LabelValue<String>(idpType.label(), idpType.name())).collect(Collectors.toList());
            ret.add(new OptionGroup(deployment.label(), options));
        });
        return ret;
    }

    private List<OptionGroup<String>> createIdPTypeList() {
        List<IdPType> idps = Arrays.stream(IdPType.values()).collect(Collectors.toList());
        return this.buildIdpListForFrontend(idps);
    }

    @Override
    public FrontendDTO<ConfigurationData> getFrontendDTO(HttpServletRequest httpServletRequest, UserProfile userProfile, String uipath) throws ConfigurationLoadFailedException {
        String wizardInfosJson;
        ConfigurationData configurationData = this.samlSsoService.getRunningConfiguration().getConfigurationData();
        ValidationResult validationResult = this.configurationDataValidator.validate(configurationData, null);
        this.authenticatorDetector.isCrowdAuthenticator();
        this.authenticatorDetector.isDenyPasswordAuthenticator();
        List<LabelValue<Long>> directories = this.directoryAdapter.getDirectories().stream().filter(dir -> dir.isActive() && !dir.isAtlasUser() && dir.isWritable()).map(directory -> new LabelValue<Long>(directory.getName(), directory.getId())).collect(Collectors.toList());
        String pluginVersion = PluginProperties.get((String)"pluginVersion");
        if (pluginVersion.contains("-")) {
            pluginVersion = pluginVersion.substring(0, pluginVersion.indexOf(45));
        }
        HashMap<String, Object> miscInfos = new HashMap<String, Object>();
        miscInfos.put("pluginMetadataUrl", this.samlSsoService.getAbsoluteSsoURL() + "/metadata");
        miscInfos.put("pluginEndpointUrl", this.samlSsoService.getAbsoluteSsoURL());
        miscInfos.put("pluginServiceProviderCertificatePemUrl", this.samlSsoService.getAbsoluteSsoURL() + "/spcert");
        miscInfos.put("oidcServletUrl", OidcSpecificHelpers.getFullPathToOidcServlet(this.samlSsoService.getAbsoluteBaseUrl()));
        miscInfos.put("oau2ServletUrl", OAuth2SpecificHelpers.getFullPathToOAuth2Servlet(this.samlSsoService.getAbsoluteBaseUrl()));
        try {
            wizardInfosJson = ResourceLoader.load("data/wizardInfos.json");
        }
        catch (ResourceLoader.LoadingFailedException e) {
            throw new ConfigurationLoadFailedException("Loading data/wizardInfos.json failed", e);
        }
        SamlSsoBackendState backendState = new SamlSsoBackendState(this.readOnlyModeDetector.isReadOnlyMode(), this.authenticatorDetector.isCrowdAuthenticator(), this.authenticatorDetector.isDenyPasswordAuthenticator(), directories, pluginVersion, miscInfos, wizardInfosJson, this.attributeMappingOptionProvider.getOptions(), this.attributeMappingTemplateProvider.getTemplatesForAllProtocols(), this.samlSsoService.getAbsoluteNoSsoUrl(), this.userSyncFrontendService.getConnectorDescriptions(), this.platform7Util.isUpdatingCookiesRestricted());
        HashMap<String, Object> selectionLists = new HashMap<String, Object>();
        selectionLists.put("connectors", this.createConnectorList());
        selectionLists.put("authnContextComparisonType", Arrays.stream(SAMLWrapperIdpConfiguration.AuthnContextComparisonType.values()).collect(Collectors.toMap(String::valueOf, value -> value)));
        selectionLists.put("nameIdFormat", Arrays.stream(SAMLWrapper.NameIdFormat.values()).collect(Collectors.toMap(String::valueOf, value -> value)));
        selectionLists.put("protocolBinding", Arrays.stream(SAMLWrapper.ProtocolBindingOfResponse.values()).collect(Collectors.toMap(String::valueOf, value -> value)));
        ArrayList<LabelValue<SAMLWrapperConfiguration.TrueFalseNone>> trueFalseNone = new ArrayList<LabelValue<SAMLWrapperConfiguration.TrueFalseNone>>();
        trueFalseNone.add(new LabelValue<SAMLWrapperConfiguration.TrueFalseNone>("true", SAMLWrapperConfiguration.TrueFalseNone.TRUE));
        trueFalseNone.add(new LabelValue<SAMLWrapperConfiguration.TrueFalseNone>("false", SAMLWrapperConfiguration.TrueFalseNone.FALSE));
        trueFalseNone.add(new LabelValue<SAMLWrapperConfiguration.TrueFalseNone>("don't include", SAMLWrapperConfiguration.TrueFalseNone.NONE));
        selectionLists.put("trueFalseNone", trueFalseNone);
        selectionLists.put("allIdpTypes", this.createIdPTypeList());
        EnumMap idpsWithSupportedProtocols = new EnumMap(IdPType.class);
        Arrays.stream(IdPType.values()).forEach(idpType -> idpsWithSupportedProtocols.put((IdPType)((Object)idpType), idpType.protocol()));
        selectionLists.put("idpsWithSupportedProtocols", idpsWithSupportedProtocols);
        selectionLists.put("contactType", Arrays.asList("other", "technical", "administrative", "support", "billing"));
        ArrayList portalIdsAndNames = new ArrayList();
        this.atlasCompatApiFactory.getJiraServiceDeskApi().ifPresent(api -> api.getPortalIdsAndNames().forEach((id, name) -> portalIdsAndNames.add(new LabelValue<String>((String)name, String.valueOf(id)))));
        selectionLists.put("portalIdsAndNames", portalIdsAndNames);
        HashMap<String, Object> defaults = new HashMap<String, Object>();
        defaults.put("idpSelectionPageTemplate", Defaults.DEFAULT_IDPSELECTIONPAGETEMPLATE);
        defaults.put("idpByEmailPageTemplate", Defaults.DEFAULT_IDP_BY_EMAIL_PAGETEMPLATE);
        defaults.put("idpByEmailPageJavaScript", Defaults.DEFAULT_IDP_BY_EMAIL_JAVASCRIPT);
        defaults.put("errorPageTemplate", Defaults.DEFAULT_ERRORPAGETEMPLATE);
        defaults.put("serviceDeskErrorPageTemplate", Defaults.DEFAULT_SERVICEDESK_ERRORPAGETEMPLATE);
        defaults.put("loggedInPageTemplate", Defaults.DEFAULT_LOGGEDINPAGETEMPLATE);
        defaults.put("loggedOutPageTemplate", Defaults.DEFAULT_LOGGEDOUTPAGETEMPLATE);
        defaults.put("idpButtonsPageTemplate", Defaults.DEFAULT_IDP_BUTTONS_PAGETEMPLATE);
        defaults.put("entityId", this.samlSsoService.getRunningConfiguration().getDefaultEntityId());
        defaults.put("enforceSsoUrls", this.samlSsoService.getRunningConfiguration().getDefaultEnforceSsoUrls());
        defaults.put("nonSsoUrls", this.samlSsoService.getRunningConfiguration().getDefaultNonSsoUrls());
        defaults.put("nonSsoUserAgents", this.samlSsoService.getRunningConfiguration().getDefaultNonSsoUserAgents());
        defaults.put("defaultRedirectUrl", "/");
        defaults.put("responseIdStorageIntervalInHours", 48);
        defaults.put("trackerCleanupInterval", 60);
        defaults.put("trackerCleanupCronExpression", "0 0 * * * ?");
        defaults.put("metadataReloadInterval", 1440);
        defaults.put("idpNameFromMetadataExpression", "md.data\n    ?.'md:EntityDescriptor'?._value\n    ?.'md:IDPSSODescriptor'?._value\n    ?.'md:Extensions'\n    ?.'mdui:UIInfo'?._value\n    ?.'mdui:DisplayName'?._value\n    ?.getAt(0)\n    ?: \"IdP $id\"");
        defaults.put("statusFilter", statusFilter);
        defaults.put("samlStatusFilter", samlStatusFilter);
        defaults.put("userIdDefaultAttribute", AttributeTransformationConfig.create((String)"ATTR_NAMEID", (Target.Type)Target.Type.SYSTEM, (String)"ATTR_NAME"));
        defaults.put("sessionCookieName", this.configurationDefaultSetter.getSessionIdCookieName());
        defaults.put("oidcJwksCacheExpiresInMinutes", 10L);
        defaults.put("oidcJwksCacheSize", 5L);
        defaults.put("redirectCheckerBlockedStrings", Defaults.DEFAULT_ILLEGAL_REDIRECT_STRINGS);
        HashMap<String, Serializable> ssoFrontendStateNamespace = new HashMap<String, Serializable>();
        ssoFrontendStateNamespace.put("newIdpType", null);
        HashMap<String, Object> filters = new HashMap<String, Object>();
        filters.put("statusFilter", null);
        filters.put("samlStatusFilter", null);
        filters.put("fromCreated", null);
        filters.put("fromLastModified", null);
        HashMap<String, Object> trackerTable = new HashMap<String, Object>();
        trackerTable.put("trackerTableResponse", null);
        trackerTable.put("trackerTableLimit", "10");
        trackerTable.put("trackerTableQueryString", new HashMap());
        trackerTable.put("filters", filters);
        ssoFrontendStateNamespace.put("trackerTable", trackerTable);
        ssoFrontendStateNamespace.put("idpIdForNewTracker", Integer.valueOf(-1));
        HashMap idpTypesPretty = new HashMap();
        Arrays.stream(IdPType.values()).forEach(value -> {
            if (value.equals((Object)IdPType.OTHER)) {
                idpTypesPretty.put(value.toString(), "IdP");
            } else {
                idpTypesPretty.put(value.toString(), value.label());
            }
        });
        ssoFrontendStateNamespace.put("idpTypesPretty", idpTypesPretty);
        HashMap<String, Object> frontendState = new HashMap<String, Object>();
        frontendState.put("sso", ssoFrontendStateNamespace);
        this.userSyncFrontendService.addUserSyncFrontendState(frontendState);
        return new SamlSsoFrontendDto(configurationData, this.licenseChecker.checkLicense(), validationResult, backendState, selectionLists, defaults, frontendState);
    }

    @Override
    public ValidationResult validate(ConfigurationData configurationData, String uipath) {
        return this.configurationDataValidator.validate(configurationData, null);
    }

    @Override
    public ConfigurationData update(ConfigurationData configurationData, ValidationResult validationResult, String uipath, UserProfile userProfile) throws ConfigurationSaveFailedException {
        this.samlSsoService.getRunningConfiguration().update(configurationData);
        return this.samlSsoService.getRunningConfiguration().getConfigurationData();
    }

    @Override
    public ConfigurationData getConfiguration(HttpServletRequest request, UserProfile userProfile, String uiPath) {
        return this.samlSsoService.getRunningConfiguration().getConfigurationData();
    }

    public Map<String, String> createConnectorList() {
        Map availableConnectorNamesAndIds = Utils.asMap(this.userSyncService.getAvailableConnectorNamesAndUniqueIds());
        HashMap<String, String> ret = new HashMap<String, String>(availableConnectorNamesAndIds);
        ret.put("None", "None");
        return ret;
    }

    @Override
    public DynamicFragmentProvider getDynamicFragmentProvider() {
        return this.userSyncFrontendService.getDynamicFrontendProvider();
    }

    @Override
    @Nullable
    public ValidationResult validateFrontendStateFragment(String jsonString, String uiPath, String frontendStatePath) throws IOException {
        return this.userSyncFrontendService.validateFrontendStateFragment(jsonString, uiPath, frontendStatePath);
    }

    @Override
    public Map<String, Object> getSupportInformation(HttpServletRequest request, UserProfile userProfile, String uiPath, Map<String, Object> supportInformation, List<String> trackerIds) {
        if (supportInformation == null) {
            supportInformation = new HashMap<String, Object>();
        }
        if (trackerIds != null && !trackerIds.isEmpty()) {
            ArrayList trackers = new ArrayList();
            trackerIds.forEach(id -> {
                AuthenticationTracker tracker = (AuthenticationTracker)this.authenticationTrackerRepository.get((String)id, false);
                if (tracker != null) {
                    trackers.add(tracker);
                }
            });
            supportInformation.put("authenticationTrackers", trackers);
        }
        List<AuthenticationTracker> lastFiftyTrackers = this.authenticationTrackerRepository.find(0L, System.currentTimeMillis(), 0L, 0L, null, null, SAMLAuthenticationTrackerRepository.OrderBy.CREATED, 0, 50, true, null);
        supportInformation.put("lastFiftyTrackers", lastFiftyTrackers.stream().map(trk -> Utils.reduceTracker(trk, this.samlSsoService.getAbsoluteBaseUrl())).collect(Collectors.toList()));
        List<ConnectorSupportInformation> connectorSupportInformation = this.supportInformationGenerator.generate(true);
        ConfigurationData configData = this.samlSsoService.getRunningConfiguration().getConfigurationData();
        ConfigurationData configDataWithoutDefaults = this.configurationDefaultSetter.clearDefaults(configData);
        this.configurationDataSanitizer.sanitize(configDataWithoutDefaults);
        supportInformation.put("samlConfiguration", configDataWithoutDefaults);
        supportInformation.put("authenticatorClass", this.authenticatorDetector.getAuthenticatorClass());
        supportInformation.put("userSyncConfiguration", connectorSupportInformation);
        supportInformation.put("directories", this.crowdApiDirectoryAdapter.getDirectoriesForSupportInformation());
        return supportInformation;
    }

    @Override
    public int getAnalyticsConsentLevel() throws ConfigurationLoadFailedException {
        return this.samlSsoService.getRunningConfiguration().getAnalyticsConsentLevel();
    }

    @Override
    public Map<String, Object> getAnalyticsData(int consentLevel) throws ConfigurationLoadFailedException {
        return this.analyticsProvider.createAnalyticsData(consentLevel);
    }

    @Override
    public boolean isWebSudoRequired(PrivilegeChecker.AccessMode accessMode, HttpServletRequest request, UserProfile userProfile, String uiPath) {
        return true;
    }
}

