/*
 * Decompiled with CFR 0.152.
 */
package com.resolution.atlasplugins.samlsso.configuration;

import com.atlassian.confluence.compat.api.service.accessmode.ReadOnlyAccessAllowed;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.resolution.atlasplugins.samlsso.Utils;
import com.resolution.atlasplugins.samlsso.configuration.ConfigurationData;
import com.resolution.atlasplugins.samlsso.configuration.ConfigurationLoadException;
import com.resolution.atlasplugins.samlsso.configuration.JsonConfigurationLoader;
import com.resolution.atlasplugins.samlsso.configuration.RunningConfiguration;
import com.resolution.atlasplugins.samlsso.configuration.validation.ConfigurationDataValidator;
import de.resolution.commons.util.JSONUtil;
import de.resolution.commons.validate.api.ValidationResult;
import de.resolution.commons.validate.api.Validator;
import de.resolution.reconfigure.InsufficientUserPrivilegeException;
import de.resolution.reconfigure.PrivilegeChecker;
import de.resolution.usersync.builtin.scim.rest.PATCH;
import jakarta.inject.Inject;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Path(value="/")
@Component
public class PluginConfigurationRestResource {
    private static final Logger logger = LoggerFactory.getLogger(PluginConfigurationRestResource.class);
    private static final String MSG_UPDATE_FAILED = "Updating configuration failed, check logfiles for more details";
    private final TransactionTemplate transactionTemplate;
    private final RunningConfiguration runningConfiguration;
    private final Validator<ConfigurationData, Void> configurationDataValidator;
    private final JsonConfigurationLoader jsonConfigurationLoader;
    private final PrivilegeChecker privilegeChecker;

    @Inject
    public PluginConfigurationRestResource(RunningConfiguration runningConfiguration, PrivilegeChecker privilegeChecker, JsonConfigurationLoader jsonConfigurationLoader, ConfigurationDataValidator configurationDataValidator, @ComponentImport TransactionTemplate transactionTemplate) {
        logger.debug("Constructing PluginConfigurationRestResource");
        this.runningConfiguration = runningConfiguration;
        this.jsonConfigurationLoader = jsonConfigurationLoader;
        this.privilegeChecker = privilegeChecker;
        this.transactionTemplate = transactionTemplate;
        this.configurationDataValidator = configurationDataValidator;
    }

    @GET
    @Path(value="config")
    @Produces(value={"application/json"})
    public Response getConfig(@Context HttpServletRequest request) throws InsufficientUserPrivilegeException, JsonProcessingException {
        this.privilegeChecker.checkSysAdmin(request);
        return Response.ok((Object)Utils.asJson(this.transactionTemplate.execute(this.runningConfiguration::getConfigurationData))).cacheControl(Utils.ccNoCache).build();
    }

    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ReadOnlyAccessAllowed
    @Path(value="config")
    public Response updateConfig(String configJsonString, @Context HttpServletRequest request) throws InsufficientUserPrivilegeException, JsonProcessingException {
        ConfigurationData config;
        this.privilegeChecker.checkSysAdmin(request);
        try {
            config = this.jsonConfigurationLoader.load(configJsonString, this.runningConfiguration.getHostProduct());
        }
        catch (ConfigurationLoadException e) {
            if (logger.isErrorEnabled()) {
                logger.error("Parsing configuration from JSON failed: ", (Throwable)e);
            }
            return Response.serverError().entity(Utils.createMessageForJson("Parsing configuration failed: " + e.getMessage())).cacheControl(Utils.ccNoCache).build();
        }
        if (config.version != 15) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity(Utils.createMessageForJson("Updating configuration failed, the configuration version does not correspond to the current version \" + ConfigurationData.CURRENT_VERSION")).cacheControl(Utils.ccNoCache).build();
        }
        ValidationResult validationResult = this.configurationDataValidator.validate((Object)config, null);
        if (!validationResult.isValid()) {
            if (logger.isErrorEnabled()) {
                logger.error("Configuration data is not valid: {}", (Object)validationResult);
            }
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)Utils.asJson(validationResult)).cacheControl(Utils.ccNoCache).build();
        }
        Boolean updateResult = (Boolean)this.transactionTemplate.execute(() -> this.runningConfiguration.update(config));
        if (Boolean.TRUE.equals(updateResult)) {
            return Response.noContent().cacheControl(Utils.ccNoCache).build();
        }
        logger.error(MSG_UPDATE_FAILED);
        return Response.serverError().cacheControl(Utils.ccNoCache).entity(Utils.createMessageForJson(MSG_UPDATE_FAILED)).build();
    }

    @DELETE
    @ReadOnlyAccessAllowed
    @Path(value="/config")
    public Response deleteConfig(@Context HttpServletRequest request) throws InsufficientUserPrivilegeException {
        this.privilegeChecker.checkSysAdmin(request);
        logger.warn("received a DELETE-request");
        this.runningConfiguration.clear();
        return Response.noContent().cacheControl(Utils.ccNoCache).build();
    }

    @PATCH
    @Consumes(value={"application/json", "application/merge-patch+json", "application/json-patch+json"})
    @Produces(value={"application/json"})
    @ReadOnlyAccessAllowed
    @Path(value="/config")
    public Response patchConfig(String patchForConfigurationJson, @Context HttpServletRequest request) throws InsufficientUserPrivilegeException {
        JsonNode patchedJson;
        this.privilegeChecker.checkSysAdmin(request);
        if (patchForConfigurationJson == null || patchForConfigurationJson.isEmpty()) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"{ \"message\" : \"configuration patch must not be null or empty\" }").cacheControl(Utils.ccNoCache).build();
        }
        JsonNode existingConfigurationJson = JSONUtil.asJsonNode((Object)this.runningConfiguration.getConfigurationData());
        String contentType = request.getContentType();
        try {
            patchedJson = contentType != null && contentType.contains("application/json-patch+json") ? JSONUtil.applyPatch((JsonNode)existingConfigurationJson, (JsonNode)JSONUtil.asJsonNode((String)patchForConfigurationJson)) : JSONUtil.applyMergePatch((JsonNode)existingConfigurationJson, (JsonNode)JSONUtil.asJsonNode((String)patchForConfigurationJson));
        }
        catch (JSONUtil.JsonPatchFailedException e) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("{ \"message\" : \"Patch failed:" + e.getMessage() + "\"}")).build();
        }
        if (existingConfigurationJson.equals((Object)patchedJson)) {
            return Response.status((Response.Status)Response.Status.NOT_MODIFIED).build();
        }
        ConfigurationData patchedConfig = (ConfigurationData)JSONUtil.fromJson((JsonNode)patchedJson, ConfigurationData.class);
        ValidationResult validationResult = this.configurationDataValidator.validate((Object)patchedConfig, null);
        if (!validationResult.isValid()) {
            if (logger.isErrorEnabled()) {
                logger.error("Configuration data is not valid: {}", (Object)validationResult);
            }
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)JSONUtil.asJson((Object)validationResult)).cacheControl(Utils.ccNoCache).build();
        }
        Boolean updateResult = (Boolean)this.transactionTemplate.execute(() -> this.runningConfiguration.update(patchedConfig));
        if (Boolean.TRUE.equals(updateResult)) {
            return Response.ok((Object)JSONUtil.asJson((Object)this.runningConfiguration.getConfigurationData())).cacheControl(Utils.ccNoCache).build();
        }
        logger.error(MSG_UPDATE_FAILED);
        return Response.serverError().cacheControl(Utils.ccNoCache).entity(Utils.createMessageForJson(MSG_UPDATE_FAILED)).build();
    }
}

