/*
 * Decompiled with CFR 0.152.
 */
package com.resolution.atlasplugins.samlsso.configuration;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.resolution.atlasplugins.samlsso.Utils;
import com.resolution.atlasplugins.samlsso.configuration.CommonIdpConfigurationData;
import com.resolution.atlasplugins.samlsso.configuration.ConfigurationData;
import com.resolution.atlasplugins.samlsso.configuration.IdPType;
import com.resolution.atlasplugins.samlsso.configuration.NewIdpConfigurationProvider;
import com.resolution.atlasplugins.samlsso.configuration.ProtocolType;
import de.resolution.reconfigure.InsufficientUserPrivilegeException;
import de.resolution.reconfigure.PrivilegeChecker;
import jakarta.inject.Inject;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import org.springframework.stereotype.Component;

@Component
@Path(value="/newidp")
public class NewIdpResource {
    private final NewIdpConfigurationProvider newIdpConfigurationProvider;
    private final PrivilegeChecker privilegeChecker;
    private final ObjectMapper objectMapper = new ObjectMapper();

    @Inject
    public NewIdpResource(NewIdpConfigurationProvider newIdpConfigurationProvider, PrivilegeChecker privilegeChecker) {
        this.newIdpConfigurationProvider = newIdpConfigurationProvider;
        this.privilegeChecker = privilegeChecker;
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response createNewIdP(String newIdPInformationString, @Context HttpServletRequest request) throws InsufficientUserPrivilegeException, IOException {
        this.privilegeChecker.checkSysAdmin(request);
        NewIdPInformation newIdPInformation = (NewIdPInformation)this.objectMapper.readValue(newIdPInformationString, NewIdPInformation.class);
        ConfigurationData configurationData = newIdPInformation.currentConfigurationData;
        if (configurationData == null || newIdPInformation.protocolType == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        CommonIdpConfigurationData newIdpConfig = null;
        IdPType idpType = newIdPInformation.idpType == null ? IdPType.OTHER : newIdPInformation.idpType;
        int maxId = configurationData.idpConfigurations.stream().mapToInt(idp -> idp.id).max().orElse(0);
        int maxWeight = configurationData.idpConfigurations.stream().mapToInt(idp -> idp.weight).max().orElse(0);
        newIdpConfig = this.newIdpConfigurationProvider.createNewIdPConfiguration(newIdPInformation.protocolType, idpType, maxId + 1, maxWeight + 10);
        return Response.ok().entity((Object)Utils.asJson(newIdpConfig)).build();
    }

    public static class NewIdPInformation {
        public ConfigurationData currentConfigurationData;
        public IdPType idpType;
        public ProtocolType protocolType;
    }
}

