/*
 * Decompiled with CFR 0.152.
 */
package com.resolution.atlasplugins.samlsso.configuration;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.resolution.atlasplugins.samlsso.ResourceLoader;
import com.resolution.atlasplugins.samlsso.SAMLSSORuntimeException;
import com.resolution.atlasplugins.samlsso.configuration.CommonIdpConfigurationData;
import com.resolution.atlasplugins.samlsso.configuration.ConfigurationDefaultSetter;
import com.resolution.atlasplugins.samlsso.configuration.IdPType;
import com.resolution.atlasplugins.samlsso.configuration.ProtocolType;
import com.resolution.atlasplugins.samlsso.configuration.SamlIdpConfigurationData;
import com.resolution.atlasplugins.samlsso.configuration.oauth.OAuth2IdpConfigurationData;
import com.resolution.atlasplugins.samlsso.configuration.oidc.OidcIdpConfigurationData;
import jakarta.inject.Inject;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class NewIdpConfigurationProvider {
    private static final Logger logger = LoggerFactory.getLogger(NewIdpConfigurationProvider.class);
    private final ConfigurationDefaultSetter configurationDefaultSetter;
    private final ObjectMapper objectMapper = new ObjectMapper();
    public static final String DUMMY_SAML_IDP_ENTITY_ID = "setEntityIdHere";
    public static final String DUMMY_SAML_IDP_POST_BINDING_URL = "https://setPOSTBindingURLhere";

    @Inject
    public NewIdpConfigurationProvider(ConfigurationDefaultSetter configurationDefaultSetter) {
        this.configurationDefaultSetter = configurationDefaultSetter;
    }

    public CommonIdpConfigurationData createNewIdPConfiguration(ProtocolType protocolType, IdPType idPType, int id, int weight) {
        Object filename = "data/idpDefaults/" + protocolType.name() + "/" + idPType.name() + ".json";
        logger.debug("Looking for {}", filename);
        if (!ResourceLoader.exists((String)filename)) {
            logger.debug("Could not find {}, loading default json", filename);
            if (protocolType == ProtocolType.SAML) {
                filename = "data/idpDefaults/SAML/defaults.json";
            } else if (protocolType == ProtocolType.OIDC) {
                filename = "data/idpDefaults/OIDC/defaults.json";
            } else if (protocolType == ProtocolType.OAU2) {
                filename = "data/idpDefaults/OAU2/defaults.json";
            }
            logger.debug("Default json path {}", filename);
        }
        String jsonString = ResourceLoader.load((String)filename);
        CommonIdpConfigurationData idpConfiguration = null;
        if (protocolType == ProtocolType.SAML) {
            try {
                idpConfiguration = (CommonIdpConfigurationData)this.objectMapper.readValue(jsonString, SamlIdpConfigurationData.class);
                SamlIdpConfigurationData samlIdpConfiguration = (SamlIdpConfigurationData)idpConfiguration;
                this.configurationDefaultSetter.addSamlDefaults(samlIdpConfiguration);
                samlIdpConfiguration.postBindingURL = DUMMY_SAML_IDP_POST_BINDING_URL + id;
                samlIdpConfiguration.idpId = DUMMY_SAML_IDP_ENTITY_ID + id;
            }
            catch (IOException e) {
                throw new LoadDefaultJsonFailedException((String)filename, e);
            }
        } else if (protocolType == ProtocolType.OIDC) {
            try {
                idpConfiguration = (CommonIdpConfigurationData)this.objectMapper.readValue(jsonString, OidcIdpConfigurationData.class);
                this.configurationDefaultSetter.addOidcAndOAuthDefaults((OidcIdpConfigurationData)idpConfiguration);
            }
            catch (IOException e) {
                throw new LoadDefaultJsonFailedException((String)filename, e);
            }
        } else if (protocolType == ProtocolType.OAU2) {
            try {
                idpConfiguration = (CommonIdpConfigurationData)this.objectMapper.readValue(jsonString, OAuth2IdpConfigurationData.class);
                this.configurationDefaultSetter.addOidcAndOAuthDefaults((OAuth2IdpConfigurationData)idpConfiguration);
            }
            catch (IOException e) {
                throw new LoadDefaultJsonFailedException((String)filename, e);
            }
        } else {
            logger.error("Did not find known IdP type. Found {} instead", (Object)protocolType);
            return null;
        }
        idpConfiguration.id = id;
        idpConfiguration.weight = weight;
        idpConfiguration.idpType = idPType;
        return idpConfiguration;
    }

    public static class LoadDefaultJsonFailedException
    extends SAMLSSORuntimeException {
        public LoadDefaultJsonFailedException(String filename, Throwable cause) {
            super("Loading default IdPConfiguration from JSON " + filename + " failed", cause);
        }
    }
}

