/*
 * Decompiled with CFR 0.152.
 */
package com.resolution.atlasplugins.samlsso.configuration;

import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.resolution.atlasplugins.samlsso.HostProduct;
import com.resolution.atlasplugins.samlsso.configuration.ConfigurationData;
import com.resolution.atlasplugins.samlsso.configuration.ConfigurationLoadException;
import com.resolution.atlasplugins.samlsso.configuration.ConfigurationLoader;
import com.resolution.atlasplugins.samlsso.configuration.ConfigurationMigrationException;
import com.resolution.atlasplugins.samlsso.configuration.IdPType;
import com.resolution.atlasplugins.samlsso.configuration.ProtocolType;
import com.resolution.atlasplugins.samlsso.userauth.AuthenticationAttribute;
import com.resolution.samlwrapper.api.SAMLWrapper;
import de.resolution.commons.util.boundedregex.RegexAndReplacement;
import de.resolution.retransform.config.AttributeTransformationConfig;
import de.resolution.retransform.config.Source;
import de.resolution.retransform.config.Target;
import de.resolution.retransform.config.Transformations;
import de.resolution.usersync.api.UserSyncService;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.inject.Inject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@ExportAsService(value={ConfigurationLoader.class})
public class JsonConfigurationLoader
implements ConfigurationLoader {
    private static final Logger logger = LoggerFactory.getLogger(JsonConfigurationLoader.class);
    private static final String KEY_VERSION = "version";
    public static final String NON_SSO_DESTINATIONS = "nonSsoDestinations";
    public static final String DENY_MESSAGES_SIGNED_WITH_EXPIRED_CERTIFICATES = "denyMessagesSignedWithExpiredCertificates";
    private final ObjectMapper objectMapper = new ObjectMapper();
    private final UserSyncService userSyncService;

    @Inject
    public JsonConfigurationLoader(UserSyncService userSyncService) {
        this.userSyncService = userSyncService;
    }

    @Override
    public ConfigurationData load(@Nonnull String jsonData, @Nonnull HostProduct hostProduct) throws ConfigurationLoadException {
        try {
            JsonNode effectiveJsonNode = this.loadEffectiveJsonNode(jsonData);
            this.migrate(effectiveJsonNode, hostProduct);
            return this.getConfigurationData(effectiveJsonNode);
        }
        catch (IOException e) {
            throw new ConfigurationLoadException("Loading JSON-configuration failed", e);
        }
    }

    public ConfigurationData getConfigurationData(JsonNode effectiveJsonNode) throws JsonProcessingException {
        return (ConfigurationData)this.objectMapper.treeToValue((TreeNode)effectiveJsonNode, ConfigurationData.class);
    }

    public JsonNode loadEffectiveJsonNode(String jsonData) throws IOException {
        JsonNode effectiveJsonNode;
        JsonNode jsonNode = this.objectMapper.readTree(jsonData);
        if (jsonNode.has("configurationData")) {
            logger.debug("Data has a child node 'configurationData', using the data from there.");
            effectiveJsonNode = jsonNode.get("configurationData");
        } else if (jsonNode.has("samlConfiguration")) {
            logger.debug("Data has a child node 'samlConfiguration', using the data from there.");
            effectiveJsonNode = jsonNode.get("samlConfiguration");
        } else {
            effectiveJsonNode = jsonNode;
        }
        return effectiveJsonNode;
    }

    private void migrate(JsonNode jsonNode, HostProduct hostProduct) throws ConfigurationMigrationException {
        ObjectNode objectNode = JsonConfigurationLoader.asObjectNode(jsonNode);
        int configVersion = JsonConfigurationLoader.readVersion((JsonNode)objectNode);
        if (configVersion == 15) {
            logger.debug("JSON configuration version {} is up to date, no need to migrate", (Object)configVersion);
        } else if (configVersion == 7) {
            JsonConfigurationLoader.migrateV7toV8(objectNode);
            JsonConfigurationLoader.migrateV8toV9(objectNode, hostProduct);
            this.migrateV9toV10(objectNode, hostProduct);
            this.migrateV10toV11(objectNode, hostProduct);
            this.migrateV11toV12(objectNode, hostProduct);
            this.migrateV12toV13(objectNode, hostProduct);
            this.migrateV13toV14(objectNode, hostProduct);
            this.migrateV14toV15(objectNode, hostProduct);
        } else if (configVersion == 8) {
            JsonConfigurationLoader.migrateV8toV9(objectNode, hostProduct);
            this.migrateV9toV10(objectNode, hostProduct);
            this.migrateV10toV11(objectNode, hostProduct);
            this.migrateV11toV12(objectNode, hostProduct);
            this.migrateV12toV13(objectNode, hostProduct);
            this.migrateV13toV14(objectNode, hostProduct);
            this.migrateV14toV15(objectNode, hostProduct);
        } else if (configVersion == 9) {
            this.migrateV9toV10(objectNode, hostProduct);
            this.migrateV10toV11(objectNode, hostProduct);
            this.migrateV11toV12(objectNode, hostProduct);
            this.migrateV12toV13(objectNode, hostProduct);
            this.migrateV13toV14(objectNode, hostProduct);
            this.migrateV14toV15(objectNode, hostProduct);
        } else if (configVersion == 10) {
            this.migrateV10toV11(objectNode, hostProduct);
            this.migrateV11toV12(objectNode, hostProduct);
            this.migrateV12toV13(objectNode, hostProduct);
            this.migrateV13toV14(objectNode, hostProduct);
            this.migrateV14toV15(objectNode, hostProduct);
        } else if (configVersion == 11) {
            this.migrateV11toV12(objectNode, hostProduct);
            this.migrateV12toV13(objectNode, hostProduct);
            this.migrateV13toV14(objectNode, hostProduct);
            this.migrateV14toV15(objectNode, hostProduct);
        } else if (configVersion == 12) {
            this.migrateV12toV13(objectNode, hostProduct);
            this.migrateV13toV14(objectNode, hostProduct);
            this.migrateV14toV15(objectNode, hostProduct);
        } else if (configVersion == 13) {
            this.migrateV13toV14(objectNode, hostProduct);
            this.migrateV14toV15(objectNode, hostProduct);
        } else if (configVersion == 14) {
            this.migrateV14toV15(objectNode, hostProduct);
        } else {
            throw new ConfigurationMigrationException("Unsupported JSON configuration version " + configVersion);
        }
    }

    @Nullable
    public AttributeTransformationConfig createAttributeTransformationConfig(JsonNode fieldNameNode, String defaultIfNull, JsonNode transformationsNode, Target target, boolean toLowerCase) {
        return this.createAttributeTransformationConfig(fieldNameNode, defaultIfNull, transformationsNode, target, toLowerCase, Transformations.DropOption.NONE);
    }

    AttributeTransformationConfig createAttributeTransformationConfig(JsonNode fieldNameNode, String defaultIfNull, JsonNode transformationsNode, Target target, boolean toLowerCase, Transformations.DropOption option) {
        String fieldName;
        if (fieldNameNode == null || fieldNameNode.isNull() || fieldNameNode.asText() == null || fieldNameNode.asText().trim().isEmpty()) {
            if (defaultIfNull == null) {
                return null;
            }
            fieldName = defaultIfNull;
        } else {
            fieldName = fieldNameNode.asText();
        }
        Source source = fieldName.contains("{") ? Source.createFieldCombiner((String)fieldName) : Source.createSingle((String)fieldName);
        if (transformationsNode != null) {
            try {
                List useridTransformationRegex = (List)this.objectMapper.readValue(transformationsNode.traverse(), (TypeReference)new TypeReference<List<RegexAndReplacement>>(){});
                if (useridTransformationRegex != null && !useridTransformationRegex.isEmpty() && !(useridTransformationRegex = useridTransformationRegex.stream().filter(rnr -> !rnr.getRegex().isEmpty() && rnr.getReplacement() != null && !rnr.getReplacement().isEmpty()).collect(Collectors.toList())).isEmpty()) {
                    Transformations transformations = Transformations.createRegexAndReplacement((boolean)toLowerCase, (Transformations.DropOption)option, useridTransformationRegex);
                    return AttributeTransformationConfig.createRequired((Source)source, (Target)target, (Transformations)transformations);
                }
            }
            catch (IOException e) {
                logger.warn("Reading tranformation for {} failed", (Object)fieldName, (Object)e);
            }
        }
        return AttributeTransformationConfig.createRequired((Source)source, (Target)target);
    }

    private void migrateV14toV15(ObjectNode configurationDataNode, HostProduct hostProduct) throws ConfigurationMigrationException {
        JsonConfigurationLoader.updateVersion(configurationDataNode, 14, 15);
        if (hostProduct == HostProduct.JIRA) {
            boolean redirectServiceDeskLogin;
            String KEY_REDIRECT_SERVICE_DESK_PORTALS = "redirectServiceDeskPortals";
            JsonNode redirectServiceDeskLoginNode = configurationDataNode.get("redirectServiceDeskLogin");
            boolean bl = redirectServiceDeskLogin = redirectServiceDeskLoginNode != null && redirectServiceDeskLoginNode.asBoolean();
            if (!redirectServiceDeskLogin) {
                configurationDataNode.set("redirectServiceDeskPortals", (JsonNode)TextNode.valueOf((String)ConfigurationData.RedirectServiceDeskPortals.NONE.name()));
            } else {
                JsonNode serviceDeskPortalsToRedirect = configurationDataNode.get("serviceDeskPortalsToRedirect");
                if (serviceDeskPortalsToRedirect == null || serviceDeskPortalsToRedirect.isEmpty()) {
                    configurationDataNode.set("redirectServiceDeskPortals", (JsonNode)TextNode.valueOf((String)ConfigurationData.RedirectServiceDeskPortals.ALL.name()));
                } else {
                    configurationDataNode.set("redirectServiceDeskPortals", (JsonNode)TextNode.valueOf((String)ConfigurationData.RedirectServiceDeskPortals.SELECTED.name()));
                }
            }
        }
    }

    private void migrateV13toV14(ObjectNode configurationDataNode, HostProduct hostProduct) throws ConfigurationMigrationException {
        JsonConfigurationLoader.updateVersion(configurationDataNode, 13, 14);
    }

    public void migrateV12toV13(ObjectNode configurationDataNode, HostProduct hostProduct) throws ConfigurationMigrationException {
        JsonConfigurationLoader.updateVersion(configurationDataNode, 12, 13);
        logger.warn("Add changes to update from V12 to V13 for {} here...", (Object)hostProduct);
        JsonConfigurationLoader.getIdPs((JsonNode)configurationDataNode).forEach(idp -> {
            JsonNode idpType = idp.get("protocolType");
            if (idpType != null && idpType.asText().equals(ProtocolType.OIDC.toString())) {
                JsonNode oldUserInfoEndpoint = idp.remove("userInfoEndpoint");
                if (oldUserInfoEndpoint != null && !oldUserInfoEndpoint.asText().equalsIgnoreCase("null")) {
                    idp.set("userInfoEndpoints", this.objectMapper.valueToTree(Collections.singletonList(oldUserInfoEndpoint.asText())));
                } else {
                    idp.set("userInfoEndpoints", this.objectMapper.valueToTree(Collections.emptyList()));
                }
            }
        });
    }

    public void migrateV11toV12(ObjectNode configurationDataNode, HostProduct hostProduct) throws ConfigurationMigrationException {
        JsonConfigurationLoader.updateVersion(configurationDataNode, 11, 12);
        configurationDataNode.set("showSelectionPageWhenEmailCookie", (JsonNode)BooleanNode.valueOf((boolean)false));
        JsonNode oldRedirectToSsoFlag = configurationDataNode.remove("overrideLoginUrl");
        if (oldRedirectToSsoFlag != null) {
            configurationDataNode.set("redirectToSso", oldRedirectToSsoFlag);
        } else {
            logger.error("overrideLoginUrl field did not exist during config migration. This should never happen.");
        }
        List<ObjectNode> idps = JsonConfigurationLoader.getIdPs((JsonNode)configurationDataNode);
        idps.forEach(idp -> {
            idp.set("protocolType", (JsonNode)TextNode.valueOf((String)"SAML"));
            JsonNode entityId = idp.remove("entityId");
            if (entityId != null) {
                idp.set("idpId", entityId);
            } else {
                logger.error("There is no entityId. This should not happen. The IdP looks like this: {}", idp);
            }
        });
    }

    public void migrateV10toV11(ObjectNode configurationDataNode, HostProduct hostProduct) throws ConfigurationMigrationException {
        JsonConfigurationLoader.updateVersion(configurationDataNode, 10, 11);
        logger.debug("Add changes to update from V10 to V11 for {} here...", (Object)hostProduct);
        List<ObjectNode> idps = JsonConfigurationLoader.getIdPs((JsonNode)configurationDataNode);
        idps.forEach(idp -> {
            if (idp.get("userSyncConnector") != null) {
                int oldId = idp.get("userSyncConnector").asInt();
                if (oldId == -1) {
                    idp.set("userSyncConnectorUID", (JsonNode)TextNode.valueOf((String)"None"));
                } else {
                    if (!this.userSyncService.isUserSyncInitialized()) {
                        logger.debug("UserSync is not initialized yet, thus init it");
                        this.userSyncService.initUserSync();
                        logger.debug("Is UserSync initialized now? {}", (Object)this.userSyncService.isUserSyncInitialized());
                    }
                    String newConnectorId = this.userSyncService.getConnectorUIDforLegacyId(oldId);
                    logger.debug("Migrating old connector id {} to {}", (Object)oldId, (Object)newConnectorId);
                    idp.set("userSyncConnectorUID", (JsonNode)TextNode.valueOf((String)newConnectorId));
                }
            }
        });
    }

    public void migrateV9toV10(ObjectNode configurationDataNode, HostProduct hostProduct) throws ConfigurationMigrationException {
        JsonConfigurationLoader.updateVersion(configurationDataNode, 9, 10);
        logger.debug("Add changes to update from V9 to V10 for {} here...", (Object)hostProduct);
        List<ObjectNode> idps = JsonConfigurationLoader.getIdPs((JsonNode)configurationDataNode);
        for (ObjectNode idp : idps) {
            AttributeTransformationConfig customerOrgTransformationConfig;
            AttributeTransformationConfig groupTransformationConfig;
            AttributeTransformationConfig fullNameTransformationConfig;
            JsonNode entityIdNode = idp.get("entityId");
            if (entityIdNode != null) {
                idp.set("idpType", (JsonNode)TextNode.valueOf((String)JsonConfigurationLoader.guessIdpType(entityIdNode.asText()).name()));
            }
            if (idp.get(DENY_MESSAGES_SIGNED_WITH_EXPIRED_CERTIFICATES) == null) {
                idp.put(DENY_MESSAGES_SIGNED_WITH_EXPIRED_CERTIFICATES, false);
            }
            String findByAttributeName = "ATTR_NAME";
            JsonNode authenticationAttributeNode = idp.get("authenticationAttribute");
            if (authenticationAttributeNode != null && !authenticationAttributeNode.isNull() && authenticationAttributeNode.asText() != null && !authenticationAttributeNode.asText().trim().isEmpty()) {
                String authenticationAttribute = authenticationAttributeNode.asText();
                if (AuthenticationAttribute.EMAIL.name().equals(authenticationAttribute)) {
                    findByAttributeName = "ATTR_EMAIL";
                }
                if (AuthenticationAttribute.ADDITIONALID.name().equals(authenticationAttribute)) {
                    findByAttributeName = "ATTR_ADDITIONAL_ID";
                }
            }
            idp.set("findByAttributeName", this.objectMapper.valueToTree((Object)findByAttributeName));
            AttributeTransformationConfig userSyncLookupTranformationConfig = this.createAttributeTransformationConfig(idp.get("attributeForUserSyncLookup"), "ATTR_NAMEID", idp.get("userSyncLookupTransformations"), Target.createEmpty(), false);
            if (userSyncLookupTranformationConfig == null) {
                userSyncLookupTranformationConfig = AttributeTransformationConfig.create((String)"ATTR_NAMEID");
            }
            idp.set("userSyncLookupTransformation", this.objectMapper.valueToTree((Object)userSyncLookupTranformationConfig));
            ArrayList<AttributeTransformationConfig> attributeTransformationConfigs = new ArrayList<AttributeTransformationConfig>();
            AttributeTransformationConfig useridTransformationConfig = null;
            if (idp.get("useridMatchesNameId") != null && !idp.get("useridMatchesNameId").asBoolean()) {
                boolean toLowerCase = idp.get("lowercaseConvert") != null && idp.get("lowercaseConvert").asBoolean();
                useridTransformationConfig = this.createAttributeTransformationConfig(idp.get("useridAttribute"), "ATTR_NAMEID", idp.get("useridTransformations"), Target.createSystem((String)"ATTR_NAME"), toLowerCase);
                if (useridTransformationConfig != null) {
                    attributeTransformationConfigs.add(useridTransformationConfig);
                }
            } else {
                useridTransformationConfig = AttributeTransformationConfig.create((String)"ATTR_NAMEID", (Target.Type)Target.Type.SYSTEM, (String)"ATTR_NAME");
                attributeTransformationConfigs.add(useridTransformationConfig);
            }
            String emailAttributeDefaultValue = "ATTR_EMAIL".equals(findByAttributeName) ? "ATTR_NAMEID" : null;
            AttributeTransformationConfig emailTransformationConfig = this.createAttributeTransformationConfig(idp.get("emailAttribute"), emailAttributeDefaultValue, null, Target.createSystem((String)"ATTR_EMAIL"), false);
            if (emailTransformationConfig != null) {
                attributeTransformationConfigs.add(emailTransformationConfig);
            }
            if ((fullNameTransformationConfig = this.createAttributeTransformationConfig(idp.get("fullnameAttribute"), null, null, Target.createSystem((String)"ATTR_FULLNAME"), false)) != null) {
                attributeTransformationConfigs.add(fullNameTransformationConfig);
            }
            String additionalIdAttributeDefaultValue = "ATTR_ADDITIONAL_ID".equals(findByAttributeName) ? "ATTR_NAMEID" : null;
            AttributeTransformationConfig additionalIdTransformationConfig = this.createAttributeTransformationConfig(idp.get("additionalIdAttribute"), additionalIdAttributeDefaultValue, null, Target.createCrowd((String)"ATTR_ADDITIONAL_ID"), false);
            if (additionalIdTransformationConfig != null) {
                attributeTransformationConfigs.add(additionalIdTransformationConfig);
            }
            if ((groupTransformationConfig = this.createAttributeTransformationConfig(idp.get("groupAttribute"), null, idp.get("groupTransformations"), Target.createSystem((String)"ATTR_GROUPS"), idp.get("lowercaseConvertGroups") != null && idp.get("lowercaseConvertGroups").asBoolean(), idp.get("skipUntransformedGroups") != null && idp.get("skipUntransformedGroups").asBoolean() ? Transformations.DropOption.DROP_VALUE_IF_NOT_APPLIED : Transformations.DropOption.NONE)) != null) {
                attributeTransformationConfigs.add(groupTransformationConfig);
            }
            if ((customerOrgTransformationConfig = this.createAttributeTransformationConfig(idp.get("organizationAttribute"), null, idp.get("organizationTransformations"), Target.createSystem((String)"JIRA.ATTR_ORGANIZATIONS"), false, idp.get("skipUntransformedOrganizations") != null && idp.get("skipUntransformedOrganizations").asBoolean() ? Transformations.DropOption.DROP_VALUE_IF_NOT_APPLIED : Transformations.DropOption.NONE)) != null) {
                attributeTransformationConfigs.add(customerOrgTransformationConfig);
            }
            idp.set("attributeTransformations", this.objectMapper.valueToTree(attributeTransformationConfigs));
            if (fullNameTransformationConfig != null && emailTransformationConfig != null && useridTransformationConfig != null) continue;
            idp.set("enableUserCreation", this.objectMapper.valueToTree((Object)false));
        }
    }

    private static void migrateV8toV9(ObjectNode configurationDataNode, HostProduct hostProduct) throws ConfigurationMigrationException {
        JsonConfigurationLoader.updateVersion(configurationDataNode, 8, 9);
        if (hostProduct == HostProduct.JIRA) {
            JsonNode nonSsoNode = configurationDataNode.get(NON_SSO_DESTINATIONS);
            if (nonSsoNode == null) {
                nonSsoNode = JsonNodeFactory.instance.arrayNode();
            }
            if (!(nonSsoNode instanceof ArrayNode)) {
                throw new ConfigurationMigrationException("nonSsoDestiations is no ArrayNode");
            }
            ArrayNode nonSsoArrayNode = (ArrayNode)nonSsoNode;
            ArrayList nonSsoUrls = new ArrayList();
            nonSsoNode.forEach(node -> nonSsoUrls.add(node.textValue()));
            if (!nonSsoUrls.contains(".*/secure/johnson/events/dismiss")) {
                nonSsoArrayNode.add(".*/secure/johnson/events/dismiss");
                configurationDataNode.remove(NON_SSO_DESTINATIONS);
                configurationDataNode.set(NON_SSO_DESTINATIONS, (JsonNode)nonSsoArrayNode);
            }
        }
        for (ObjectNode idpObjectNode : JsonConfigurationLoader.getIdPs((JsonNode)configurationDataNode)) {
            if (idpObjectNode.get(DENY_MESSAGES_SIGNED_WITH_EXPIRED_CERTIFICATES) != null) continue;
            idpObjectNode.put(DENY_MESSAGES_SIGNED_WITH_EXPIRED_CERTIFICATES, false);
        }
    }

    private static void migrateV7toV8(ObjectNode configurationDataNode) throws ConfigurationMigrationException {
        JsonConfigurationLoader.updateVersion(configurationDataNode, 7, 8);
        for (ObjectNode idpObjectNode : JsonConfigurationLoader.getIdPs((JsonNode)configurationDataNode)) {
            SAMLWrapper.ProtocolBindingOfResponse protocolBindingOfResponse = JsonConfigurationLoader.getBoolean((JsonNode)idpObjectNode, "includeProtocolBindingInRequest") ? SAMLWrapper.ProtocolBindingOfResponse.SAME_AS_REQUEST : SAMLWrapper.ProtocolBindingOfResponse.NONE;
            idpObjectNode.put("protocolBindingOfResponse", protocolBindingOfResponse.name());
            idpObjectNode.remove("includeProtocolBindingInRequest");
            idpObjectNode.put("autoReloadMetadata", false);
            if (idpObjectNode.get(DENY_MESSAGES_SIGNED_WITH_EXPIRED_CERTIFICATES) != null) continue;
            idpObjectNode.put(DENY_MESSAGES_SIGNED_WITH_EXPIRED_CERTIFICATES, false);
        }
    }

    private static boolean getBoolean(JsonNode parent, String key) {
        return parent.get(key) != null && parent.get(key).asBoolean();
    }

    private static List<ObjectNode> getIdPs(JsonNode configurationDataNode) throws ConfigurationMigrationException {
        JsonNode idpNodeParent = configurationDataNode.get("idpConfigurations");
        if (idpNodeParent == null) {
            return Collections.emptyList();
        }
        if (!(idpNodeParent instanceof ArrayNode)) {
            throw new ConfigurationMigrationException("idpConfigurations is no ArrayNode");
        }
        ArrayList<ObjectNode> ret = new ArrayList<ObjectNode>();
        for (int i = 0; i < idpNodeParent.size(); ++i) {
            JsonNode idpJsonNode = idpNodeParent.get(i);
            if (!(idpJsonNode instanceof ObjectNode)) {
                throw new ConfigurationMigrationException("idpconfiguration " + i + " is no ObjectNode");
            }
            ret.add((ObjectNode)idpJsonNode);
        }
        return ret;
    }

    public static ObjectNode asObjectNode(JsonNode jsonNode) throws ConfigurationMigrationException {
        if (jsonNode == null) {
            throw new ConfigurationMigrationException("JsonNode must not be null");
        }
        if (!(jsonNode instanceof ObjectNode)) {
            throw new ConfigurationMigrationException("JsonNode must be an ObjectNode but is a " + jsonNode.getClass().getName());
        }
        return (ObjectNode)jsonNode;
    }

    public static int readVersion(JsonNode configNode) {
        JsonNode versionNode = configNode.get(KEY_VERSION);
        if (versionNode == null) {
            return 0;
        }
        return versionNode.asInt();
    }

    public static void updateVersion(ObjectNode configurationDataNode, int expectedVersion, int newVersion) throws ConfigurationMigrationException {
        int actualVersion = JsonConfigurationLoader.readVersion((JsonNode)configurationDataNode);
        if (actualVersion != expectedVersion) {
            throw new ConfigurationMigrationException("Version " + expectedVersion + " was expected, but actual version was " + actualVersion);
        }
        configurationDataNode.remove(KEY_VERSION);
        configurationDataNode.put(KEY_VERSION, newVersion);
    }

    public static IdPType guessIdpType(String entityId) {
        if (entityId == null || entityId.trim().isEmpty()) {
            return IdPType.OTHER;
        }
        if (entityId.contains("okta.com")) {
            return IdPType.OKTA;
        }
        if (entityId.contains("accounts.google.com")) {
            return IdPType.GSUITE;
        }
        if (entityId.contains("/adfs/services/trust")) {
            return IdPType.ADFS;
        }
        if (entityId.contains("sts.windows.net")) {
            return IdPType.AZURE;
        }
        if (entityId.contains("onelogin.com")) {
            return IdPType.ONELOGIN;
        }
        return IdPType.OTHER;
    }
}

