/*
 * Decompiled with CFR 0.152.
 */
package com.resolution.atlasplugins.samlsso.bitbucket.userauth;

import com.atlassian.plugin.spring.scanner.annotation.component.BitbucketComponent;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.resolution.atlasplugins.samlsso.SamlSsoService;
import com.resolution.atlasplugins.samlsso.bitbucket.userauth.SSOTokenStore;
import com.resolution.atlasplugins.samlsso.tracker.AuthenticationTracker;
import com.resolution.atlasplugins.samlsso.userauth.AbstractLoginHandler;
import com.resolution.atlasplugins.samlsso.userauth.PrincipalAndModified;
import com.resolution.atlasplugins.samlsso.userauth.PrincipalProvider;
import com.resolution.samlwrapper.api.exception.LoginHandlerException;
import com.resolution.samlwrapper.api.tracker.SAMLAuthenticationTracker;
import de.resolution.commons.util.StringUtil;
import de.resolution.samlauth.api.AdditionalAuthenticationService;
import jakarta.inject.Inject;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import java.security.Principal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@BitbucketComponent
public class BitbucketLoginHandler
extends AbstractLoginHandler {
    private static final Logger logger = LoggerFactory.getLogger(BitbucketLoginHandler.class);
    private static final Logger customLoginLogger = LoggerFactory.getLogger((String)"com.resolution.atlasplugins.samlsso.userauth.CustomLoginLogger");
    private final SSOTokenStore ssoTokenStore;

    @Inject
    public BitbucketLoginHandler(SamlSsoService samlSsoService, AdditionalAuthenticationService additionalAuthenticationService, PrincipalProvider principalProvider, SSOTokenStore ssoTokenStore, @ComponentImport TemplateRenderer templateRenderer) {
        super(samlSsoService, additionalAuthenticationService, principalProvider, templateRenderer);
        this.ssoTokenStore = ssoTokenStore;
    }

    @Override
    public void doLogin(HttpServletRequest req, HttpServletResponse resp, PrincipalAndModified principalAndModified, String redirectUrl, AuthenticationTracker tracker, String sessionIndex, String nameId, String idpId) throws LoginHandlerException, IOException {
        Principal principal = principalAndModified.getPrincipal();
        if (principal == null) {
            throw new LoginHandlerException("Principal must not be null", (SAMLAuthenticationTracker)tracker);
        }
        String userid = principal.getName();
        if (logger.isInfoEnabled()) {
            logger.info("Starting to log in user {}", (Object)StringUtil.sanitize((String)userid));
        }
        String token = this.ssoTokenStore.getSsoToken(userid);
        HttpSession session = req.getSession(false);
        session.setAttribute("ssoToken", (Object)token);
        session.setAttribute("ssoAuthenticated", (Object)"true");
        tracker.setStatus(SAMLAuthenticationTracker.Status.LOGGED_IN);
        if (customLoginLogger.isDebugEnabled()) {
            customLoginLogger.debug("Successful SSO login for user: {} tracker={}", (Object)principal.getName(), (Object)tracker.getTrackerId());
        }
        resp.setHeader("cache-control", "no-cache, no-store, must-revalidate");
        resp.sendRedirect(redirectUrl);
    }
}

