/*
 * Decompiled with CFR 0.152.
 */
package com.resolution.atlasplugins.samlsso.bitbucket;

import com.atlassian.bitbucket.mail.MailMessage;
import com.atlassian.bitbucket.mail.MailService;
import com.atlassian.plugin.spring.scanner.annotation.component.BitbucketComponent;
import com.atlassian.plugin.spring.scanner.annotation.imports.BitbucketImport;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.UrlMode;
import com.resolution.atlasplugins.samlsso.SendEmailService;
import com.resolution.atlasplugins.samlsso.configuration.RunningConfiguration;
import jakarta.inject.Inject;
import java.util.Collections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@BitbucketComponent
public class BitbucketSendEmailService
implements SendEmailService {
    private static final Logger logger = LoggerFactory.getLogger(BitbucketSendEmailService.class);
    private final MailService mailService;
    private final RunningConfiguration pluginConfiguration;
    private final String fromAddress;

    @Inject
    public BitbucketSendEmailService(@BitbucketImport MailService mailService, RunningConfiguration pluginConfiguration, @BitbucketImport ApplicationProperties applicationProperties) {
        this.mailService = mailService;
        this.pluginConfiguration = pluginConfiguration;
        String baseUrl = applicationProperties.getBaseUrl(UrlMode.CANONICAL);
        String strippedBaseUrl = baseUrl.replaceFirst("http.?://", "");
        this.fromAddress = "noreply@" + strippedBaseUrl;
        logger.debug("Using from address {}", (Object)this.fromAddress);
    }

    @Override
    public void sendEmail(String address, String subject, String body) {
        if (this.mailService.isHostConfigured()) {
            if (this.pluginConfiguration.getAllowedNotificationEmailAddresses().contains(address)) {
                MailMessage mailMessage = new MailMessage(Collections.singleton(address), this.fromAddress, Collections.emptySet(), Collections.emptySet(), Collections.emptySet(), body, subject, Collections.emptyMap());
                this.mailService.submit(mailMessage);
            } else {
                logger.warn("{} is not in the list of allowed addresses, not sending", (Object)address);
            }
        } else {
            logger.debug("Mail host is not configured, not sending emails");
        }
    }
}

